/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.im.controller;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import com.jxdinfo.mp.common.annotation.ApiVersion;
import com.jxdinfo.mp.common.annotation.LoginUser;
import com.jxdinfo.mp.common.model.CurrentLoginUser;
import com.jxdinfo.mp.common.model.PageDTO;
import com.jxdinfo.mp.common.model.Result;
import com.jxdinfo.mp.common.model.RosterVO;
import com.jxdinfo.mp.im.model.EventMsgBean;
import com.jxdinfo.mp.im.model.single.ReceiptVO;
import com.jxdinfo.mp.im.model.single.TimeDO;
import com.jxdinfo.mp.im.service.GroupMessageService;
import com.jxdinfo.mp.im.service.MessageService;
import com.jxdinfo.mp.im.service.PubPlatMessageService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"\u6d88\u606f\u5df2\u8bfb\u672a\u8bfb\u63a7\u5236\u5668"})
@RestController
@ApiVersion
@RequestMapping(value={"/v1/message/receipt"})
public class MessageReceiptController {
    @Resource
    private MessageService messageService;
    @Resource
    private GroupMessageService groupMessageService;
    @Resource
    private PubPlatMessageService pubPlatMessageService;

    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u7a97\u53e3\u4e0b\u5bf9\u65b9\u7684\u67e5\u770b\u65f6\u95f4")
    @GetMapping
    public Result<PageDTO<ReceiptVO>> getReceiptTimeList(@RequestParam(required=false, defaultValue="500") @ApiParam(value="\u5206\u9875\u5927\u5c0f") int pageSize, @RequestParam(required=false, defaultValue="1") @ApiParam(value="\u5f53\u524d\u9875\u6570") int pageNum, @RequestParam @ApiParam(value="\u804a\u5929\u7c7b\u578b") int mode, @RequestParam(value="objid") @ApiParam(value="\u5bf9\u8c61ID") String objID, @ApiIgnore @LoginUser CurrentLoginUser loginUser) {
        PageDTO pageDTO = new PageDTO();
        pageDTO.setPageSize(Integer.valueOf(pageSize));
        pageDTO.setPageNum(Integer.valueOf(pageNum));
        Long loginUserId = loginUser.getId();
        if (mode == 0) {
            ReceiptVO receiptVO = this.messageService.getSingleReceipt(loginUserId.toString(), objID);
            receiptVO.setUserID(objID);
            ArrayList list = CollUtil.newArrayList((Object[])new ReceiptVO[0]);
            list.add(receiptVO);
            pageDTO.setList((List)list);
            pageDTO.setPageCount(Integer.valueOf(1));
            return Result.succeed((Object)pageDTO);
        }
        return Result.succeed((Object)this.groupMessageService.getGroupReceiptList(pageDTO, Long.valueOf(Long.parseLong(objID)), loginUserId));
    }

    @ApiOperation(value="\u66f4\u65b0\u7fa4\u804a\u4e2d\u67d0\u4eba\u5df2\u8bfb\u65f6\u95f4")
    @PostMapping(value={"group"})
    public Result<Boolean> updateGroupUserReceipt(@RequestBody EventMsgBean eventMsgBean) {
        return Result.succeed((Object)this.groupMessageService.updateGroupUserReceipt(Long.valueOf(eventMsgBean.getSenderCode()), Long.valueOf(eventMsgBean.getObjID()), Long.valueOf(eventMsgBean.getEventTime())));
    }

    @ApiOperation(value="\u83b7\u53d6\u7fa4\u804a\u5bf9\u67d0\u6761\u6d88\u606f\u7684\u5df2\u8bfb\u4eba\u5458\u672a\u8bfb\u5217\u8868")
    @GetMapping(value={"user"})
    public Result<PageDTO<RosterVO>> getMessageReceiptUser(@RequestParam(required=false, defaultValue="20") @ApiParam(value="\u5206\u9875\u5927\u5c0f") int pageSize, @RequestParam(required=false, defaultValue="1") @ApiParam(value="\u5f53\u524d\u9875\u6570") int pageNum, @RequestParam(required=false, defaultValue="0") @ApiParam(value="\u4e0a\u6b21\u67e5\u8be2\u65f6\u95f4") String lastTime, @RequestParam @ApiParam(value="0:\u672a\u8bfb\u30011:\u5df2\u8bfb") int type, @RequestParam(value="objid") @ApiParam(value="\u7fa4\u7ec4ID") Long objID, @RequestParam @ApiParam(value="\u6d88\u606f\u7684\u65f6\u95f4") long msgTime, @ApiIgnore @LoginUser CurrentLoginUser currentLoginUser) {
        if (lastTime.equals("0")) {
            lastTime = String.valueOf(DateUtil.current());
        }
        PageDTO pageDTO = new PageDTO();
        pageDTO.setPageSize(Integer.valueOf(pageSize));
        pageDTO.setPageNum(Integer.valueOf(pageNum));
        pageDTO.setLastTime(lastTime);
        return Result.succeed((Object)this.groupMessageService.getMessageReceiptUser(pageDTO, type, msgTime, objID, currentLoginUser.getId()));
    }

    @ApiOperation(value="\u83b7\u53d6\u4e0e\u8be5\u5fae\u5e94\u7528\u5bf9\u8bdd\u72b6\u6001\uff08\u5df2\u8bfb/\u672a\u8bfb\uff09")
    @GetMapping(value={"/read"})
    public Result<List<TimeDO>> getTime(@RequestParam @ApiParam(value="\u5bf9\u8c61ID") String objID, @RequestParam @ApiParam(value="\u7528\u6237ids") List<Long> userIDS) {
        return Result.succeed((Object)this.pubPlatMessageService.getTime(objID, userIDS));
    }
}

