/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.im.controller;

import com.jxdinfo.mp.common.annotation.ApiVersion;
import com.jxdinfo.mp.common.annotation.Permission;
import com.jxdinfo.mp.common.model.AdminEnum;
import com.jxdinfo.mp.common.model.FileVO;
import com.jxdinfo.mp.common.model.PageVO;
import com.jxdinfo.mp.common.model.Result;
import com.jxdinfo.mp.im.model.single.SingleMessageVO;
import com.jxdinfo.mp.im.service.MessageService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6d88\u606f\u76f8\u5173\u63a7\u5236\u5668"})
@RestController
@ApiVersion
@RequestMapping(value={"/v1/message"})
public class MessageManagerController {
    private static final Logger log = LoggerFactory.getLogger(MessageManagerController.class);
    @Resource
    private MessageService messageService;
    @Resource
    public Environment environment;

    @ApiOperation(value="\u83b7\u53d6\u5355\u804a\u5217\u8868")
    @GetMapping(value={"/single/list"})
    @Permission(manage={AdminEnum.JQX_ADMIN_ROLE, AdminEnum.IM_MANAGER_ROLE})
    public Result<PageVO<SingleMessageVO>> getAllSinglePeople(@RequestParam(required=false, defaultValue="20") @ApiParam(value="\u5206\u9875\u5927\u5c0f") int pageSize, @RequestParam(required=false, defaultValue="1") @ApiParam(value="\u5f53\u524d\u9875\u6570") int pageNum, @RequestParam(required=false) @ApiParam(value="\u5173\u952e\u5b57") String searchKey) {
        PageVO singleMessageVOPageVO = new PageVO();
        singleMessageVOPageVO.setPageNum(Integer.valueOf(pageNum));
        singleMessageVOPageVO.setPageSize(Integer.valueOf(pageSize));
        return Result.succeed((Object)this.messageService.getAllSinglePeople(singleMessageVOPageVO, searchKey));
    }

    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u6587\u4ef6\u5217\u8868")
    @GetMapping(value={"/file/list"})
    @Permission(manage={AdminEnum.JQX_ADMIN_ROLE, AdminEnum.IM_MANAGER_ROLE})
    public Result<PageVO<FileVO>> getMessageFileList(@RequestParam(required=false) @ApiParam(value="\u804a\u5929\u7c7b\u578b") Integer mode, @RequestParam(required=false, defaultValue="20") @ApiParam(value="\u5206\u9875\u5927\u5c0f") int pageSize, @RequestParam(required=false, defaultValue="1") @ApiParam(value="\u5f53\u524d\u9875\u6570") int pageNum, @RequestParam(required=false) @ApiParam(value="\u5173\u952e\u5b57") String searchKey) {
        PageVO singleMessageVOPageVO = new PageVO();
        singleMessageVOPageVO.setPageNum(Integer.valueOf(pageNum));
        singleMessageVOPageVO.setPageSize(Integer.valueOf(pageSize));
        return Result.succeed((Object)this.messageService.getMessageFileList(singleMessageVOPageVO, searchKey, mode));
    }

    @ApiOperation(value="\u5220\u9664\u4e2a\u4eba\u4e0e\u597d\u53cb\u804a\u5929\u8bb0\u5f55")
    @GetMapping(value={"/file/{msgId}"})
    @Permission(manage={AdminEnum.JQX_ADMIN_ROLE, AdminEnum.IM_MANAGER_ROLE})
    public Result<Boolean> getSingleMessage(@PathVariable @ApiParam(value="\u7528\u6237ID") String msgId) {
        return Result.succeed((Object)this.messageService.deleteMessageFile(msgId));
    }
}

