/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.ad.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.enums.SqlMethod;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.mp.ad.dao.AdMapper;
import com.jxdinfo.mp.ad.model.ad.AdInfoDO;
import com.jxdinfo.mp.ad.model.ad.AdVO;
import com.jxdinfo.mp.ad.model.position.AdPositionInfoDO;
import com.jxdinfo.mp.ad.service.AdPositionService;
import com.jxdinfo.mp.ad.service.AdService;
import com.jxdinfo.mp.common.model.PageDTO;
import com.jxdinfo.mp.common.model.Result;
import com.jxdinfo.mp.common.utils.StringUtil;
import com.jxdinfo.mp.im.model.material.ArticleDO;
import com.jxdinfo.mp.im.model.material.ArticleVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.ibatis.session.SqlSession;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@HussarTokenDs
public class AdServiceImpl
extends ServiceImpl<AdMapper, AdInfoDO>
implements AdService {
    @Resource
    private AdPositionService adPositionService;
    @Resource
    private AdMapper adMapper;
    @Resource
    private ISysApplicationService sysApplicationService;

    public List<AdVO> getAdInfoByPositionId(String positionId) {
        AdPositionInfoDO adPositionInfoDO = (AdPositionInfoDO)this.adPositionService.getById((Serializable)((Object)positionId));
        if (adPositionInfoDO == null) {
            return new ArrayList<AdVO>();
        }
        if (!"1".equals(adPositionInfoDO.getDataStatus())) {
            return new ArrayList<AdVO>();
        }
        Integer showCount = adPositionInfoDO.getShowCount();
        if (showCount == null) {
            showCount = 1;
        }
        String currentTime = DateUtil.now();
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)queryWrapper.like((Object)"POSITION_ID", (Object)positionId)).and(wrapper -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"DATA_STATUS", (Object)1)).or()).isNull((Object)"DATA_STATUS");
        })).ge((Object)"END_TIME", (Object)currentTime)).le((Object)"START_TIME", (Object)currentTime)).orderByDesc((Object)"LAST_TIME");
        return this.adMapper.getAdInfoByPositionId((Wrapper<AdInfoDO>)queryWrapper).stream().limit(showCount.intValue()).collect(Collectors.toList());
    }

    public ArticleVO getAdInfoByObjId(String objId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"MSG_ID", (Object)objId);
        ArticleDO articleDO = this.adMapper.getAdInfoByObjId((Wrapper<ArticleDO>)queryWrapper);
        ArticleVO articleVO = new ArticleVO();
        BeanUtils.copyProperties((Object)articleDO, (Object)articleVO);
        return articleVO;
    }

    public List<AdVO> getAdInfo() {
        AdPositionInfoDO adPositionInfo;
        String dataStatus;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"POSITION_ID", (Object)"605D1B88-34ED-45F7-A504-A003D4BABE7F");
        List adPositionInfos = this.adPositionService.list((Wrapper)queryWrapper);
        List<Object> adBeanList = new ArrayList();
        if (adPositionInfos != null && adPositionInfos.size() > 0 && !"0".equals(dataStatus = (adPositionInfo = (AdPositionInfoDO)adPositionInfos.get(0)).getDataStatus())) {
            String currentTime = DateUtil.now();
            Integer showCount = adPositionInfo.getShowCount();
            QueryWrapper queryWrapper2 = new QueryWrapper();
            ((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)queryWrapper2.and(wrapper -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)wrapper.like((Object)"POSITION_ID", (Object)"605D1B88-34ED-45F7-A504-A003D4BABE7F")).eq((Object)"DATA_STATUS", (Object)1);
            })).or()).isNull((Object)"DATA_STATUS")).ge((Object)"END_TIME", (Object)currentTime)).le((Object)"START_TIME", (Object)currentTime)).eq((Object)"LINK_TYPE", (Object)"1")).orderByDesc((Object)"LAST_TIME")).last("limit 1");
            adBeanList = this.adMapper.getAdInfoByPositionId((Wrapper<AdInfoDO>)queryWrapper2);
        }
        AdVO adBean = new AdVO();
        if (adBeanList != null && adBeanList.size() > 0) {
            adBean = (AdVO)adBeanList.get(0);
        }
        ArrayList<AdVO> list = new ArrayList<AdVO>();
        list.add(adBean);
        return list;
    }

    public String getAdFilePathById(String adID) {
        return this.adMapper.getAdFilePath(adID);
    }

    public AdVO getAdInfoByadId(String adID, String outUrl) {
        AdVO adVO = this.adMapper.getAdInfoByadId(adID);
        adVO.setUrlShow(adVO.getAdLinkUrl());
        List<String> positions = Arrays.asList(adVO.getPositionId().split(","));
        List adPositionInfoDOList = this.adPositionService.list((Wrapper)new LambdaQueryWrapper().in(AdPositionInfoDO::getObjId, positions));
        adVO.setPositionName(adPositionInfoDOList.stream().map(AdPositionInfoDO::getPositionName).collect(Collectors.joining(",")));
        String linkUrl = adVO.getAdLinkUrl();
        if (AdVO.LinkType.ADHYBRIDLINK.equals((Object)adVO.getAdLinkType())) {
            String pubName = this.adMapper.getPubplatName(adVO.getAdLinkUrl());
            if (pubName != null && !pubName.isEmpty()) {
                adVO.setLinkName(pubName);
            } else {
                adVO.setLinkName("\u6b64\u5e7f\u544a\u4e0d\u5b58\u5728");
            }
        }
        if (AdVO.LinkType.ADWEBLINK.equals((Object)adVO.getAdLinkType())) {
            if (!linkUrl.contains(outUrl)) {
                adVO.setLinkOut(Integer.valueOf(1));
            } else {
                adVO.setLinkOut(Integer.valueOf(0));
                if (linkUrl.contains("objId=")) {
                    int strStartIndex = linkUrl.indexOf("=");
                    int strEndIndex = linkUrl.length();
                    if (linkUrl.contains("&shareType")) {
                        strEndIndex = linkUrl.indexOf("&");
                    }
                    String objId = linkUrl.substring(strStartIndex + 1, strEndIndex);
                    String linkUrlid = linkUrl.contains("&companyId") ? linkUrl.substring(strStartIndex + 1, linkUrl.lastIndexOf("&")) : linkUrl.substring(strStartIndex + 1);
                    if (HussarUtils.isNotEmpty((Object)objId)) {
                        String name = this.adMapper.getResourceName(objId);
                        if (!"".equals(name) && name != null) {
                            adVO.setUrlShow(name);
                            adVO.setAdLinkUrl(linkUrlid);
                        } else {
                            adVO.setUrlShow("\u6b64\u8d44\u6e90\u4e0d\u5b58\u5728");
                        }
                    }
                }
            }
        }
        return adVO;
    }

    public PageDTO<AdVO> getAdInfoPage(PageDTO pageDTO, String title, String linkType, String positionId) {
        ArrayList<String> positionIdList = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)positionId)) {
            positionIdList = Arrays.asList(positionId.split(","));
        }
        PageDTO<AdVO> adInfoPage = this.adMapper.getAdInfoPage(pageDTO, StringUtil.replaceSpecialChar((String)title), linkType, positionIdList);
        adInfoPage.getList().forEach(n -> {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.in((Object)"POSITION_ID", Arrays.asList(n.getPositionId().split(",")));
            List adPositionInfoDOList = this.adPositionService.list((Wrapper)queryWrapper);
            n.setPositionName(adPositionInfoDOList.stream().map(m -> m.getPositionName()).collect(Collectors.joining(",")));
        });
        return adInfoPage;
    }

    @Transactional
    public Result<Boolean> moveAD(String adID, String flag, String adID2) {
        if (StrUtil.isEmpty((CharSequence)adID2)) {
            AdInfoDO adInfoDO1;
            AdInfoDO adInfoDO;
            if (this.judge(adID, flag)) {
                if ("up".equals(flag)) {
                    return Result.succeed((Object)false, (String)"\u5df2\u7ecf\u5230\u9876\u4e86");
                }
                return Result.succeed((Object)false, (String)"\u5df2\u7ecf\u5230\u5e95\u4e86");
            }
            List<AdInfoDO> list = this.getAdByIDs(adID, flag, "");
            if ("up".equals(flag)) {
                adInfoDO = list.get(list.size() - 1);
                adInfoDO1 = list.get(list.size() - 2);
            } else {
                adInfoDO = list.get(0);
                adInfoDO1 = list.get(1);
            }
            int order1 = adInfoDO.getShowOrder();
            int order2 = adInfoDO1.getShowOrder();
            adInfoDO.setShowOrder(Integer.valueOf(order2));
            adInfoDO1.setShowOrder(Integer.valueOf(order1));
            super.saveOrUpdate((Object)adInfoDO);
            super.saveOrUpdate((Object)adInfoDO1);
            return Result.succeed((Object)true);
        }
        List<AdInfoDO> list = this.getAdByIDs(adID, flag, adID2);
        if ("up".equals(flag)) {
            AdInfoDO adInfoDO1;
            AdInfoDO adInfoDO;
            if (list.isEmpty()) {
                adInfoDO = (AdInfoDO)super.getById((Serializable)((Object)adID));
                adInfoDO1 = (AdInfoDO)super.getById((Serializable)((Object)adID2));
            } else {
                adInfoDO = list.get(list.size() - 1);
                adInfoDO1 = list.get(0);
            }
            adInfoDO.setShowOrder(adInfoDO1.getShowOrder());
            super.saveOrUpdate((Object)adInfoDO);
            for (int i = 0; i < list.size() - 1; ++i) {
                AdInfoDO adInfoDO2 = list.get(i);
                adInfoDO2.setShowOrder(Integer.valueOf(adInfoDO2.getShowOrder() + 1));
                super.saveOrUpdate((Object)adInfoDO2);
            }
        } else {
            AdInfoDO adInfoDO1;
            AdInfoDO adInfoDO;
            if (list.isEmpty()) {
                adInfoDO = (AdInfoDO)super.getById((Serializable)((Object)adID));
                adInfoDO1 = (AdInfoDO)super.getById((Serializable)((Object)adID2));
            } else {
                adInfoDO = list.get(0);
                adInfoDO1 = list.get(list.size() - 1);
            }
            adInfoDO.setShowOrder(adInfoDO1.getShowOrder());
            super.saveOrUpdate((Object)adInfoDO);
            for (int i = 1; i < list.size(); ++i) {
                AdInfoDO adInfoDO2 = list.get(i);
                adInfoDO2.setShowOrder(Integer.valueOf(adInfoDO2.getShowOrder() - 1));
                super.saveOrUpdate((Object)adInfoDO2);
            }
        }
        return Result.succeed((Object)true);
    }

    public List<AdInfoDO> getAdByIDs(String adID, String flag, String adID2) {
        AdInfoDO adInfoDO = (AdInfoDO)super.getById((Serializable)((Object)adID));
        AdInfoDO adInfoDO1 = new AdInfoDO();
        if (StrUtil.isNotEmpty((CharSequence)adID2)) {
            adInfoDO1 = (AdInfoDO)super.getById((Serializable)((Object)adID2));
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        if ("up".equals(flag)) {
            queryWrapper.le((Object)"SHOW_ORDER", (Object)adInfoDO.getShowOrder());
            if (StrUtil.isNotEmpty((CharSequence)adID2)) {
                queryWrapper.ge((Object)"SHOW_ORDER", (Object)adInfoDO1.getShowOrder());
            }
        } else {
            queryWrapper.ge((Object)"SHOW_ORDER", (Object)adInfoDO.getShowOrder());
            if (StrUtil.isNotEmpty((CharSequence)adID2)) {
                queryWrapper.le((Object)"SHOW_ORDER", (Object)adInfoDO1.getShowOrder());
            }
        }
        queryWrapper.orderByAsc((Object)"SHOW_ORDER");
        return super.list((Wrapper)queryWrapper);
    }

    private boolean judge(String adID, String flag) {
        AdInfoDO adInfoDO = (AdInfoDO)super.getById((Serializable)((Object)adID));
        int showOrder = adInfoDO.getShowOrder();
        QueryWrapper queryWrapper = new QueryWrapper();
        if ("up".equals(flag)) {
            queryWrapper.lt((Object)"SHOW_ORDER", (Object)showOrder);
        } else {
            queryWrapper.gt((Object)"SHOW_ORDER", (Object)showOrder);
        }
        return super.count((Wrapper)queryWrapper) <= 0L;
    }

    public AdMapper getBaseMapper() {
        return (AdMapper)super.getBaseMapper();
    }

    protected boolean retBool(Integer result) {
        return super.retBool(result);
    }

    protected Class<AdInfoDO> currentModelClass() {
        return super.currentModelClass();
    }

    protected SqlSession sqlSessionBatch() {
        return super.sqlSessionBatch();
    }

    protected void closeSqlSession(SqlSession sqlSession) {
        super.closeSqlSession(sqlSession);
    }

    protected String sqlStatement(SqlMethod sqlMethod) {
        return super.sqlStatement(sqlMethod);
    }

    public boolean save(AdInfoDO entity) {
        return super.save((Object)entity);
    }

    public boolean saveBatch(Collection<AdInfoDO> entityList, int batchSize) {
        return super.saveBatch(entityList, batchSize);
    }

    public boolean saveOrUpdate(AdInfoDO entity) {
        return super.saveOrUpdate((Object)entity);
    }

    public boolean saveOrUpdateBatch(Collection<AdInfoDO> entityList, int batchSize) {
        return super.saveOrUpdateBatch(entityList, batchSize);
    }

    public boolean removeById(Serializable id) {
        return super.removeById(id);
    }

    public boolean removeByMap(Map<String, Object> columnMap) {
        return super.removeByMap(columnMap);
    }

    public boolean remove(Wrapper<AdInfoDO> wrapper) {
        return super.remove(wrapper);
    }

    public boolean removeByIds(Collection<?> idList) {
        return super.removeByIds(idList);
    }

    public boolean updateById(AdInfoDO entity) {
        return super.updateById((Object)entity);
    }

    public boolean update(AdInfoDO entity, Wrapper<AdInfoDO> updateWrapper) {
        return super.update((Object)entity, updateWrapper);
    }

    public boolean updateBatchById(Collection<AdInfoDO> entityList, int batchSize) {
        return super.updateBatchById(entityList, batchSize);
    }

    public AdInfoDO getById(Serializable id) {
        return (AdInfoDO)super.getById(id);
    }

    public List<AdInfoDO> listByIds(Collection<? extends Serializable> idList) {
        return super.listByIds(idList);
    }

    public List<AdInfoDO> listByMap(Map<String, Object> columnMap) {
        return super.listByMap(columnMap);
    }

    public AdInfoDO getOne(Wrapper<AdInfoDO> queryWrapper, boolean throwEx) {
        return (AdInfoDO)super.getOne(queryWrapper, throwEx);
    }

    public Map<String, Object> getMap(Wrapper<AdInfoDO> queryWrapper) {
        return super.getMap(queryWrapper);
    }

    public long count(Wrapper<AdInfoDO> queryWrapper) {
        return super.count(queryWrapper);
    }

    public List<AdInfoDO> list(Wrapper<AdInfoDO> queryWrapper) {
        return super.list(queryWrapper);
    }

    public <E extends IPage<AdInfoDO>> E page(E page, Wrapper<AdInfoDO> queryWrapper) {
        return (E)super.page(page, queryWrapper);
    }

    public List<Map<String, Object>> listMaps(Wrapper<AdInfoDO> queryWrapper) {
        return super.listMaps(queryWrapper);
    }

    public <V> List<V> listObjs(Wrapper<AdInfoDO> queryWrapper, Function<? super Object, V> mapper) {
        return super.listObjs(queryWrapper, mapper);
    }

    public <E extends IPage<Map<String, Object>>> E pageMaps(E page, Wrapper<AdInfoDO> queryWrapper) {
        return (E)super.pageMaps(page, queryWrapper);
    }

    public <V> V getObj(Wrapper<AdInfoDO> queryWrapper, Function<? super Object, V> mapper) {
        return (V)super.getObj(queryWrapper, mapper);
    }
}

