/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.common.resolver;

import cn.hutool.core.util.StrUtil;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.mp.common.annotation.LoginUser;
import com.jxdinfo.mp.common.model.CurrentLoginUser;
import com.jxdinfo.mp.common.model.Role;
import com.jxdinfo.mp.common.utils.ApplicationContextProvider;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class TokenArgumentResolver
implements HandlerMethodArgumentResolver {
    private static final Logger log = LoggerFactory.getLogger(TokenArgumentResolver.class);
    @Resource
    private RedisTemplate redisTemplate;

    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(LoginUser.class) && parameter.getParameterType().equals(CurrentLoginUser.class);
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) {
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        if (HussarUtils.isEmpty((Object)securityUser)) {
            throw new HussarException("\u672a\u83b7\u53d6\u5230\u767b\u5f55\u7528\u6237\u4fe1\u606f");
        }
        HttpServletRequest request = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
        String accessToken = request.getHeader("Authorization");
        if (StrUtil.isBlank((CharSequence)accessToken)) {
            log.error("resolveArgument error accessToken is empty");
            return null;
        }
        if (this.redisTemplate == null) {
            this.redisTemplate = ApplicationContextProvider.getBean("redisTemplate", RedisTemplate.class);
        }
        CurrentLoginUser currentLoginUser = new CurrentLoginUser();
        BeanUtil.copyProperties((Object)securityUser, (Object)currentLoginUser);
        LoginUser loginUser = (LoginUser)parameter.getParameterAnnotation(LoginUser.class);
        boolean isFull = loginUser.isFull();
        if (isFull) {
            SecurityUser user = BaseSecurityUtil.getUser();
            List rolesList = HussarUtils.isNotEmpty((Object)user) ? user.getRolesList() : new ArrayList();
            List rolesNames = HussarUtils.isNotEmpty((Object)user) ? user.getRoleNames() : new ArrayList();
            ArrayList<Role> roles = new ArrayList<Role>();
            if (HussarUtils.isNotEmpty((Object)rolesList)) {
                for (int i = 0; i < rolesList.size(); ++i) {
                    Role role = new Role();
                    role.setRoleId((Long)rolesList.get(i));
                    role.setRoleName(HussarUtils.isNotEmpty((Object)rolesNames) ? (String)rolesNames.get(i) : "");
                    roles.add(role);
                }
            }
            currentLoginUser.setRoles(roles);
        }
        return currentLoginUser;
    }
}

