/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.matlab.mat.ejml;

import java.util.function.Supplier;
import org.ejml.data.DMatrixSparseCSC;
import org.ejml.data.FMatrixSparseCSC;
import us.hebi.matlab.mat.types.Sparse;

abstract class SparseToCscConverter
implements Sparse.SparseConsumer {
    private static final ThreadLocal<SparseToFCscConverter> fCscConverter = ThreadLocal.withInitial(new Supplier<SparseToFCscConverter>(){

        @Override
        public SparseToFCscConverter get() {
            return new SparseToFCscConverter();
        }
    });
    private static final ThreadLocal<SparseToDCscConverter> dCscConverter = ThreadLocal.withInitial(new Supplier<SparseToDCscConverter>(){

        @Override
        public SparseToDCscConverter get() {
            return new SparseToDCscConverter();
        }
    });
    float[] fValues;
    double[] dValues;
    private int[] col_idx;
    private int[] nz_rows;
    private int valueIx;
    private int lastColIx;

    SparseToCscConverter() {
    }

    static void convertToFMatrixSparseCSC(Sparse input, FMatrixSparseCSC output) {
        fCscConverter.get().convertToFSparseCSC(input, output);
    }

    static void convertToDMatrixSparseCSC(Sparse input, DMatrixSparseCSC output) {
        dCscConverter.get().convertToDSparseCSC(input, output);
    }

    void initializeConversion(int[] col_idx, int[] nz_rows, float[] fValues, double[] dValues) {
        this.col_idx = col_idx;
        this.nz_rows = nz_rows;
        this.fValues = fValues;
        this.dValues = dValues;
        this.valueIx = 0;
        this.lastColIx = 0;
    }

    void finishConversion(int numCols) {
        this.setEmptyColumnsUntil(numCols);
        this.col_idx = null;
        this.nz_rows = null;
        this.fValues = null;
        this.dValues = null;
    }

    public void accept(int row, int col, double real, double imaginary) {
        this.nz_rows[this.valueIx] = row;
        this.setValue(this.valueIx, real);
        this.setEmptyColumnsUntil(col);
        this.col_idx[col + 1] = this.valueIx + 1;
        ++this.valueIx;
        this.lastColIx = col;
    }

    protected abstract void setValue(int var1, double var2);

    private void setEmptyColumnsUntil(int col) {
        while (this.lastColIx < col) {
            this.col_idx[this.lastColIx + 1] = this.valueIx;
            ++this.lastColIx;
        }
    }

    static class SparseToDCscConverter
    extends SparseToCscConverter {
        SparseToDCscConverter() {
        }

        void convertToDSparseCSC(Sparse input, DMatrixSparseCSC output) {
            output.reshape(input.getNumRows(), input.getNumCols(), input.getNzMax());
            this.initializeConversion(output.col_idx, output.nz_rows, null, output.nz_values);
            input.forEach((Sparse.SparseConsumer)this);
            this.finishConversion(output.getNumCols());
            output.indicesSorted = true;
        }

        @Override
        protected void setValue(int nzIndex, double value) {
            this.dValues[nzIndex] = value;
        }
    }

    static class SparseToFCscConverter
    extends SparseToCscConverter {
        SparseToFCscConverter() {
        }

        void convertToFSparseCSC(Sparse input, FMatrixSparseCSC output) {
            output.reshape(input.getNumRows(), input.getNumCols(), input.getNzMax());
            this.initializeConversion(output.col_idx, output.nz_rows, output.nz_values, null);
            input.forEach((Sparse.SparseConsumer)this);
            this.finishConversion(output.getNumCols());
            output.indicesSorted = true;
        }

        @Override
        protected void setValue(int nzIndex, double value) {
            this.fValues[nzIndex] = (float)value;
        }
    }
}

