/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.matlab.mat.ejml;

import java.util.Arrays;
import org.ejml.data.BMatrixRMaj;
import org.ejml.data.CMatrix;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixSparseCSC;
import org.ejml.data.DMatrixSparseTriplet;
import org.ejml.data.FMatrix;
import org.ejml.data.FMatrixSparseCSC;
import org.ejml.data.FMatrixSparseTriplet;
import org.ejml.data.MatrixSparse;
import org.ejml.data.ReshapeMatrix;
import org.ejml.data.ZMatrix;
import org.ejml.data.ZMatrixD1;
import us.hebi.matlab.mat.ejml.BMatrixRMajWrapper;
import us.hebi.matlab.mat.ejml.CMatrixWrapper;
import us.hebi.matlab.mat.ejml.DMatrixSparseCSCWrapper;
import us.hebi.matlab.mat.ejml.DMatrixWrapper;
import us.hebi.matlab.mat.ejml.FMatrixSparseCSCWrapper;
import us.hebi.matlab.mat.ejml.FMatrixWrapper;
import us.hebi.matlab.mat.ejml.SparseToCscConverter;
import us.hebi.matlab.mat.ejml.ZMatrixWrapper;
import us.hebi.matlab.mat.types.Array;
import us.hebi.matlab.mat.types.Matrix;
import us.hebi.matlab.mat.types.Sparse;
import us.hebi.matlab.mat.util.Preconditions;

public class Mat5Ejml {
    public static Array asArray(org.ejml.data.Matrix matrix) {
        Preconditions.checkNotNull((Object)matrix, (Object)"Input matrix can't be null");
        if (matrix instanceof DMatrixSparseCSC) {
            return new DMatrixSparseCSCWrapper((DMatrixSparseCSC)matrix);
        }
        if (matrix instanceof FMatrixSparseCSC) {
            return new FMatrixSparseCSCWrapper((FMatrixSparseCSC)matrix);
        }
        if (matrix instanceof MatrixSparse) {
            throw new IllegalArgumentException("Unsupported Sparse Matrix Type: " + matrix.getClass().getSimpleName());
        }
        if (matrix instanceof DMatrix) {
            return new DMatrixWrapper((DMatrix)matrix);
        }
        if (matrix instanceof FMatrix) {
            return new FMatrixWrapper((FMatrix)matrix);
        }
        if (matrix instanceof ZMatrix) {
            return new ZMatrixWrapper((ZMatrix)matrix);
        }
        if (matrix instanceof CMatrix) {
            return new CMatrixWrapper((CMatrix)matrix);
        }
        if (matrix instanceof BMatrixRMaj) {
            return new BMatrixRMajWrapper((BMatrixRMaj)matrix);
        }
        throw new IllegalArgumentException("Unsupported Dense Matrix Type: " + matrix.getClass().getSimpleName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T extends org.ejml.data.Matrix> T convert(Array input, T output) {
        Preconditions.checkNotNull((Object)input, (Object)"Input array can't be null");
        Preconditions.checkNotNull(output, (Object)"Output matrix can't be null");
        Preconditions.checkArgument((boolean)(input instanceof Matrix), (Object)"Input Array is not a Matrix type");
        Matrix array = (Matrix)input;
        Mat5Ejml.reshapeOutputSize(array, output);
        if (array instanceof Sparse && output instanceof MatrixSparse) {
            if (output instanceof DMatrixSparseCSC) {
                Mat5Ejml.convertToDMatrixSparseCSC((Sparse)array, (DMatrixSparseCSC)output);
                return output;
            } else if (output instanceof FMatrixSparseCSC) {
                Mat5Ejml.convertToFMatrixSparseCSC((Sparse)array, (FMatrixSparseCSC)output);
                return output;
            } else if (output instanceof DMatrixSparseTriplet) {
                Mat5Ejml.convertToDMatrixSparseTriplet((Sparse)array, (DMatrixSparseTriplet)output);
                return output;
            } else {
                if (!(output instanceof FMatrixSparseTriplet)) throw new IllegalArgumentException("Unsupported sparse output type: " + output.getClass());
                Mat5Ejml.convertToFMatrixSparseTriplet((Sparse)array, (FMatrixSparseTriplet)output);
            }
            return output;
        } else if (array instanceof Sparse && output instanceof DMatrixD1) {
            Mat5Ejml.convertToDMatrix((Sparse)array, (DMatrixD1)output);
            return output;
        } else if (array instanceof Sparse && output instanceof ZMatrixD1) {
            Mat5Ejml.convertToZMatrix((Sparse)array, (ZMatrixD1)output);
            return output;
        } else if (output instanceof DMatrix) {
            Mat5Ejml.convertToDMatrix(array, (DMatrix)output);
            return output;
        } else if (output instanceof ZMatrix) {
            Mat5Ejml.convertToZMatrix(array, (ZMatrix)output);
            return output;
        } else if (output instanceof FMatrix) {
            Mat5Ejml.convertToFMatrix(array, (FMatrix)output);
            return output;
        } else if (output instanceof CMatrix) {
            Mat5Ejml.convertToCMatrix(array, (CMatrix)output);
            return output;
        } else {
            if (!(output instanceof BMatrixRMaj)) throw new IllegalArgumentException("Unsupported dense output type: " + output.getClass());
            Mat5Ejml.convertToBMatrixRMaj(array, (BMatrixRMaj)output);
        }
        return output;
    }

    private static void reshapeOutputSize(Matrix input, org.ejml.data.Matrix output) {
        Preconditions.checkNotNull((Object)input);
        Preconditions.checkNotNull((Object)output);
        Preconditions.checkArgument((input.getNumDimensions() == 2 ? 1 : 0) != 0, (Object)"EJML only supports 2D matrices");
        if (input.getNumRows() != output.getNumRows() || input.getNumCols() != output.getNumCols()) {
            if (input instanceof Sparse && output instanceof MatrixSparse) {
                ((MatrixSparse)output).reshape(input.getNumRows(), input.getNumCols(), ((Sparse)input).getNzMax());
            } else if (output instanceof ReshapeMatrix) {
                ((ReshapeMatrix)output).reshape(input.getNumRows(), input.getNumCols());
            } else {
                throw new IllegalArgumentException("Output matrix has incorrect size and can't be reshaped");
            }
        }
    }

    private static void convertToBMatrixRMaj(Matrix input, BMatrixRMaj output) {
        Mat5Ejml.reshapeOutputSize(input, (org.ejml.data.Matrix)output);
        int rows = input.getNumRows();
        int cols = input.getNumCols();
        for (int col = 0; col < cols; ++col) {
            for (int row = 0; row < rows; ++row) {
                output.unsafe_set(row, col, input.getBoolean(row, col));
            }
        }
    }

    private static void convertToFMatrix(Matrix input, FMatrix output) {
        Mat5Ejml.reshapeOutputSize(input, (org.ejml.data.Matrix)output);
        int rows = input.getNumRows();
        int cols = input.getNumCols();
        for (int col = 0; col < cols; ++col) {
            for (int row = 0; row < rows; ++row) {
                output.unsafe_set(row, col, input.getFloat(row, col));
            }
        }
    }

    private static void convertToDMatrix(Matrix input, DMatrix output) {
        Mat5Ejml.reshapeOutputSize(input, (org.ejml.data.Matrix)output);
        int rows = input.getNumRows();
        int cols = input.getNumCols();
        for (int col = 0; col < cols; ++col) {
            for (int row = 0; row < rows; ++row) {
                output.unsafe_set(row, col, input.getDouble(row, col));
            }
        }
    }

    private static void convertToCMatrix(Matrix input, CMatrix output) {
        Mat5Ejml.reshapeOutputSize(input, (org.ejml.data.Matrix)output);
        int rows = input.getNumRows();
        int cols = input.getNumCols();
        for (int col = 0; col < cols; ++col) {
            for (int row = 0; row < rows; ++row) {
                output.setReal(row, col, input.getFloat(row, col));
                output.setImag(row, col, input.getImaginaryFloat(row, col));
            }
        }
    }

    private static void convertToZMatrix(Matrix input, ZMatrix output) {
        Mat5Ejml.reshapeOutputSize(input, (org.ejml.data.Matrix)output);
        int rows = input.getNumRows();
        int cols = input.getNumCols();
        for (int col = 0; col < cols; ++col) {
            for (int row = 0; row < rows; ++row) {
                output.setReal(row, col, input.getDouble(row, col));
                output.setImag(row, col, input.getImaginaryDouble(row, col));
            }
        }
    }

    private static void convertToDMatrix(Sparse input, final DMatrixD1 output) {
        Mat5Ejml.reshapeOutputSize((Matrix)input, (org.ejml.data.Matrix)output);
        Arrays.fill(output.data, 0, output.getNumElements(), 0.0);
        input.forEach(new Sparse.SparseConsumer(){

            public void accept(int row, int col, double real, double imaginary) {
                output.unsafe_set(row, col, real);
            }
        });
    }

    private static void convertToZMatrix(Sparse input, final ZMatrixD1 output) {
        Mat5Ejml.reshapeOutputSize((Matrix)input, (org.ejml.data.Matrix)output);
        Arrays.fill(output.data, 0, output.getDataLength(), 0.0);
        input.forEach(new Sparse.SparseConsumer(){

            public void accept(int row, int col, double real, double imaginary) {
                output.setReal(row, col, real);
                output.setImag(row, col, imaginary);
            }
        });
    }

    private static void convertToFMatrixSparseTriplet(Sparse input, final FMatrixSparseTriplet output) {
        Mat5Ejml.reshapeOutputSize((Matrix)input, (org.ejml.data.Matrix)output);
        output.zero();
        input.forEach(new Sparse.SparseConsumer(){

            public void accept(int row, int col, double real, double imaginary) {
                output.addItem(row, col, (float)real);
            }
        });
    }

    private static void convertToDMatrixSparseTriplet(Sparse input, final DMatrixSparseTriplet output) {
        Mat5Ejml.reshapeOutputSize((Matrix)input, (org.ejml.data.Matrix)output);
        output.zero();
        input.forEach(new Sparse.SparseConsumer(){

            public void accept(int row, int col, double real, double imaginary) {
                output.addItem(row, col, real);
            }
        });
    }

    private static void convertToFMatrixSparseCSC(Sparse input, FMatrixSparseCSC output) {
        SparseToCscConverter.convertToFMatrixSparseCSC(input, output);
    }

    private static void convertToDMatrixSparseCSC(Sparse input, DMatrixSparseCSC output) {
        SparseToCscConverter.convertToDMatrixSparseCSC(input, output);
    }
}

