/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.matlab.mat.ejml;

import java.io.IOException;
import org.ejml.data.FMatrixSparseCSC;
import us.hebi.matlab.mat.ejml.AbstractMatrixWrapper;
import us.hebi.matlab.mat.format.Mat5Type;
import us.hebi.matlab.mat.types.MatlabType;
import us.hebi.matlab.mat.types.Sink;

class FMatrixSparseCSCWrapper
extends AbstractMatrixWrapper<FMatrixSparseCSC> {
    @Override
    protected int getMat5DataSize() {
        return Mat5Type.Int32.computeSerializedSize(this.getNumRowIndices()) + Mat5Type.Int32.computeSerializedSize(this.getNumColIndices()) + Mat5Type.Single.computeSerializedSize(((FMatrixSparseCSC)this.matrix).getNonZeroLength());
    }

    @Override
    protected void writeMat5Data(Sink sink) throws IOException {
        Mat5Type.Int32.writeTag(this.getNumRowIndices(), sink);
        if (((FMatrixSparseCSC)this.matrix).getNonZeroLength() == 0) {
            sink.writeInt(0);
        } else {
            sink.writeInts(((FMatrixSparseCSC)this.matrix).nz_rows, 0, this.getNumRowIndices());
        }
        Mat5Type.Int32.writePadding(this.getNumRowIndices(), sink);
        Mat5Type.Int32.writeTag(this.getNumColIndices(), sink);
        sink.writeInts(((FMatrixSparseCSC)this.matrix).col_idx, 0, this.getNumColIndices());
        Mat5Type.Int32.writePadding(this.getNumColIndices(), sink);
        Mat5Type.Single.writeTag(((FMatrixSparseCSC)this.matrix).getNonZeroLength(), sink);
        sink.writeFloats(((FMatrixSparseCSC)this.matrix).nz_values, 0, ((FMatrixSparseCSC)this.matrix).getNonZeroLength());
        Mat5Type.Single.writePadding(((FMatrixSparseCSC)this.matrix).getNonZeroLength(), sink);
    }

    public MatlabType getType() {
        return MatlabType.Sparse;
    }

    @Override
    public int getNzMax() {
        return Math.max(1, ((FMatrixSparseCSC)this.matrix).getNonZeroLength());
    }

    FMatrixSparseCSCWrapper(FMatrixSparseCSC matrix) {
        super(matrix);
        if (!matrix.indicesSorted) {
            matrix.sortIndices(null);
        }
    }

    private int getNumRowIndices() {
        return this.getNzMax();
    }

    private int getNumColIndices() {
        return ((FMatrixSparseCSC)this.matrix).getNumCols() + 1;
    }
}

