/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.matlab.mat.ejml;

import java.io.IOException;
import org.ejml.data.DMatrix;
import us.hebi.matlab.mat.ejml.AbstractMatrixWrapper;
import us.hebi.matlab.mat.format.Mat5Type;
import us.hebi.matlab.mat.types.MatlabType;
import us.hebi.matlab.mat.types.Sink;

class DMatrixWrapper
extends AbstractMatrixWrapper<DMatrix> {
    @Override
    protected int getMat5DataSize() {
        return Mat5Type.Double.computeSerializedSize(((DMatrix)this.matrix).getNumElements());
    }

    @Override
    protected void writeMat5Data(Sink sink) throws IOException {
        Mat5Type.Double.writeTag(((DMatrix)this.matrix).getNumElements(), sink);
        for (int col = 0; col < ((DMatrix)this.matrix).getNumCols(); ++col) {
            for (int row = 0; row < ((DMatrix)this.matrix).getNumRows(); ++row) {
                sink.writeDouble(((DMatrix)this.matrix).unsafe_get(row, col));
            }
        }
        Mat5Type.Double.writePadding(((DMatrix)this.matrix).getNumElements(), sink);
    }

    public MatlabType getType() {
        return MatlabType.Double;
    }

    DMatrixWrapper(DMatrix matrix) {
        super(matrix);
    }
}

