/*
 * Decompiled with CFR 0.152.
 */
package tk.mybatis.mapper.additional.select;

import java.util.Objects;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.mapping.MappedStatement;
import tk.mybatis.mapper.entity.EntityColumn;
import tk.mybatis.mapper.entity.EntityTable;
import tk.mybatis.mapper.mapperhelper.EntityHelper;
import tk.mybatis.mapper.mapperhelper.MapperHelper;
import tk.mybatis.mapper.mapperhelper.MapperTemplate;
import tk.mybatis.mapper.mapperhelper.SqlHelper;
import tk.mybatis.mapper.util.StringUtil;

public class SelectPropertyProvider
extends MapperTemplate {
    private static final Log log = LogFactory.getLog(SelectPropertyProvider.class);

    public SelectPropertyProvider(Class<?> mapperClass, MapperHelper mapperHelper) {
        super(mapperClass, mapperHelper);
    }

    public String selectOneByProperty(MappedStatement ms) {
        String propertyHelper = SelectPropertyProvider.class.getName();
        Class entityClass = this.getEntityClass(ms);
        this.setResultType(ms, entityClass);
        StringBuilder sql = new StringBuilder();
        sql.append(SqlHelper.selectAllColumns((Class)entityClass));
        sql.append(SqlHelper.fromTable((Class)entityClass, (String)this.tableName(entityClass)));
        sql.append("<where>\n");
        sql.append("<if test=\"@");
        sql.append(propertyHelper);
        sql.append("@existsWhereCondition(value, ");
        sql.append(this.isNotEmpty());
        sql.append(")");
        sql.append("\">\n");
        String entityClassName = entityClass.getName();
        String ognl = "${@" + propertyHelper + "@getColumnByProperty(@java.lang.Class@forName(\"" + entityClassName + "\"), @tk.mybatis.mapper.weekend.reflection.Reflections@fnToFieldName(fn))}";
        sql.append(ognl + " = #{value}\n");
        sql.append("</if>\n");
        sql.append(SqlHelper.whereLogicDelete((Class)entityClass, (boolean)false));
        sql.append("</where>");
        return sql.toString();
    }

    public String selectByProperty(MappedStatement ms) {
        String propertyHelper = SelectPropertyProvider.class.getName();
        Class entityClass = this.getEntityClass(ms);
        this.setResultType(ms, entityClass);
        StringBuilder sql = new StringBuilder();
        sql.append(SqlHelper.selectAllColumns((Class)entityClass));
        sql.append(SqlHelper.fromTable((Class)entityClass, (String)this.tableName(entityClass)));
        sql.append("<where>\n");
        sql.append("<if test=\"@");
        sql.append(propertyHelper);
        sql.append("@existsWhereCondition(value, ");
        sql.append(this.isNotEmpty());
        sql.append(")");
        sql.append("\">\n");
        String entityClassName = entityClass.getName();
        String ognl = "${@" + propertyHelper + "@getColumnByProperty(@java.lang.Class@forName(\"" + entityClassName + "\"), @tk.mybatis.mapper.weekend.reflection.Reflections@fnToFieldName(fn))}";
        sql.append(ognl + " = #{value}\n");
        sql.append("</if>\n");
        sql.append(SqlHelper.whereLogicDelete((Class)entityClass, (boolean)false));
        sql.append("</where>");
        return sql.toString();
    }

    public String selectInByProperty(MappedStatement ms) {
        Class entityClass = this.getEntityClass(ms);
        this.setResultType(ms, entityClass);
        StringBuilder sql = new StringBuilder();
        sql.append(SqlHelper.selectAllColumns((Class)entityClass));
        sql.append(SqlHelper.fromTable((Class)entityClass, (String)this.tableName(entityClass)));
        sql.append("<where>\n");
        String entityClassName = entityClass.getName();
        String propertyHelper = SelectPropertyProvider.class.getName();
        String sqlSegment = "${@" + propertyHelper + "@getColumnByProperty(@java.lang.Class@forName(\"" + entityClassName + "\"),@tk.mybatis.mapper.weekend.reflection.Reflections@fnToFieldName(fn))} in<foreach open=\"(\" close=\")\" separator=\",\" collection=\"values\" item=\"obj\">\n#{obj}\n</foreach>\n";
        sql.append(sqlSegment);
        sql.append(SqlHelper.whereLogicDelete((Class)entityClass, (boolean)false));
        sql.append("</where>");
        return sql.toString();
    }

    public String selectBetweenByProperty(MappedStatement ms) {
        Class entityClass = this.getEntityClass(ms);
        this.setResultType(ms, entityClass);
        StringBuilder sql = new StringBuilder();
        sql.append(SqlHelper.selectAllColumns((Class)entityClass));
        sql.append(SqlHelper.fromTable((Class)entityClass, (String)this.tableName(entityClass)));
        sql.append("<where>\n");
        String entityClassName = entityClass.getName();
        String propertyHelper = SelectPropertyProvider.class.getName();
        String sqlSegment = "${@" + propertyHelper + "@getColumnByProperty(@java.lang.Class@forName(\"" + entityClassName + "\"),@tk.mybatis.mapper.weekend.reflection.Reflections@fnToFieldName(fn))} between #{begin} and #{end}";
        sql.append(sqlSegment);
        sql.append(SqlHelper.whereLogicDelete((Class)entityClass, (boolean)false));
        sql.append("</where>");
        return sql.toString();
    }

    public String existsWithProperty(MappedStatement ms) {
        String propertyHelper = SelectPropertyProvider.class.getName();
        Class entityClass = this.getEntityClass(ms);
        StringBuilder sql = new StringBuilder();
        sql.append(SqlHelper.selectCountExists((Class)entityClass));
        sql.append(SqlHelper.fromTable((Class)entityClass, (String)this.tableName(entityClass)));
        sql.append("<where>\n");
        sql.append("<if test=\"@");
        sql.append(propertyHelper);
        sql.append("@existsWhereCondition(value, ");
        sql.append(this.isNotEmpty());
        sql.append(")");
        sql.append("\">\n");
        String entityClassName = entityClass.getName();
        String ognl = "${@" + propertyHelper + "@getColumnByProperty(@java.lang.Class@forName(\"" + entityClassName + "\"), @tk.mybatis.mapper.weekend.reflection.Reflections@fnToFieldName(fn))}";
        sql.append(ognl + " = #{value}\n");
        sql.append("</if>\n");
        sql.append(SqlHelper.whereLogicDelete((Class)entityClass, (boolean)false));
        sql.append("</where>");
        return sql.toString();
    }

    public String selectCountByProperty(MappedStatement ms) {
        Class entityClass = this.getEntityClass(ms);
        String propertyHelper = SelectPropertyProvider.class.getName();
        StringBuilder sql = new StringBuilder();
        sql.append(SqlHelper.selectCount((Class)entityClass));
        sql.append(SqlHelper.fromTable((Class)entityClass, (String)this.tableName(entityClass)));
        sql.append("<where>\n");
        sql.append("<if test=\"@");
        sql.append(propertyHelper);
        sql.append("@existsWhereCondition(value, ");
        sql.append(this.isNotEmpty());
        sql.append(")");
        sql.append("\">\n");
        String entityClassName = entityClass.getName();
        String ognl = "${@" + propertyHelper + "@getColumnByProperty(@java.lang.Class@forName(\"" + entityClassName + "\"), @tk.mybatis.mapper.weekend.reflection.Reflections@fnToFieldName(fn))}";
        sql.append(ognl + " = #{value}\n");
        sql.append("</if>\n");
        sql.append(SqlHelper.whereLogicDelete((Class)entityClass, (boolean)false));
        sql.append("</where>");
        return sql.toString();
    }

    public static String getColumnByProperty(Class<?> entityClass, String property) {
        EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
        EntityColumn entityColumn = (EntityColumn)entityTable.getPropertyMap().get(property);
        return entityColumn.getColumn();
    }

    public static boolean existsWhereCondition(Object value, boolean notEmpty) {
        boolean appendWhereCondition = true;
        if (Objects.isNull(value)) {
            log.warn("value is null! this will case no conditions after where keyword");
        } else if (String.class.equals(value.getClass()) && notEmpty && StringUtil.isEmpty((String)value.toString())) {
            appendWhereCondition = false;
        }
        return appendWhereCondition;
    }
}

