/*
 * Decompiled with CFR 0.152.
 */
package manifold.ext.rt.api;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import manifold.ext.rt.RuntimeMethods;
import manifold.ext.rt.api.IBindingsBacked;

public interface IListBacked<T>
extends List<T> {
    public List<Object> getList();

    default public Class<?> getFinalComponentType() {
        Class<?>[] interfaces;
        for (Class<?> e : interfaces = this.getClass().getInterfaces()) {
            for (Type iface : e.getGenericInterfaces()) {
                if (!(iface instanceof ParameterizedType) || !List.class.isAssignableFrom((Class)((ParameterizedType)iface).getRawType())) continue;
                Type typeArg = ((ParameterizedType)iface).getActualTypeArguments()[0];
                if (typeArg instanceof ParameterizedType) {
                    typeArg = ((ParameterizedType)typeArg).getRawType();
                }
                if (!(typeArg instanceof Class)) continue;
                return (Class)typeArg;
            }
        }
        throw new IllegalStateException();
    }

    default public void coerceListToBindingValues() {
        List<Object> list = this.getList();
        for (int i = 0; i < list.size(); ++i) {
            Object e = list.get(i);
            e = this.toBindingsValue(e);
            list.set(i, e);
        }
    }

    default public List<T> coerceListToComplexValues() {
        return this.getList().stream().map(e -> this.coerce(e, this.getFinalComponentType())).collect(Collectors.toList());
    }

    default public Object coerce(Object value, Class type) {
        return RuntimeMethods.coerceFromBindingsValue(value, type);
    }

    @Override
    default public void replaceAll(UnaryOperator<T> operator) {
        this.getList().replaceAll(e -> this.toBindingsValue(operator.apply(this.coerce(e, this.getFinalComponentType()))));
    }

    @Override
    default public void sort(Comparator<? super T> c) {
        List<T> cList = this.coerceListToComplexValues();
        cList.sort(c);
        List<Object> bList = this.toBindings(cList);
        for (int i = 0; i < bList.size(); ++i) {
            this.getList().set(i, bList.get(i));
        }
    }

    @Override
    default public Spliterator<T> spliterator() {
        return this.coerceListToComplexValues().spliterator();
    }

    @Override
    default public boolean removeIf(Predicate<? super T> filter) {
        List<T> cList = this.coerceListToComplexValues();
        boolean result = cList.removeIf(filter);
        if (result) {
            List<Object> bList = this.toBindings(cList);
            this.getList().clear();
            this.getList().addAll(bList);
        }
        return result;
    }

    @Override
    default public Stream<T> stream() {
        return this.coerceListToComplexValues().stream();
    }

    @Override
    default public Stream<T> parallelStream() {
        return this.coerceListToComplexValues().parallelStream();
    }

    @Override
    default public void forEach(Consumer<? super T> action) {
        this.coerceListToComplexValues().forEach(action);
    }

    @Override
    default public int size() {
        return this.getList().size();
    }

    @Override
    default public boolean isEmpty() {
        return this.getList().isEmpty();
    }

    @Override
    default public boolean contains(Object o) {
        return this.coerceListToComplexValues().contains(o);
    }

    @Override
    default public Iterator<T> iterator() {
        return new Iterator<T>(){
            Iterator<T> _delegate;
            Iterator _actual;
            {
                this._delegate = IListBacked.this.coerceListToComplexValues().iterator();
                this._actual = IListBacked.this.getList().iterator();
            }

            @Override
            public boolean hasNext() {
                return this._delegate.hasNext();
            }

            @Override
            public T next() {
                this._actual.next();
                return this._delegate.next();
            }

            @Override
            public void remove() {
                this._actual.remove();
            }
        };
    }

    @Override
    default public Object[] toArray() {
        return this.coerceListToComplexValues().toArray();
    }

    @Override
    default public <T1> T1[] toArray(T1[] a) {
        return this.coerceListToComplexValues().toArray(a);
    }

    @Override
    default public boolean add(T t) {
        return this.getList().add(this.toBindingsValue(t));
    }

    default public Object toBindingsValue(Object element) {
        List<Object> value = element;
        value = value instanceof IBindingsBacked ? ((IBindingsBacked)((Object)value)).getBindings() : (value instanceof IListBacked ? ((IListBacked)value).getList() : RuntimeMethods.coerceToBindingValue(value));
        return value;
    }

    @Override
    default public boolean remove(Object o) {
        Object bindingValue = this.toBindingsValue(o);
        return this.getList().remove(bindingValue);
    }

    @Override
    default public boolean containsAll(Collection<?> c) {
        return this.coerceListToComplexValues().containsAll(c);
    }

    @Override
    default public boolean addAll(Collection<? extends T> c) {
        List<Object> all = this.toBindings(c);
        return this.getList().addAll(all);
    }

    @Override
    default public boolean addAll(int index, Collection<? extends T> c) {
        List<Object> all = this.toBindings(c);
        return this.getList().addAll(index, all);
    }

    default public List<Object> toBindings(Collection<?> c) {
        return c.stream().map(e -> this.toBindingsValue(e)).collect(Collectors.toList());
    }

    @Override
    default public boolean removeAll(Collection<?> c) {
        return this.getList().removeAll(this.toBindings(c));
    }

    @Override
    default public boolean retainAll(Collection<?> c) {
        return this.getList().retainAll(this.toBindings(c));
    }

    @Override
    default public void clear() {
        this.getList().clear();
    }

    @Override
    default public T get(int index) {
        Object o = this.getList().get(index);
        return (T)this.coerce(o, this.getFinalComponentType());
    }

    @Override
    default public T set(int index, T element) {
        element = this.toBindingsValue(element);
        Object result = this.getList().set(index, element);
        return (T)(result == null ? null : this.coerce(result, this.getFinalComponentType()));
    }

    @Override
    default public void add(int index, T element) {
        Object bindingValue = this.toBindingsValue(element);
        this.getList().add(index, bindingValue);
    }

    @Override
    default public T remove(int index) {
        Object bindingValue = this.getList().remove(index);
        return (T)(bindingValue == null ? null : this.coerce(bindingValue, this.getFinalComponentType()));
    }

    @Override
    default public int indexOf(Object o) {
        o = this.toBindingsValue(o);
        return this.getList().indexOf(o);
    }

    @Override
    default public int lastIndexOf(Object o) {
        o = this.toBindingsValue(o);
        return this.getList().lastIndexOf(o);
    }

    @Override
    default public ListIterator<T> listIterator() {
        return new ListIterator<T>(){
            ListIterator<T> _delegate;
            ListIterator _actual;
            {
                this._delegate = IListBacked.this.coerceListToComplexValues().listIterator();
                this._actual = IListBacked.this.getList().listIterator();
            }

            @Override
            public boolean hasNext() {
                return this._delegate.hasNext();
            }

            @Override
            public T next() {
                this._actual.next();
                return this._delegate.next();
            }

            @Override
            public boolean hasPrevious() {
                return this._delegate.hasPrevious();
            }

            @Override
            public T previous() {
                this._actual.previous();
                return this._delegate.previous();
            }

            @Override
            public int nextIndex() {
                this._actual.nextIndex();
                return this._delegate.nextIndex();
            }

            @Override
            public int previousIndex() {
                this._actual.previousIndex();
                return this._delegate.previousIndex();
            }

            @Override
            public void remove() {
                this._actual.remove();
                this._delegate.remove();
            }

            @Override
            public void set(T t) {
                this._actual.set(IListBacked.this.toBindingsValue(t));
                this._delegate.set(t);
            }

            @Override
            public void add(T t) {
                this._actual.add(IListBacked.this.toBindingsValue(t));
                this._delegate.add(t);
            }
        };
    }

    @Override
    default public ListIterator<T> listIterator(final int index) {
        return new ListIterator<T>(){
            ListIterator<T> _delegate;
            ListIterator _actual;
            {
                this._delegate = IListBacked.this.coerceListToComplexValues().listIterator(index);
                this._actual = IListBacked.this.getList().listIterator(index);
            }

            @Override
            public boolean hasNext() {
                return this._delegate.hasNext();
            }

            @Override
            public T next() {
                this._actual.next();
                return this._delegate.next();
            }

            @Override
            public boolean hasPrevious() {
                return this._delegate.hasPrevious();
            }

            @Override
            public T previous() {
                this._actual.previous();
                return this._delegate.previous();
            }

            @Override
            public int nextIndex() {
                this._actual.nextIndex();
                return this._delegate.nextIndex();
            }

            @Override
            public int previousIndex() {
                this._actual.previousIndex();
                return this._delegate.previousIndex();
            }

            @Override
            public void remove() {
                this._actual.remove();
                this._delegate.remove();
            }

            @Override
            public void set(T t) {
                this._actual.set(IListBacked.this.toBindingsValue(t));
                this._delegate.set(t);
            }

            @Override
            public void add(T t) {
                this._actual.add(IListBacked.this.toBindingsValue(t));
                this._delegate.add(t);
            }
        };
    }

    @Override
    default public List<T> subList(int fromIndex, int toIndex) {
        return this.getList().subList(fromIndex, toIndex).stream().map(e -> this.coerce(e, this.getFinalComponentType())).collect(Collectors.toList());
    }
}

