/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.xray.XRayClient;
import software.amazon.awssdk.services.xray.model.GetTraceGraphRequest;
import software.amazon.awssdk.services.xray.model.GetTraceGraphResponse;
import software.amazon.awssdk.services.xray.model.Service;

public class GetTraceGraphIterable
implements SdkIterable<GetTraceGraphResponse> {
    private final XRayClient client;
    private final GetTraceGraphRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetTraceGraphIterable(XRayClient client, GetTraceGraphRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetTraceGraphResponseFetcher();
    }

    public Iterator<GetTraceGraphResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Service> services() {
        Function<GetTraceGraphResponse, Iterator> getIterator = response -> {
            if (response != null && response.services() != null) {
                return response.services().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetTraceGraphResponseFetcher
    implements SyncPageFetcher<GetTraceGraphResponse> {
        private GetTraceGraphResponseFetcher() {
        }

        public boolean hasNextPage(GetTraceGraphResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetTraceGraphResponse nextPage(GetTraceGraphResponse previousPage) {
            if (previousPage == null) {
                return GetTraceGraphIterable.this.client.getTraceGraph(GetTraceGraphIterable.this.firstRequest);
            }
            return GetTraceGraphIterable.this.client.getTraceGraph((GetTraceGraphRequest)((Object)GetTraceGraphIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

