/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.WorkspaceBundle;

final class BundleListCopier {
    BundleListCopier() {
    }

    static List<WorkspaceBundle> copy(Collection<? extends WorkspaceBundle> bundleListParam) {
        Object list;
        if (bundleListParam == null || bundleListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList();
            bundleListParam.forEach(entry -> modifiableList.add(entry));
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<WorkspaceBundle> copyFromBuilder(Collection<? extends WorkspaceBundle.Builder> bundleListParam) {
        Object list;
        if (bundleListParam == null || bundleListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList();
            bundleListParam.forEach(entry -> {
                WorkspaceBundle member = (WorkspaceBundle)entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<WorkspaceBundle.Builder> copyToBuilder(Collection<? extends WorkspaceBundle> bundleListParam) {
        Object list;
        if (bundleListParam == null || bundleListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList();
            bundleListParam.forEach(entry -> {
                WorkspaceBundle.Builder member = entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}

