/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workmail.WorkMailAsyncClient;
import software.amazon.awssdk.services.workmail.model.ListResourceDelegatesRequest;
import software.amazon.awssdk.services.workmail.model.ListResourceDelegatesResponse;

public class ListResourceDelegatesPublisher
implements SdkPublisher<ListResourceDelegatesResponse> {
    private final WorkMailAsyncClient client;
    private final ListResourceDelegatesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListResourceDelegatesPublisher(WorkMailAsyncClient client, ListResourceDelegatesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListResourceDelegatesPublisher(WorkMailAsyncClient client, ListResourceDelegatesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListResourceDelegatesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListResourceDelegatesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListResourceDelegatesResponseFetcher
    implements AsyncPageFetcher<ListResourceDelegatesResponse> {
        private ListResourceDelegatesResponseFetcher() {
        }

        public boolean hasNextPage(ListResourceDelegatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListResourceDelegatesResponse> nextPage(ListResourceDelegatesResponse previousPage) {
            if (previousPage == null) {
                return ListResourceDelegatesPublisher.this.client.listResourceDelegates(ListResourceDelegatesPublisher.this.firstRequest);
            }
            return ListResourceDelegatesPublisher.this.client.listResourceDelegates((ListResourceDelegatesRequest)((Object)ListResourceDelegatesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

