/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workmail.WorkMailClient;
import software.amazon.awssdk.services.workmail.model.ListGroupMembersRequest;
import software.amazon.awssdk.services.workmail.model.ListGroupMembersResponse;

public class ListGroupMembersIterable
implements SdkIterable<ListGroupMembersResponse> {
    private final WorkMailClient client;
    private final ListGroupMembersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListGroupMembersIterable(WorkMailClient client, ListGroupMembersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListGroupMembersResponseFetcher();
    }

    public Iterator<ListGroupMembersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListGroupMembersResponseFetcher
    implements SyncPageFetcher<ListGroupMembersResponse> {
        private ListGroupMembersResponseFetcher() {
        }

        public boolean hasNextPage(ListGroupMembersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListGroupMembersResponse nextPage(ListGroupMembersResponse previousPage) {
            if (previousPage == null) {
                return ListGroupMembersIterable.this.client.listGroupMembers(ListGroupMembersIterable.this.firstRequest);
            }
            return ListGroupMembersIterable.this.client.listGroupMembers((ListGroupMembersRequest)((Object)ListGroupMembersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

