/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum PermissionType {
    FULL_ACCESS("FULL_ACCESS"),
    SEND_AS("SEND_AS"),
    SEND_ON_BEHALF("SEND_ON_BEHALF"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private PermissionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PermissionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(PermissionType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PermissionType> knownValues() {
        return Stream.of(PermissionType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

