/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <note>
 * <p>
 * This is <b>AWS WAF Classic</b> documentation. For more information, see <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the
 * developer guide.
 * </p>
 * <p>
 * <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the
 * latest version, AWS WAF has a single set of endpoints for regional and global use.
 * </p>
 * </note>
 * <p>
 * A complex type that contains <code>SizeConstraint</code> objects, which specify the parts of web requests that you
 * want AWS WAF to inspect the size of. If a <code>SizeConstraintSet</code> contains more than one
 * <code>SizeConstraint</code> object, a request only needs to match one constraint to be considered a match.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SizeConstraintSet implements SdkPojo, Serializable,
        ToCopyableBuilder<SizeConstraintSet.Builder, SizeConstraintSet> {
    private static final SdkField<String> SIZE_CONSTRAINT_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SizeConstraintSetId").getter(getter(SizeConstraintSet::sizeConstraintSetId))
            .setter(setter(Builder::sizeConstraintSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeConstraintSetId").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(SizeConstraintSet::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<SizeConstraint>> SIZE_CONSTRAINTS_FIELD = SdkField
            .<List<SizeConstraint>> builder(MarshallingType.LIST)
            .memberName("SizeConstraints")
            .getter(getter(SizeConstraintSet::sizeConstraints))
            .setter(setter(Builder::sizeConstraints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeConstraints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SizeConstraint> builder(MarshallingType.SDK_POJO)
                                            .constructor(SizeConstraint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIZE_CONSTRAINT_SET_ID_FIELD,
            NAME_FIELD, SIZE_CONSTRAINTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String sizeConstraintSetId;

    private final String name;

    private final List<SizeConstraint> sizeConstraints;

    private SizeConstraintSet(BuilderImpl builder) {
        this.sizeConstraintSetId = builder.sizeConstraintSetId;
        this.name = builder.name;
        this.sizeConstraints = builder.sizeConstraints;
    }

    /**
     * <p>
     * A unique identifier for a <code>SizeConstraintSet</code>. You use <code>SizeConstraintSetId</code> to get
     * information about a <code>SizeConstraintSet</code> (see <a>GetSizeConstraintSet</a>), update a
     * <code>SizeConstraintSet</code> (see <a>UpdateSizeConstraintSet</a>), insert a <code>SizeConstraintSet</code> into
     * a <code>Rule</code> or delete one from a <code>Rule</code> (see <a>UpdateRule</a>), and delete a
     * <code>SizeConstraintSet</code> from AWS WAF (see <a>DeleteSizeConstraintSet</a>).
     * </p>
     * <p>
     * <code>SizeConstraintSetId</code> is returned by <a>CreateSizeConstraintSet</a> and by
     * <a>ListSizeConstraintSets</a>.
     * </p>
     * 
     * @return A unique identifier for a <code>SizeConstraintSet</code>. You use <code>SizeConstraintSetId</code> to get
     *         information about a <code>SizeConstraintSet</code> (see <a>GetSizeConstraintSet</a>), update a
     *         <code>SizeConstraintSet</code> (see <a>UpdateSizeConstraintSet</a>), insert a
     *         <code>SizeConstraintSet</code> into a <code>Rule</code> or delete one from a <code>Rule</code> (see
     *         <a>UpdateRule</a>), and delete a <code>SizeConstraintSet</code> from AWS WAF (see
     *         <a>DeleteSizeConstraintSet</a>).</p>
     *         <p>
     *         <code>SizeConstraintSetId</code> is returned by <a>CreateSizeConstraintSet</a> and by
     *         <a>ListSizeConstraintSets</a>.
     */
    public final String sizeConstraintSetId() {
        return sizeConstraintSetId;
    }

    /**
     * <p>
     * The name, if any, of the <code>SizeConstraintSet</code>.
     * </p>
     * 
     * @return The name, if any, of the <code>SizeConstraintSet</code>.
     */
    public final String name() {
        return name;
    }

    /**
     * Returns true if the SizeConstraints property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasSizeConstraints() {
        return sizeConstraints != null && !(sizeConstraints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the parts of web requests that you want to inspect the size of.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSizeConstraints()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specifies the parts of web requests that you want to inspect the size of.
     */
    public final List<SizeConstraint> sizeConstraints() {
        return sizeConstraints;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sizeConstraintSetId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasSizeConstraints() ? sizeConstraints() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SizeConstraintSet)) {
            return false;
        }
        SizeConstraintSet other = (SizeConstraintSet) obj;
        return Objects.equals(sizeConstraintSetId(), other.sizeConstraintSetId()) && Objects.equals(name(), other.name())
                && hasSizeConstraints() == other.hasSizeConstraints()
                && Objects.equals(sizeConstraints(), other.sizeConstraints());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SizeConstraintSet").add("SizeConstraintSetId", sizeConstraintSetId()).add("Name", name())
                .add("SizeConstraints", hasSizeConstraints() ? sizeConstraints() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SizeConstraintSetId":
            return Optional.ofNullable(clazz.cast(sizeConstraintSetId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "SizeConstraints":
            return Optional.ofNullable(clazz.cast(sizeConstraints()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SizeConstraintSet, T> g) {
        return obj -> g.apply((SizeConstraintSet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SizeConstraintSet> {
        /**
         * <p>
         * A unique identifier for a <code>SizeConstraintSet</code>. You use <code>SizeConstraintSetId</code> to get
         * information about a <code>SizeConstraintSet</code> (see <a>GetSizeConstraintSet</a>), update a
         * <code>SizeConstraintSet</code> (see <a>UpdateSizeConstraintSet</a>), insert a <code>SizeConstraintSet</code>
         * into a <code>Rule</code> or delete one from a <code>Rule</code> (see <a>UpdateRule</a>), and delete a
         * <code>SizeConstraintSet</code> from AWS WAF (see <a>DeleteSizeConstraintSet</a>).
         * </p>
         * <p>
         * <code>SizeConstraintSetId</code> is returned by <a>CreateSizeConstraintSet</a> and by
         * <a>ListSizeConstraintSets</a>.
         * </p>
         * 
         * @param sizeConstraintSetId
         *        A unique identifier for a <code>SizeConstraintSet</code>. You use <code>SizeConstraintSetId</code> to
         *        get information about a <code>SizeConstraintSet</code> (see <a>GetSizeConstraintSet</a>), update a
         *        <code>SizeConstraintSet</code> (see <a>UpdateSizeConstraintSet</a>), insert a
         *        <code>SizeConstraintSet</code> into a <code>Rule</code> or delete one from a <code>Rule</code> (see
         *        <a>UpdateRule</a>), and delete a <code>SizeConstraintSet</code> from AWS WAF (see
         *        <a>DeleteSizeConstraintSet</a>).</p>
         *        <p>
         *        <code>SizeConstraintSetId</code> is returned by <a>CreateSizeConstraintSet</a> and by
         *        <a>ListSizeConstraintSets</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizeConstraintSetId(String sizeConstraintSetId);

        /**
         * <p>
         * The name, if any, of the <code>SizeConstraintSet</code>.
         * </p>
         * 
         * @param name
         *        The name, if any, of the <code>SizeConstraintSet</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Specifies the parts of web requests that you want to inspect the size of.
         * </p>
         * 
         * @param sizeConstraints
         *        Specifies the parts of web requests that you want to inspect the size of.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizeConstraints(Collection<SizeConstraint> sizeConstraints);

        /**
         * <p>
         * Specifies the parts of web requests that you want to inspect the size of.
         * </p>
         * 
         * @param sizeConstraints
         *        Specifies the parts of web requests that you want to inspect the size of.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizeConstraints(SizeConstraint... sizeConstraints);

        /**
         * <p>
         * Specifies the parts of web requests that you want to inspect the size of.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SizeConstraint>.Builder} avoiding the need
         * to create one manually via {@link List<SizeConstraint>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SizeConstraint>.Builder#build()} is called immediately and
         * its result is passed to {@link #sizeConstraints(List<SizeConstraint>)}.
         * 
         * @param sizeConstraints
         *        a consumer that will call methods on {@link List<SizeConstraint>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sizeConstraints(List<SizeConstraint>)
         */
        Builder sizeConstraints(Consumer<SizeConstraint.Builder>... sizeConstraints);
    }

    static final class BuilderImpl implements Builder {
        private String sizeConstraintSetId;

        private String name;

        private List<SizeConstraint> sizeConstraints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SizeConstraintSet model) {
            sizeConstraintSetId(model.sizeConstraintSetId);
            name(model.name);
            sizeConstraints(model.sizeConstraints);
        }

        public final String getSizeConstraintSetId() {
            return sizeConstraintSetId;
        }

        @Override
        public final Builder sizeConstraintSetId(String sizeConstraintSetId) {
            this.sizeConstraintSetId = sizeConstraintSetId;
            return this;
        }

        public final void setSizeConstraintSetId(String sizeConstraintSetId) {
            this.sizeConstraintSetId = sizeConstraintSetId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final List<SizeConstraint.Builder> getSizeConstraints() {
            List<SizeConstraint.Builder> result = SizeConstraintsCopier.copyToBuilder(this.sizeConstraints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder sizeConstraints(Collection<SizeConstraint> sizeConstraints) {
            this.sizeConstraints = SizeConstraintsCopier.copy(sizeConstraints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sizeConstraints(SizeConstraint... sizeConstraints) {
            sizeConstraints(Arrays.asList(sizeConstraints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sizeConstraints(Consumer<SizeConstraint.Builder>... sizeConstraints) {
            sizeConstraints(Stream.of(sizeConstraints).map(c -> SizeConstraint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSizeConstraints(Collection<SizeConstraint.BuilderImpl> sizeConstraints) {
            this.sizeConstraints = SizeConstraintsCopier.copyFromBuilder(sizeConstraints);
        }

        @Override
        public SizeConstraintSet build() {
            return new SizeConstraintSet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
