/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <note>
 * <p>
 * This is <b>AWS WAF Classic</b> documentation. For more information, see <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the
 * developer guide.
 * </p>
 * <p>
 * <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the
 * latest version, AWS WAF has a single set of endpoints for regional and global use.
 * </p>
 * </note>
 * <p>
 * The response from a <a>GetSampledRequests</a> request includes a <code>SampledHTTPRequests</code> complex type that
 * appears as <code>SampledRequests</code> in the response syntax. <code>SampledHTTPRequests</code> contains one
 * <code>SampledHTTPRequest</code> object for each web request that is returned by <code>GetSampledRequests</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SampledHTTPRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<SampledHTTPRequest.Builder, SampledHTTPRequest> {
    private static final SdkField<HTTPRequest> REQUEST_FIELD = SdkField.<HTTPRequest> builder(MarshallingType.SDK_POJO)
            .memberName("Request").getter(getter(SampledHTTPRequest::request)).setter(setter(Builder::request))
            .constructor(HTTPRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Request").build()).build();

    private static final SdkField<Long> WEIGHT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Weight")
            .getter(getter(SampledHTTPRequest::weight)).setter(setter(Builder::weight))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Weight").build()).build();

    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("Timestamp").getter(getter(SampledHTTPRequest::timestamp)).setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()).build();

    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Action")
            .getter(getter(SampledHTTPRequest::action)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<String> RULE_WITHIN_RULE_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleWithinRuleGroup").getter(getter(SampledHTTPRequest::ruleWithinRuleGroup))
            .setter(setter(Builder::ruleWithinRuleGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleWithinRuleGroup").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_FIELD, WEIGHT_FIELD,
            TIMESTAMP_FIELD, ACTION_FIELD, RULE_WITHIN_RULE_GROUP_FIELD));

    private static final long serialVersionUID = 1L;

    private final HTTPRequest request;

    private final Long weight;

    private final Instant timestamp;

    private final String action;

    private final String ruleWithinRuleGroup;

    private SampledHTTPRequest(BuilderImpl builder) {
        this.request = builder.request;
        this.weight = builder.weight;
        this.timestamp = builder.timestamp;
        this.action = builder.action;
        this.ruleWithinRuleGroup = builder.ruleWithinRuleGroup;
    }

    /**
     * <p>
     * A complex type that contains detailed information about the request.
     * </p>
     * 
     * @return A complex type that contains detailed information about the request.
     */
    public final HTTPRequest request() {
        return request;
    }

    /**
     * <p>
     * A value that indicates how one result in the response relates proportionally to other results in the response. A
     * result that has a weight of <code>2</code> represents roughly twice as many CloudFront web requests as a result
     * that has a weight of <code>1</code>.
     * </p>
     * 
     * @return A value that indicates how one result in the response relates proportionally to other results in the
     *         response. A result that has a weight of <code>2</code> represents roughly twice as many CloudFront web
     *         requests as a result that has a weight of <code>1</code>.
     */
    public final Long weight() {
        return weight;
    }

    /**
     * <p>
     * The time at which AWS WAF received the request from your AWS resource, in Unix time format (in seconds).
     * </p>
     * 
     * @return The time at which AWS WAF received the request from your AWS resource, in Unix time format (in seconds).
     */
    public final Instant timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * The action for the <code>Rule</code> that the request matched: <code>ALLOW</code>, <code>BLOCK</code>, or
     * <code>COUNT</code>.
     * </p>
     * 
     * @return The action for the <code>Rule</code> that the request matched: <code>ALLOW</code>, <code>BLOCK</code>, or
     *         <code>COUNT</code>.
     */
    public final String action() {
        return action;
    }

    /**
     * <p>
     * This value is returned if the <code>GetSampledRequests</code> request specifies the ID of a
     * <code>RuleGroup</code> rather than the ID of an individual rule. <code>RuleWithinRuleGroup</code> is the rule
     * within the specified <code>RuleGroup</code> that matched the request listed in the response.
     * </p>
     * 
     * @return This value is returned if the <code>GetSampledRequests</code> request specifies the ID of a
     *         <code>RuleGroup</code> rather than the ID of an individual rule. <code>RuleWithinRuleGroup</code> is the
     *         rule within the specified <code>RuleGroup</code> that matched the request listed in the response.
     */
    public final String ruleWithinRuleGroup() {
        return ruleWithinRuleGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(request());
        hashCode = 31 * hashCode + Objects.hashCode(weight());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(action());
        hashCode = 31 * hashCode + Objects.hashCode(ruleWithinRuleGroup());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SampledHTTPRequest)) {
            return false;
        }
        SampledHTTPRequest other = (SampledHTTPRequest) obj;
        return Objects.equals(request(), other.request()) && Objects.equals(weight(), other.weight())
                && Objects.equals(timestamp(), other.timestamp()) && Objects.equals(action(), other.action())
                && Objects.equals(ruleWithinRuleGroup(), other.ruleWithinRuleGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SampledHTTPRequest").add("Request", request()).add("Weight", weight())
                .add("Timestamp", timestamp()).add("Action", action()).add("RuleWithinRuleGroup", ruleWithinRuleGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Request":
            return Optional.ofNullable(clazz.cast(request()));
        case "Weight":
            return Optional.ofNullable(clazz.cast(weight()));
        case "Timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "Action":
            return Optional.ofNullable(clazz.cast(action()));
        case "RuleWithinRuleGroup":
            return Optional.ofNullable(clazz.cast(ruleWithinRuleGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SampledHTTPRequest, T> g) {
        return obj -> g.apply((SampledHTTPRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SampledHTTPRequest> {
        /**
         * <p>
         * A complex type that contains detailed information about the request.
         * </p>
         * 
         * @param request
         *        A complex type that contains detailed information about the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder request(HTTPRequest request);

        /**
         * <p>
         * A complex type that contains detailed information about the request.
         * </p>
         * This is a convenience that creates an instance of the {@link HTTPRequest.Builder} avoiding the need to create
         * one manually via {@link HTTPRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link HTTPRequest.Builder#build()} is called immediately and its result
         * is passed to {@link #request(HTTPRequest)}.
         * 
         * @param request
         *        a consumer that will call methods on {@link HTTPRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #request(HTTPRequest)
         */
        default Builder request(Consumer<HTTPRequest.Builder> request) {
            return request(HTTPRequest.builder().applyMutation(request).build());
        }

        /**
         * <p>
         * A value that indicates how one result in the response relates proportionally to other results in the
         * response. A result that has a weight of <code>2</code> represents roughly twice as many CloudFront web
         * requests as a result that has a weight of <code>1</code>.
         * </p>
         * 
         * @param weight
         *        A value that indicates how one result in the response relates proportionally to other results in the
         *        response. A result that has a weight of <code>2</code> represents roughly twice as many CloudFront web
         *        requests as a result that has a weight of <code>1</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weight(Long weight);

        /**
         * <p>
         * The time at which AWS WAF received the request from your AWS resource, in Unix time format (in seconds).
         * </p>
         * 
         * @param timestamp
         *        The time at which AWS WAF received the request from your AWS resource, in Unix time format (in
         *        seconds).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);

        /**
         * <p>
         * The action for the <code>Rule</code> that the request matched: <code>ALLOW</code>, <code>BLOCK</code>, or
         * <code>COUNT</code>.
         * </p>
         * 
         * @param action
         *        The action for the <code>Rule</code> that the request matched: <code>ALLOW</code>, <code>BLOCK</code>,
         *        or <code>COUNT</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(String action);

        /**
         * <p>
         * This value is returned if the <code>GetSampledRequests</code> request specifies the ID of a
         * <code>RuleGroup</code> rather than the ID of an individual rule. <code>RuleWithinRuleGroup</code> is the rule
         * within the specified <code>RuleGroup</code> that matched the request listed in the response.
         * </p>
         * 
         * @param ruleWithinRuleGroup
         *        This value is returned if the <code>GetSampledRequests</code> request specifies the ID of a
         *        <code>RuleGroup</code> rather than the ID of an individual rule. <code>RuleWithinRuleGroup</code> is
         *        the rule within the specified <code>RuleGroup</code> that matched the request listed in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleWithinRuleGroup(String ruleWithinRuleGroup);
    }

    static final class BuilderImpl implements Builder {
        private HTTPRequest request;

        private Long weight;

        private Instant timestamp;

        private String action;

        private String ruleWithinRuleGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(SampledHTTPRequest model) {
            request(model.request);
            weight(model.weight);
            timestamp(model.timestamp);
            action(model.action);
            ruleWithinRuleGroup(model.ruleWithinRuleGroup);
        }

        public final HTTPRequest.Builder getRequest() {
            return request != null ? request.toBuilder() : null;
        }

        @Override
        public final Builder request(HTTPRequest request) {
            this.request = request;
            return this;
        }

        public final void setRequest(HTTPRequest.BuilderImpl request) {
            this.request = request != null ? request.build() : null;
        }

        public final Long getWeight() {
            return weight;
        }

        @Override
        public final Builder weight(Long weight) {
            this.weight = weight;
            return this;
        }

        public final void setWeight(Long weight) {
            this.weight = weight;
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        public final String getAction() {
            return action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final String getRuleWithinRuleGroup() {
            return ruleWithinRuleGroup;
        }

        @Override
        public final Builder ruleWithinRuleGroup(String ruleWithinRuleGroup) {
            this.ruleWithinRuleGroup = ruleWithinRuleGroup;
            return this;
        }

        public final void setRuleWithinRuleGroup(String ruleWithinRuleGroup) {
            this.ruleWithinRuleGroup = ruleWithinRuleGroup;
        }

        @Override
        public SampledHTTPRequest build() {
            return new SampledHTTPRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
