/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRateBasedRuleRequest extends WafRequest implements
        ToCopyableBuilder<CreateRateBasedRuleRequest.Builder, CreateRateBasedRuleRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateRateBasedRuleRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricName").getter(getter(CreateRateBasedRuleRequest::metricName)).setter(setter(Builder::metricName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()).build();

    private static final SdkField<String> RATE_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RateKey").getter(getter(CreateRateBasedRuleRequest::rateKeyAsString)).setter(setter(Builder::rateKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RateKey").build()).build();

    private static final SdkField<Long> RATE_LIMIT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("RateLimit")
            .getter(getter(CreateRateBasedRuleRequest::rateLimit)).setter(setter(Builder::rateLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RateLimit").build()).build();

    private static final SdkField<String> CHANGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChangeToken").getter(getter(CreateRateBasedRuleRequest::changeToken))
            .setter(setter(Builder::changeToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeToken").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateRateBasedRuleRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, METRIC_NAME_FIELD,
            RATE_KEY_FIELD, RATE_LIMIT_FIELD, CHANGE_TOKEN_FIELD, TAGS_FIELD));

    private final String name;

    private final String metricName;

    private final String rateKey;

    private final Long rateLimit;

    private final String changeToken;

    private final List<Tag> tags;

    private CreateRateBasedRuleRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.metricName = builder.metricName;
        this.rateKey = builder.rateKey;
        this.rateLimit = builder.rateLimit;
        this.changeToken = builder.changeToken;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A friendly name or description of the <a>RateBasedRule</a>. You can't change the name of a
     * <code>RateBasedRule</code> after you create it.
     * </p>
     * 
     * @return A friendly name or description of the <a>RateBasedRule</a>. You can't change the name of a
     *         <code>RateBasedRule</code> after you create it.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A friendly name or description for the metrics for this <code>RateBasedRule</code>. The name can contain only
     * alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and minimum length one. It can't contain
     * whitespace or metric names reserved for AWS WAF, including "All" and "Default_Action." You can't change the name
     * of the metric after you create the <code>RateBasedRule</code>.
     * </p>
     * 
     * @return A friendly name or description for the metrics for this <code>RateBasedRule</code>. The name can contain
     *         only alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and minimum length one. It can't
     *         contain whitespace or metric names reserved for AWS WAF, including "All" and "Default_Action." You can't
     *         change the name of the metric after you create the <code>RateBasedRule</code>.
     */
    public final String metricName() {
        return metricName;
    }

    /**
     * <p>
     * The field that AWS WAF uses to determine if requests are likely arriving from a single source and thus subject to
     * rate monitoring. The only valid value for <code>RateKey</code> is <code>IP</code>. <code>IP</code> indicates that
     * requests that arrive from the same IP address are subject to the <code>RateLimit</code> that is specified in the
     * <code>RateBasedRule</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rateKey} will
     * return {@link RateKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #rateKeyAsString}.
     * </p>
     * 
     * @return The field that AWS WAF uses to determine if requests are likely arriving from a single source and thus
     *         subject to rate monitoring. The only valid value for <code>RateKey</code> is <code>IP</code>.
     *         <code>IP</code> indicates that requests that arrive from the same IP address are subject to the
     *         <code>RateLimit</code> that is specified in the <code>RateBasedRule</code>.
     * @see RateKey
     */
    public final RateKey rateKey() {
        return RateKey.fromValue(rateKey);
    }

    /**
     * <p>
     * The field that AWS WAF uses to determine if requests are likely arriving from a single source and thus subject to
     * rate monitoring. The only valid value for <code>RateKey</code> is <code>IP</code>. <code>IP</code> indicates that
     * requests that arrive from the same IP address are subject to the <code>RateLimit</code> that is specified in the
     * <code>RateBasedRule</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rateKey} will
     * return {@link RateKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #rateKeyAsString}.
     * </p>
     * 
     * @return The field that AWS WAF uses to determine if requests are likely arriving from a single source and thus
     *         subject to rate monitoring. The only valid value for <code>RateKey</code> is <code>IP</code>.
     *         <code>IP</code> indicates that requests that arrive from the same IP address are subject to the
     *         <code>RateLimit</code> that is specified in the <code>RateBasedRule</code>.
     * @see RateKey
     */
    public final String rateKeyAsString() {
        return rateKey;
    }

    /**
     * <p>
     * The maximum number of requests, which have an identical value in the field that is specified by
     * <code>RateKey</code>, allowed in a five-minute period. If the number of requests exceeds the
     * <code>RateLimit</code> and the other predicates specified in the rule are also met, AWS WAF triggers the action
     * that is specified for this rule.
     * </p>
     * 
     * @return The maximum number of requests, which have an identical value in the field that is specified by
     *         <code>RateKey</code>, allowed in a five-minute period. If the number of requests exceeds the
     *         <code>RateLimit</code> and the other predicates specified in the rule are also met, AWS WAF triggers the
     *         action that is specified for this rule.
     */
    public final Long rateLimit() {
        return rateLimit;
    }

    /**
     * <p>
     * The <code>ChangeToken</code> that you used to submit the <code>CreateRateBasedRule</code> request. You can also
     * use this value to query the status of the request. For more information, see <a>GetChangeTokenStatus</a>.
     * </p>
     * 
     * @return The <code>ChangeToken</code> that you used to submit the <code>CreateRateBasedRule</code> request. You
     *         can also use this value to query the status of the request. For more information, see
     *         <a>GetChangeTokenStatus</a>.
     */
    public final String changeToken() {
        return changeToken;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p/>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(metricName());
        hashCode = 31 * hashCode + Objects.hashCode(rateKeyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(rateLimit());
        hashCode = 31 * hashCode + Objects.hashCode(changeToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRateBasedRuleRequest)) {
            return false;
        }
        CreateRateBasedRuleRequest other = (CreateRateBasedRuleRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(metricName(), other.metricName())
                && Objects.equals(rateKeyAsString(), other.rateKeyAsString()) && Objects.equals(rateLimit(), other.rateLimit())
                && Objects.equals(changeToken(), other.changeToken()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRateBasedRuleRequest").add("Name", name()).add("MetricName", metricName())
                .add("RateKey", rateKeyAsString()).add("RateLimit", rateLimit()).add("ChangeToken", changeToken())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "MetricName":
            return Optional.ofNullable(clazz.cast(metricName()));
        case "RateKey":
            return Optional.ofNullable(clazz.cast(rateKeyAsString()));
        case "RateLimit":
            return Optional.ofNullable(clazz.cast(rateLimit()));
        case "ChangeToken":
            return Optional.ofNullable(clazz.cast(changeToken()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRateBasedRuleRequest, T> g) {
        return obj -> g.apply((CreateRateBasedRuleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WafRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateRateBasedRuleRequest> {
        /**
         * <p>
         * A friendly name or description of the <a>RateBasedRule</a>. You can't change the name of a
         * <code>RateBasedRule</code> after you create it.
         * </p>
         * 
         * @param name
         *        A friendly name or description of the <a>RateBasedRule</a>. You can't change the name of a
         *        <code>RateBasedRule</code> after you create it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A friendly name or description for the metrics for this <code>RateBasedRule</code>. The name can contain only
         * alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and minimum length one. It can't contain
         * whitespace or metric names reserved for AWS WAF, including "All" and "Default_Action." You can't change the
         * name of the metric after you create the <code>RateBasedRule</code>.
         * </p>
         * 
         * @param metricName
         *        A friendly name or description for the metrics for this <code>RateBasedRule</code>. The name can
         *        contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and minimum length one.
         *        It can't contain whitespace or metric names reserved for AWS WAF, including "All" and
         *        "Default_Action." You can't change the name of the metric after you create the
         *        <code>RateBasedRule</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * The field that AWS WAF uses to determine if requests are likely arriving from a single source and thus
         * subject to rate monitoring. The only valid value for <code>RateKey</code> is <code>IP</code>. <code>IP</code>
         * indicates that requests that arrive from the same IP address are subject to the <code>RateLimit</code> that
         * is specified in the <code>RateBasedRule</code>.
         * </p>
         * 
         * @param rateKey
         *        The field that AWS WAF uses to determine if requests are likely arriving from a single source and thus
         *        subject to rate monitoring. The only valid value for <code>RateKey</code> is <code>IP</code>.
         *        <code>IP</code> indicates that requests that arrive from the same IP address are subject to the
         *        <code>RateLimit</code> that is specified in the <code>RateBasedRule</code>.
         * @see RateKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RateKey
         */
        Builder rateKey(String rateKey);

        /**
         * <p>
         * The field that AWS WAF uses to determine if requests are likely arriving from a single source and thus
         * subject to rate monitoring. The only valid value for <code>RateKey</code> is <code>IP</code>. <code>IP</code>
         * indicates that requests that arrive from the same IP address are subject to the <code>RateLimit</code> that
         * is specified in the <code>RateBasedRule</code>.
         * </p>
         * 
         * @param rateKey
         *        The field that AWS WAF uses to determine if requests are likely arriving from a single source and thus
         *        subject to rate monitoring. The only valid value for <code>RateKey</code> is <code>IP</code>.
         *        <code>IP</code> indicates that requests that arrive from the same IP address are subject to the
         *        <code>RateLimit</code> that is specified in the <code>RateBasedRule</code>.
         * @see RateKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RateKey
         */
        Builder rateKey(RateKey rateKey);

        /**
         * <p>
         * The maximum number of requests, which have an identical value in the field that is specified by
         * <code>RateKey</code>, allowed in a five-minute period. If the number of requests exceeds the
         * <code>RateLimit</code> and the other predicates specified in the rule are also met, AWS WAF triggers the
         * action that is specified for this rule.
         * </p>
         * 
         * @param rateLimit
         *        The maximum number of requests, which have an identical value in the field that is specified by
         *        <code>RateKey</code>, allowed in a five-minute period. If the number of requests exceeds the
         *        <code>RateLimit</code> and the other predicates specified in the rule are also met, AWS WAF triggers
         *        the action that is specified for this rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rateLimit(Long rateLimit);

        /**
         * <p>
         * The <code>ChangeToken</code> that you used to submit the <code>CreateRateBasedRule</code> request. You can
         * also use this value to query the status of the request. For more information, see
         * <a>GetChangeTokenStatus</a>.
         * </p>
         * 
         * @param changeToken
         *        The <code>ChangeToken</code> that you used to submit the <code>CreateRateBasedRule</code> request. You
         *        can also use this value to query the status of the request. For more information, see
         *        <a>GetChangeTokenStatus</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeToken(String changeToken);

        /**
         * <p/>
         * 
         * @param tags
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p/>
         * 
         * @param tags
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p/>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WafRequest.BuilderImpl implements Builder {
        private String name;

        private String metricName;

        private String rateKey;

        private Long rateLimit;

        private String changeToken;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRateBasedRuleRequest model) {
            super(model);
            name(model.name);
            metricName(model.metricName);
            rateKey(model.rateKey);
            rateLimit(model.rateLimit);
            changeToken(model.changeToken);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getMetricName() {
            return metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final String getRateKey() {
            return rateKey;
        }

        @Override
        public final Builder rateKey(String rateKey) {
            this.rateKey = rateKey;
            return this;
        }

        @Override
        public final Builder rateKey(RateKey rateKey) {
            this.rateKey(rateKey == null ? null : rateKey.toString());
            return this;
        }

        public final void setRateKey(String rateKey) {
            this.rateKey = rateKey;
        }

        public final Long getRateLimit() {
            return rateLimit;
        }

        @Override
        public final Builder rateLimit(Long rateLimit) {
            this.rateLimit = rateLimit;
            return this;
        }

        public final void setRateLimit(Long rateLimit) {
            this.rateLimit = rateLimit;
        }

        public final String getChangeToken() {
            return changeToken;
        }

        @Override
        public final Builder changeToken(String changeToken) {
            this.changeToken = changeToken;
            return this;
        }

        public final void setChangeToken(String changeToken) {
            this.changeToken = changeToken;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRateBasedRuleRequest build() {
            return new CreateRateBasedRuleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
