/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum CLMLanguageCode {
    EN_US("en-US"),
    HI_IN("hi-IN"),
    ES_US("es-US"),
    EN_GB("en-GB"),
    EN_AU("en-AU"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private CLMLanguageCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CLMLanguageCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(CLMLanguageCode.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CLMLanguageCode> knownValues() {
        return Stream.of(CLMLanguageCode.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

