/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamwrite.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.timestreamwrite.TimestreamWriteClient;
import software.amazon.awssdk.services.timestreamwrite.model.ListTablesRequest;
import software.amazon.awssdk.services.timestreamwrite.model.ListTablesResponse;

public class ListTablesIterable
implements SdkIterable<ListTablesResponse> {
    private final TimestreamWriteClient client;
    private final ListTablesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTablesIterable(TimestreamWriteClient client, ListTablesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListTablesResponseFetcher();
    }

    public Iterator<ListTablesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListTablesResponseFetcher
    implements SyncPageFetcher<ListTablesResponse> {
        private ListTablesResponseFetcher() {
        }

        public boolean hasNextPage(ListTablesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTablesResponse nextPage(ListTablesResponse previousPage) {
            if (previousPage == null) {
                return ListTablesIterable.this.client.listTables(ListTablesIterable.this.firstRequest);
            }
            return ListTablesIterable.this.client.listTables((ListTablesRequest)((Object)ListTablesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

