/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamquery.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ScalarType {
    VARCHAR("VARCHAR"),
    BOOLEAN("BOOLEAN"),
    BIGINT("BIGINT"),
    DOUBLE("DOUBLE"),
    TIMESTAMP("TIMESTAMP"),
    DATE("DATE"),
    TIME("TIME"),
    INTERVAL_DAY_TO_SECOND("INTERVAL_DAY_TO_SECOND"),
    INTERVAL_YEAR_TO_MONTH("INTERVAL_YEAR_TO_MONTH"),
    UNKNOWN("UNKNOWN"),
    INTEGER("INTEGER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ScalarType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ScalarType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ScalarType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ScalarType> knownValues() {
        return Stream.of(ScalarType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

