/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.synthetics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This structure specifies how often a canary is to make runs and the date and time when it should stop making runs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CanaryScheduleInput implements SdkPojo, Serializable,
        ToCopyableBuilder<CanaryScheduleInput.Builder, CanaryScheduleInput> {
    private static final SdkField<String> EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Expression").getter(getter(CanaryScheduleInput::expression)).setter(setter(Builder::expression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expression").build()).build();

    private static final SdkField<Long> DURATION_IN_SECONDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("DurationInSeconds").getter(getter(CanaryScheduleInput::durationInSeconds))
            .setter(setter(Builder::durationInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationInSeconds").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPRESSION_FIELD,
            DURATION_IN_SECONDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String expression;

    private final Long durationInSeconds;

    private CanaryScheduleInput(BuilderImpl builder) {
        this.expression = builder.expression;
        this.durationInSeconds = builder.durationInSeconds;
    }

    /**
     * <p>
     * A rate expression that defines how often the canary is to run. The syntax is
     * <code>rate(<i>number unit</i>)</code>. <i>unit</i> can be <code>minute</code>, <code>minutes</code>, or
     * <code>hour</code>.
     * </p>
     * <p>
     * For example, <code>rate(1 minute)</code> runs the canary once a minute, <code>rate(10 minutes)</code> runs it
     * once every 10 minutes, and <code>rate(1 hour)</code> runs it once every hour. You can specify a frequency between
     * <code>rate(1 minute)</code> and <code>rate(1 hour)</code>.
     * </p>
     * <p>
     * Specifying <code>rate(0 minute)</code> or <code>rate(0 hour)</code> is a special value that causes the canary to
     * run only once when it is started.
     * </p>
     * 
     * @return A rate expression that defines how often the canary is to run. The syntax is
     *         <code>rate(<i>number unit</i>)</code>. <i>unit</i> can be <code>minute</code>, <code>minutes</code>, or
     *         <code>hour</code>. </p>
     *         <p>
     *         For example, <code>rate(1 minute)</code> runs the canary once a minute, <code>rate(10 minutes)</code>
     *         runs it once every 10 minutes, and <code>rate(1 hour)</code> runs it once every hour. You can specify a
     *         frequency between <code>rate(1 minute)</code> and <code>rate(1 hour)</code>.
     *         </p>
     *         <p>
     *         Specifying <code>rate(0 minute)</code> or <code>rate(0 hour)</code> is a special value that causes the
     *         canary to run only once when it is started.
     */
    public final String expression() {
        return expression;
    }

    /**
     * <p>
     * How long, in seconds, for the canary to continue making regular runs according to the schedule in the
     * <code>Expression</code> value. If you specify 0, the canary continues making runs until you stop it. If you omit
     * this field, the default of 0 is used.
     * </p>
     * 
     * @return How long, in seconds, for the canary to continue making regular runs according to the schedule in the
     *         <code>Expression</code> value. If you specify 0, the canary continues making runs until you stop it. If
     *         you omit this field, the default of 0 is used.
     */
    public final Long durationInSeconds() {
        return durationInSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(expression());
        hashCode = 31 * hashCode + Objects.hashCode(durationInSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CanaryScheduleInput)) {
            return false;
        }
        CanaryScheduleInput other = (CanaryScheduleInput) obj;
        return Objects.equals(expression(), other.expression()) && Objects.equals(durationInSeconds(), other.durationInSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CanaryScheduleInput").add("Expression", expression())
                .add("DurationInSeconds", durationInSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Expression":
            return Optional.ofNullable(clazz.cast(expression()));
        case "DurationInSeconds":
            return Optional.ofNullable(clazz.cast(durationInSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CanaryScheduleInput, T> g) {
        return obj -> g.apply((CanaryScheduleInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CanaryScheduleInput> {
        /**
         * <p>
         * A rate expression that defines how often the canary is to run. The syntax is
         * <code>rate(<i>number unit</i>)</code>. <i>unit</i> can be <code>minute</code>, <code>minutes</code>, or
         * <code>hour</code>.
         * </p>
         * <p>
         * For example, <code>rate(1 minute)</code> runs the canary once a minute, <code>rate(10 minutes)</code> runs it
         * once every 10 minutes, and <code>rate(1 hour)</code> runs it once every hour. You can specify a frequency
         * between <code>rate(1 minute)</code> and <code>rate(1 hour)</code>.
         * </p>
         * <p>
         * Specifying <code>rate(0 minute)</code> or <code>rate(0 hour)</code> is a special value that causes the canary
         * to run only once when it is started.
         * </p>
         * 
         * @param expression
         *        A rate expression that defines how often the canary is to run. The syntax is
         *        <code>rate(<i>number unit</i>)</code>. <i>unit</i> can be <code>minute</code>, <code>minutes</code>,
         *        or <code>hour</code>. </p>
         *        <p>
         *        For example, <code>rate(1 minute)</code> runs the canary once a minute, <code>rate(10 minutes)</code>
         *        runs it once every 10 minutes, and <code>rate(1 hour)</code> runs it once every hour. You can specify
         *        a frequency between <code>rate(1 minute)</code> and <code>rate(1 hour)</code>.
         *        </p>
         *        <p>
         *        Specifying <code>rate(0 minute)</code> or <code>rate(0 hour)</code> is a special value that causes the
         *        canary to run only once when it is started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expression(String expression);

        /**
         * <p>
         * How long, in seconds, for the canary to continue making regular runs according to the schedule in the
         * <code>Expression</code> value. If you specify 0, the canary continues making runs until you stop it. If you
         * omit this field, the default of 0 is used.
         * </p>
         * 
         * @param durationInSeconds
         *        How long, in seconds, for the canary to continue making regular runs according to the schedule in the
         *        <code>Expression</code> value. If you specify 0, the canary continues making runs until you stop it.
         *        If you omit this field, the default of 0 is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationInSeconds(Long durationInSeconds);
    }

    static final class BuilderImpl implements Builder {
        private String expression;

        private Long durationInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(CanaryScheduleInput model) {
            expression(model.expression);
            durationInSeconds(model.durationInSeconds);
        }

        public final String getExpression() {
            return expression;
        }

        @Override
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public final void setExpression(String expression) {
            this.expression = expression;
        }

        public final Long getDurationInSeconds() {
            return durationInSeconds;
        }

        @Override
        public final Builder durationInSeconds(Long durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
            return this;
        }

        public final void setDurationInSeconds(Long durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
        }

        @Override
        public CanaryScheduleInput build() {
            return new CanaryScheduleInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
