/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * UpdateVTLDeviceTypeOutput
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateVtlDeviceTypeResponse extends StorageGatewayResponse implements
        ToCopyableBuilder<UpdateVtlDeviceTypeResponse.Builder, UpdateVtlDeviceTypeResponse> {
    private static final SdkField<String> VTL_DEVICE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VTLDeviceARN").getter(getter(UpdateVtlDeviceTypeResponse::vtlDeviceARN))
            .setter(setter(Builder::vtlDeviceARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VTLDeviceARN").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VTL_DEVICE_ARN_FIELD));

    private final String vtlDeviceARN;

    private UpdateVtlDeviceTypeResponse(BuilderImpl builder) {
        super(builder);
        this.vtlDeviceARN = builder.vtlDeviceARN;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the medium changer you have selected.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the medium changer you have selected.
     */
    public final String vtlDeviceARN() {
        return vtlDeviceARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vtlDeviceARN());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateVtlDeviceTypeResponse)) {
            return false;
        }
        UpdateVtlDeviceTypeResponse other = (UpdateVtlDeviceTypeResponse) obj;
        return Objects.equals(vtlDeviceARN(), other.vtlDeviceARN());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateVtlDeviceTypeResponse").add("VTLDeviceARN", vtlDeviceARN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VTLDeviceARN":
            return Optional.ofNullable(clazz.cast(vtlDeviceARN()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateVtlDeviceTypeResponse, T> g) {
        return obj -> g.apply((UpdateVtlDeviceTypeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateVtlDeviceTypeResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the medium changer you have selected.
         * </p>
         * 
         * @param vtlDeviceARN
         *        The Amazon Resource Name (ARN) of the medium changer you have selected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vtlDeviceARN(String vtlDeviceARN);
    }

    static final class BuilderImpl extends StorageGatewayResponse.BuilderImpl implements Builder {
        private String vtlDeviceARN;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateVtlDeviceTypeResponse model) {
            super(model);
            vtlDeviceARN(model.vtlDeviceARN);
        }

        public final String getVtlDeviceARN() {
            return vtlDeviceARN;
        }

        @Override
        public final Builder vtlDeviceARN(String vtlDeviceARN) {
            this.vtlDeviceARN = vtlDeviceARN;
            return this;
        }

        public final void setVtlDeviceARN(String vtlDeviceARN) {
            this.vtlDeviceARN = vtlDeviceARN;
        }

        @Override
        public UpdateVtlDeviceTypeResponse build() {
            return new UpdateVtlDeviceTypeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
