/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateVtlDeviceTypeRequest extends StorageGatewayRequest implements
        ToCopyableBuilder<UpdateVtlDeviceTypeRequest.Builder, UpdateVtlDeviceTypeRequest> {
    private static final SdkField<String> VTL_DEVICE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VTLDeviceARN").getter(getter(UpdateVtlDeviceTypeRequest::vtlDeviceARN))
            .setter(setter(Builder::vtlDeviceARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VTLDeviceARN").build()).build();

    private static final SdkField<String> DEVICE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceType").getter(getter(UpdateVtlDeviceTypeRequest::deviceType)).setter(setter(Builder::deviceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VTL_DEVICE_ARN_FIELD,
            DEVICE_TYPE_FIELD));

    private final String vtlDeviceARN;

    private final String deviceType;

    private UpdateVtlDeviceTypeRequest(BuilderImpl builder) {
        super(builder);
        this.vtlDeviceARN = builder.vtlDeviceARN;
        this.deviceType = builder.deviceType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the medium changer you want to select.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the medium changer you want to select.
     */
    public final String vtlDeviceARN() {
        return vtlDeviceARN;
    }

    /**
     * <p>
     * The type of medium changer you want to select.
     * </p>
     * <p>
     * Valid Values: <code>STK-L700</code> | <code>AWS-Gateway-VTL</code> | <code>IBM-03584L32-0402</code>
     * </p>
     * 
     * @return The type of medium changer you want to select.</p>
     *         <p>
     *         Valid Values: <code>STK-L700</code> | <code>AWS-Gateway-VTL</code> | <code>IBM-03584L32-0402</code>
     */
    public final String deviceType() {
        return deviceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vtlDeviceARN());
        hashCode = 31 * hashCode + Objects.hashCode(deviceType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateVtlDeviceTypeRequest)) {
            return false;
        }
        UpdateVtlDeviceTypeRequest other = (UpdateVtlDeviceTypeRequest) obj;
        return Objects.equals(vtlDeviceARN(), other.vtlDeviceARN()) && Objects.equals(deviceType(), other.deviceType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateVtlDeviceTypeRequest").add("VTLDeviceARN", vtlDeviceARN()).add("DeviceType", deviceType())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VTLDeviceARN":
            return Optional.ofNullable(clazz.cast(vtlDeviceARN()));
        case "DeviceType":
            return Optional.ofNullable(clazz.cast(deviceType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateVtlDeviceTypeRequest, T> g) {
        return obj -> g.apply((UpdateVtlDeviceTypeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateVtlDeviceTypeRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the medium changer you want to select.
         * </p>
         * 
         * @param vtlDeviceARN
         *        The Amazon Resource Name (ARN) of the medium changer you want to select.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vtlDeviceARN(String vtlDeviceARN);

        /**
         * <p>
         * The type of medium changer you want to select.
         * </p>
         * <p>
         * Valid Values: <code>STK-L700</code> | <code>AWS-Gateway-VTL</code> | <code>IBM-03584L32-0402</code>
         * </p>
         * 
         * @param deviceType
         *        The type of medium changer you want to select.</p>
         *        <p>
         *        Valid Values: <code>STK-L700</code> | <code>AWS-Gateway-VTL</code> | <code>IBM-03584L32-0402</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceType(String deviceType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends StorageGatewayRequest.BuilderImpl implements Builder {
        private String vtlDeviceARN;

        private String deviceType;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateVtlDeviceTypeRequest model) {
            super(model);
            vtlDeviceARN(model.vtlDeviceARN);
            deviceType(model.deviceType);
        }

        public final String getVtlDeviceARN() {
            return vtlDeviceARN;
        }

        @Override
        public final Builder vtlDeviceARN(String vtlDeviceARN) {
            this.vtlDeviceARN = vtlDeviceARN;
            return this;
        }

        public final void setVtlDeviceARN(String vtlDeviceARN) {
            this.vtlDeviceARN = vtlDeviceARN;
        }

        public final String getDeviceType() {
            return deviceType;
        }

        @Override
        public final Builder deviceType(String deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        public final void setDeviceType(String deviceType) {
            this.deviceType = deviceType;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateVtlDeviceTypeRequest build() {
            return new UpdateVtlDeviceTypeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
