/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * UpdateSMBFileShareInput
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSmbFileShareRequest extends StorageGatewayRequest implements
        ToCopyableBuilder<UpdateSmbFileShareRequest.Builder, UpdateSmbFileShareRequest> {
    private static final SdkField<String> FILE_SHARE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileShareARN").getter(getter(UpdateSmbFileShareRequest::fileShareARN))
            .setter(setter(Builder::fileShareARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileShareARN").build()).build();

    private static final SdkField<Boolean> KMS_ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("KMSEncrypted").getter(getter(UpdateSmbFileShareRequest::kmsEncrypted))
            .setter(setter(Builder::kmsEncrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSEncrypted").build()).build();

    private static final SdkField<String> KMS_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("KMSKey")
            .getter(getter(UpdateSmbFileShareRequest::kmsKey)).setter(setter(Builder::kmsKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSKey").build()).build();

    private static final SdkField<String> DEFAULT_STORAGE_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultStorageClass").getter(getter(UpdateSmbFileShareRequest::defaultStorageClass))
            .setter(setter(Builder::defaultStorageClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultStorageClass").build())
            .build();

    private static final SdkField<String> OBJECT_ACL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ObjectACL").getter(getter(UpdateSmbFileShareRequest::objectACLAsString))
            .setter(setter(Builder::objectACL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectACL").build()).build();

    private static final SdkField<Boolean> READ_ONLY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ReadOnly").getter(getter(UpdateSmbFileShareRequest::readOnly)).setter(setter(Builder::readOnly))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadOnly").build()).build();

    private static final SdkField<Boolean> GUESS_MIME_TYPE_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("GuessMIMETypeEnabled").getter(getter(UpdateSmbFileShareRequest::guessMIMETypeEnabled))
            .setter(setter(Builder::guessMIMETypeEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GuessMIMETypeEnabled").build())
            .build();

    private static final SdkField<Boolean> REQUESTER_PAYS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RequesterPays").getter(getter(UpdateSmbFileShareRequest::requesterPays))
            .setter(setter(Builder::requesterPays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterPays").build()).build();

    private static final SdkField<Boolean> SMBACL_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SMBACLEnabled").getter(getter(UpdateSmbFileShareRequest::smbaclEnabled))
            .setter(setter(Builder::smbaclEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SMBACLEnabled").build()).build();

    private static final SdkField<Boolean> ACCESS_BASED_ENUMERATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AccessBasedEnumeration").getter(getter(UpdateSmbFileShareRequest::accessBasedEnumeration))
            .setter(setter(Builder::accessBasedEnumeration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessBasedEnumeration").build())
            .build();

    private static final SdkField<List<String>> ADMIN_USER_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AdminUserList")
            .getter(getter(UpdateSmbFileShareRequest::adminUserList))
            .setter(setter(Builder::adminUserList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdminUserList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> VALID_USER_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ValidUserList")
            .getter(getter(UpdateSmbFileShareRequest::validUserList))
            .setter(setter(Builder::validUserList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidUserList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> INVALID_USER_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("InvalidUserList")
            .getter(getter(UpdateSmbFileShareRequest::invalidUserList))
            .setter(setter(Builder::invalidUserList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvalidUserList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> AUDIT_DESTINATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuditDestinationARN").getter(getter(UpdateSmbFileShareRequest::auditDestinationARN))
            .setter(setter(Builder::auditDestinationARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuditDestinationARN").build())
            .build();

    private static final SdkField<String> CASE_SENSITIVITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CaseSensitivity").getter(getter(UpdateSmbFileShareRequest::caseSensitivityAsString))
            .setter(setter(Builder::caseSensitivity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CaseSensitivity").build()).build();

    private static final SdkField<String> FILE_SHARE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileShareName").getter(getter(UpdateSmbFileShareRequest::fileShareName))
            .setter(setter(Builder::fileShareName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileShareName").build()).build();

    private static final SdkField<CacheAttributes> CACHE_ATTRIBUTES_FIELD = SdkField
            .<CacheAttributes> builder(MarshallingType.SDK_POJO).memberName("CacheAttributes")
            .getter(getter(UpdateSmbFileShareRequest::cacheAttributes)).setter(setter(Builder::cacheAttributes))
            .constructor(CacheAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheAttributes").build()).build();

    private static final SdkField<String> NOTIFICATION_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NotificationPolicy").getter(getter(UpdateSmbFileShareRequest::notificationPolicy))
            .setter(setter(Builder::notificationPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationPolicy").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_SHARE_ARN_FIELD,
            KMS_ENCRYPTED_FIELD, KMS_KEY_FIELD, DEFAULT_STORAGE_CLASS_FIELD, OBJECT_ACL_FIELD, READ_ONLY_FIELD,
            GUESS_MIME_TYPE_ENABLED_FIELD, REQUESTER_PAYS_FIELD, SMBACL_ENABLED_FIELD, ACCESS_BASED_ENUMERATION_FIELD,
            ADMIN_USER_LIST_FIELD, VALID_USER_LIST_FIELD, INVALID_USER_LIST_FIELD, AUDIT_DESTINATION_ARN_FIELD,
            CASE_SENSITIVITY_FIELD, FILE_SHARE_NAME_FIELD, CACHE_ATTRIBUTES_FIELD, NOTIFICATION_POLICY_FIELD));

    private final String fileShareARN;

    private final Boolean kmsEncrypted;

    private final String kmsKey;

    private final String defaultStorageClass;

    private final String objectACL;

    private final Boolean readOnly;

    private final Boolean guessMIMETypeEnabled;

    private final Boolean requesterPays;

    private final Boolean smbaclEnabled;

    private final Boolean accessBasedEnumeration;

    private final List<String> adminUserList;

    private final List<String> validUserList;

    private final List<String> invalidUserList;

    private final String auditDestinationARN;

    private final String caseSensitivity;

    private final String fileShareName;

    private final CacheAttributes cacheAttributes;

    private final String notificationPolicy;

    private UpdateSmbFileShareRequest(BuilderImpl builder) {
        super(builder);
        this.fileShareARN = builder.fileShareARN;
        this.kmsEncrypted = builder.kmsEncrypted;
        this.kmsKey = builder.kmsKey;
        this.defaultStorageClass = builder.defaultStorageClass;
        this.objectACL = builder.objectACL;
        this.readOnly = builder.readOnly;
        this.guessMIMETypeEnabled = builder.guessMIMETypeEnabled;
        this.requesterPays = builder.requesterPays;
        this.smbaclEnabled = builder.smbaclEnabled;
        this.accessBasedEnumeration = builder.accessBasedEnumeration;
        this.adminUserList = builder.adminUserList;
        this.validUserList = builder.validUserList;
        this.invalidUserList = builder.invalidUserList;
        this.auditDestinationARN = builder.auditDestinationARN;
        this.caseSensitivity = builder.caseSensitivity;
        this.fileShareName = builder.fileShareName;
        this.cacheAttributes = builder.cacheAttributes;
        this.notificationPolicy = builder.notificationPolicy;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the SMB file share that you want to update.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the SMB file share that you want to update.
     */
    public final String fileShareARN() {
        return fileShareARN;
    }

    /**
     * <p>
     * Set to <code>true</code> to use Amazon S3 server-side encryption with your own AWS KMS key, or <code>false</code>
     * to use a key managed by Amazon S3. Optional.
     * </p>
     * <p>
     * Valid Values: <code>true</code> | <code>false</code>
     * </p>
     * 
     * @return Set to <code>true</code> to use Amazon S3 server-side encryption with your own AWS KMS key, or
     *         <code>false</code> to use a key managed by Amazon S3. Optional.</p>
     *         <p>
     *         Valid Values: <code>true</code> | <code>false</code>
     */
    public final Boolean kmsEncrypted() {
        return kmsEncrypted;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side
     * encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when
     * <code>KMSEncrypted</code> is <code>true</code>. Optional.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side
     *         encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when
     *         <code>KMSEncrypted</code> is <code>true</code>. Optional.
     */
    public final String kmsKey() {
        return kmsKey;
    }

    /**
     * <p>
     * The default storage class for objects put into an Amazon S3 bucket by the file gateway. The default value is
     * <code>S3_INTELLIGENT_TIERING</code>. Optional.
     * </p>
     * <p>
     * Valid Values: <code>S3_STANDARD</code> | <code>S3_INTELLIGENT_TIERING</code> | <code>S3_STANDARD_IA</code> |
     * <code>S3_ONEZONE_IA</code>
     * </p>
     * 
     * @return The default storage class for objects put into an Amazon S3 bucket by the file gateway. The default value
     *         is <code>S3_INTELLIGENT_TIERING</code>. Optional.</p>
     *         <p>
     *         Valid Values: <code>S3_STANDARD</code> | <code>S3_INTELLIGENT_TIERING</code> |
     *         <code>S3_STANDARD_IA</code> | <code>S3_ONEZONE_IA</code>
     */
    public final String defaultStorageClass() {
        return defaultStorageClass;
    }

    /**
     * <p>
     * A value that sets the access control list (ACL) permission for objects in the S3 bucket that a file gateway puts
     * objects into. The default value is <code>private</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #objectACL} will
     * return {@link ObjectACL#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #objectACLAsString}.
     * </p>
     * 
     * @return A value that sets the access control list (ACL) permission for objects in the S3 bucket that a file
     *         gateway puts objects into. The default value is <code>private</code>.
     * @see ObjectACL
     */
    public final ObjectACL objectACL() {
        return ObjectACL.fromValue(objectACL);
    }

    /**
     * <p>
     * A value that sets the access control list (ACL) permission for objects in the S3 bucket that a file gateway puts
     * objects into. The default value is <code>private</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #objectACL} will
     * return {@link ObjectACL#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #objectACLAsString}.
     * </p>
     * 
     * @return A value that sets the access control list (ACL) permission for objects in the S3 bucket that a file
     *         gateway puts objects into. The default value is <code>private</code>.
     * @see ObjectACL
     */
    public final String objectACLAsString() {
        return objectACL;
    }

    /**
     * <p>
     * A value that sets the write status of a file share. Set this value to <code>true</code> to set write status to
     * read-only, otherwise set to <code>false</code>.
     * </p>
     * <p>
     * Valid Values: <code>true</code> | <code>false</code>
     * </p>
     * 
     * @return A value that sets the write status of a file share. Set this value to <code>true</code> to set write
     *         status to read-only, otherwise set to <code>false</code>.</p>
     *         <p>
     *         Valid Values: <code>true</code> | <code>false</code>
     */
    public final Boolean readOnly() {
        return readOnly;
    }

    /**
     * <p>
     * A value that enables guessing of the MIME type for uploaded objects based on file extensions. Set this value to
     * <code>true</code> to enable MIME type guessing, otherwise set to <code>false</code>. The default value is
     * <code>true</code>.
     * </p>
     * <p>
     * Valid Values: <code>true</code> | <code>false</code>
     * </p>
     * 
     * @return A value that enables guessing of the MIME type for uploaded objects based on file extensions. Set this
     *         value to <code>true</code> to enable MIME type guessing, otherwise set to <code>false</code>. The default
     *         value is <code>true</code>.</p>
     *         <p>
     *         Valid Values: <code>true</code> | <code>false</code>
     */
    public final Boolean guessMIMETypeEnabled() {
        return guessMIMETypeEnabled;
    }

    /**
     * <p>
     * A value that sets who pays the cost of the request and the cost associated with data download from the S3 bucket.
     * If this value is set to <code>true</code>, the requester pays the costs; otherwise, the S3 bucket owner pays.
     * However, the S3 bucket owner always pays the cost of storing data.
     * </p>
     * <note>
     * <p>
     * <code>RequesterPays</code> is a configuration for the S3 bucket that backs the file share, so make sure that the
     * configuration on the file share is the same as the S3 bucket configuration.
     * </p>
     * </note>
     * <p>
     * Valid Values: <code>true</code> | <code>false</code>
     * </p>
     * 
     * @return A value that sets who pays the cost of the request and the cost associated with data download from the S3
     *         bucket. If this value is set to <code>true</code>, the requester pays the costs; otherwise, the S3 bucket
     *         owner pays. However, the S3 bucket owner always pays the cost of storing data.</p> <note>
     *         <p>
     *         <code>RequesterPays</code> is a configuration for the S3 bucket that backs the file share, so make sure
     *         that the configuration on the file share is the same as the S3 bucket configuration.
     *         </p>
     *         </note>
     *         <p>
     *         Valid Values: <code>true</code> | <code>false</code>
     */
    public final Boolean requesterPays() {
        return requesterPays;
    }

    /**
     * <p>
     * Set this value to <code>true</code> to enable access control list (ACL) on the SMB file share. Set it to
     * <code>false</code> to map file and directory permissions to the POSIX permissions.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/storagegateway/latest/userguide/smb-acl.html">Using Microsoft Windows ACLs to
     * control access to an SMB file share</a> in the <i>AWS Storage Gateway User Guide</i>.
     * </p>
     * <p>
     * Valid Values: <code>true</code> | <code>false</code>
     * </p>
     * 
     * @return Set this value to <code>true</code> to enable access control list (ACL) on the SMB file share. Set it to
     *         <code>false</code> to map file and directory permissions to the POSIX permissions.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/storagegateway/latest/userguide/smb-acl.html">Using Microsoft Windows
     *         ACLs to control access to an SMB file share</a> in the <i>AWS Storage Gateway User Guide</i>.
     *         </p>
     *         <p>
     *         Valid Values: <code>true</code> | <code>false</code>
     */
    public final Boolean smbaclEnabled() {
        return smbaclEnabled;
    }

    /**
     * <p>
     * The files and folders on this share will only be visible to users with read access.
     * </p>
     * 
     * @return The files and folders on this share will only be visible to users with read access.
     */
    public final Boolean accessBasedEnumeration() {
        return accessBasedEnumeration;
    }

    /**
     * Returns true if the AdminUserList property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAdminUserList() {
        return adminUserList != null && !(adminUserList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of users or groups in the Active Directory that have administrator rights to the file share. A group must
     * be prefixed with the @ character. Acceptable formats include: <code>DOMAIN\User1</code>, <code>user1</code>,
     * <code>@group1</code>, and <code>@DOMAIN\group1</code>. Can only be set if Authentication is set to
     * <code>ActiveDirectory</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAdminUserList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of users or groups in the Active Directory that have administrator rights to the file share. A
     *         group must be prefixed with the @ character. Acceptable formats include: <code>DOMAIN\User1</code>,
     *         <code>user1</code>, <code>@group1</code>, and <code>@DOMAIN\group1</code>. Can only be set if
     *         Authentication is set to <code>ActiveDirectory</code>.
     */
    public final List<String> adminUserList() {
        return adminUserList;
    }

    /**
     * Returns true if the ValidUserList property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasValidUserList() {
        return validUserList != null && !(validUserList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of users or groups in the Active Directory that are allowed to access the file share. A group must be
     * prefixed with the @ character. Acceptable formats include: <code>DOMAIN\User1</code>, <code>user1</code>,
     * <code>@group1</code>, and <code>@DOMAIN\group1</code>. Can only be set if Authentication is set to
     * <code>ActiveDirectory</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasValidUserList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of users or groups in the Active Directory that are allowed to access the file share. A group must
     *         be prefixed with the @ character. Acceptable formats include: <code>DOMAIN\User1</code>,
     *         <code>user1</code>, <code>@group1</code>, and <code>@DOMAIN\group1</code>. Can only be set if
     *         Authentication is set to <code>ActiveDirectory</code>.
     */
    public final List<String> validUserList() {
        return validUserList;
    }

    /**
     * Returns true if the InvalidUserList property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasInvalidUserList() {
        return invalidUserList != null && !(invalidUserList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of users or groups in the Active Directory that are not allowed to access the file share. A group must be
     * prefixed with the @ character. Acceptable formats include: <code>DOMAIN\User1</code>, <code>user1</code>,
     * <code>@group1</code>, and <code>@DOMAIN\group1</code>. Can only be set if Authentication is set to
     * <code>ActiveDirectory</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInvalidUserList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of users or groups in the Active Directory that are not allowed to access the file share. A group
     *         must be prefixed with the @ character. Acceptable formats include: <code>DOMAIN\User1</code>,
     *         <code>user1</code>, <code>@group1</code>, and <code>@DOMAIN\group1</code>. Can only be set if
     *         Authentication is set to <code>ActiveDirectory</code>.
     */
    public final List<String> invalidUserList() {
        return invalidUserList;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the storage used for audit logs.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the storage used for audit logs.
     */
    public final String auditDestinationARN() {
        return auditDestinationARN;
    }

    /**
     * <p>
     * The case of an object name in an Amazon S3 bucket. For <code>ClientSpecified</code>, the client determines the
     * case sensitivity. For <code>CaseSensitive</code>, the gateway determines the case sensitivity. The default value
     * is <code>ClientSpecified</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #caseSensitivity}
     * will return {@link CaseSensitivity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #caseSensitivityAsString}.
     * </p>
     * 
     * @return The case of an object name in an Amazon S3 bucket. For <code>ClientSpecified</code>, the client
     *         determines the case sensitivity. For <code>CaseSensitive</code>, the gateway determines the case
     *         sensitivity. The default value is <code>ClientSpecified</code>.
     * @see CaseSensitivity
     */
    public final CaseSensitivity caseSensitivity() {
        return CaseSensitivity.fromValue(caseSensitivity);
    }

    /**
     * <p>
     * The case of an object name in an Amazon S3 bucket. For <code>ClientSpecified</code>, the client determines the
     * case sensitivity. For <code>CaseSensitive</code>, the gateway determines the case sensitivity. The default value
     * is <code>ClientSpecified</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #caseSensitivity}
     * will return {@link CaseSensitivity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #caseSensitivityAsString}.
     * </p>
     * 
     * @return The case of an object name in an Amazon S3 bucket. For <code>ClientSpecified</code>, the client
     *         determines the case sensitivity. For <code>CaseSensitive</code>, the gateway determines the case
     *         sensitivity. The default value is <code>ClientSpecified</code>.
     * @see CaseSensitivity
     */
    public final String caseSensitivityAsString() {
        return caseSensitivity;
    }

    /**
     * <p>
     * The name of the file share. Optional.
     * </p>
     * <note>
     * <p>
     * <code>FileShareName</code> must be set if an S3 prefix name is set in <code>LocationARN</code>.
     * </p>
     * </note>
     * 
     * @return The name of the file share. Optional.</p> <note>
     *         <p>
     *         <code>FileShareName</code> must be set if an S3 prefix name is set in <code>LocationARN</code>.
     *         </p>
     */
    public final String fileShareName() {
        return fileShareName;
    }

    /**
     * <p>
     * Specifies refresh cache information for the file share.
     * </p>
     * 
     * @return Specifies refresh cache information for the file share.
     */
    public final CacheAttributes cacheAttributes() {
        return cacheAttributes;
    }

    /**
     * <p>
     * The notification policy of the file share. <code>SettlingTimeInSeconds</code> controls the number of seconds to
     * wait after the last point in time a client wrote to a file before generating an <code>ObjectUploaded</code>
     * notification. Because clients can make many small writes to files, it's best to set this parameter for as long as
     * possible to avoid generating multiple notifications for the same file in a small time period.
     * </p>
     * <note>
     * <p>
     * <code>SettlingTimeInSeconds</code> has no effect on the timing of the object uploading to Amazon S3, only the
     * timing of the notification.
     * </p>
     * </note>
     * <p>
     * The following example sets <code>NotificationPolicy</code> on with <code>SettlingTimeInSeconds</code> set to 60.
     * </p>
     * <p>
     * <code>{\"Upload\": {\"SettlingTimeInSeconds\": 60}}</code>
     * </p>
     * <p>
     * The following example sets <code>NotificationPolicy</code> off.
     * </p>
     * <p>
     * <code>{}</code>
     * </p>
     * 
     * @return The notification policy of the file share. <code>SettlingTimeInSeconds</code> controls the number of
     *         seconds to wait after the last point in time a client wrote to a file before generating an
     *         <code>ObjectUploaded</code> notification. Because clients can make many small writes to files, it's best
     *         to set this parameter for as long as possible to avoid generating multiple notifications for the same
     *         file in a small time period.</p> <note>
     *         <p>
     *         <code>SettlingTimeInSeconds</code> has no effect on the timing of the object uploading to Amazon S3, only
     *         the timing of the notification.
     *         </p>
     *         </note>
     *         <p>
     *         The following example sets <code>NotificationPolicy</code> on with <code>SettlingTimeInSeconds</code> set
     *         to 60.
     *         </p>
     *         <p>
     *         <code>{\"Upload\": {\"SettlingTimeInSeconds\": 60}}</code>
     *         </p>
     *         <p>
     *         The following example sets <code>NotificationPolicy</code> off.
     *         </p>
     *         <p>
     *         <code>{}</code>
     */
    public final String notificationPolicy() {
        return notificationPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fileShareARN());
        hashCode = 31 * hashCode + Objects.hashCode(kmsEncrypted());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKey());
        hashCode = 31 * hashCode + Objects.hashCode(defaultStorageClass());
        hashCode = 31 * hashCode + Objects.hashCode(objectACLAsString());
        hashCode = 31 * hashCode + Objects.hashCode(readOnly());
        hashCode = 31 * hashCode + Objects.hashCode(guessMIMETypeEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(requesterPays());
        hashCode = 31 * hashCode + Objects.hashCode(smbaclEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(accessBasedEnumeration());
        hashCode = 31 * hashCode + Objects.hashCode(hasAdminUserList() ? adminUserList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasValidUserList() ? validUserList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasInvalidUserList() ? invalidUserList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(auditDestinationARN());
        hashCode = 31 * hashCode + Objects.hashCode(caseSensitivityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(fileShareName());
        hashCode = 31 * hashCode + Objects.hashCode(cacheAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(notificationPolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSmbFileShareRequest)) {
            return false;
        }
        UpdateSmbFileShareRequest other = (UpdateSmbFileShareRequest) obj;
        return Objects.equals(fileShareARN(), other.fileShareARN()) && Objects.equals(kmsEncrypted(), other.kmsEncrypted())
                && Objects.equals(kmsKey(), other.kmsKey()) && Objects.equals(defaultStorageClass(), other.defaultStorageClass())
                && Objects.equals(objectACLAsString(), other.objectACLAsString()) && Objects.equals(readOnly(), other.readOnly())
                && Objects.equals(guessMIMETypeEnabled(), other.guessMIMETypeEnabled())
                && Objects.equals(requesterPays(), other.requesterPays())
                && Objects.equals(smbaclEnabled(), other.smbaclEnabled())
                && Objects.equals(accessBasedEnumeration(), other.accessBasedEnumeration())
                && hasAdminUserList() == other.hasAdminUserList() && Objects.equals(adminUserList(), other.adminUserList())
                && hasValidUserList() == other.hasValidUserList() && Objects.equals(validUserList(), other.validUserList())
                && hasInvalidUserList() == other.hasInvalidUserList()
                && Objects.equals(invalidUserList(), other.invalidUserList())
                && Objects.equals(auditDestinationARN(), other.auditDestinationARN())
                && Objects.equals(caseSensitivityAsString(), other.caseSensitivityAsString())
                && Objects.equals(fileShareName(), other.fileShareName())
                && Objects.equals(cacheAttributes(), other.cacheAttributes())
                && Objects.equals(notificationPolicy(), other.notificationPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSmbFileShareRequest").add("FileShareARN", fileShareARN())
                .add("KMSEncrypted", kmsEncrypted()).add("KMSKey", kmsKey()).add("DefaultStorageClass", defaultStorageClass())
                .add("ObjectACL", objectACLAsString()).add("ReadOnly", readOnly())
                .add("GuessMIMETypeEnabled", guessMIMETypeEnabled()).add("RequesterPays", requesterPays())
                .add("SMBACLEnabled", smbaclEnabled()).add("AccessBasedEnumeration", accessBasedEnumeration())
                .add("AdminUserList", hasAdminUserList() ? adminUserList() : null)
                .add("ValidUserList", hasValidUserList() ? validUserList() : null)
                .add("InvalidUserList", hasInvalidUserList() ? invalidUserList() : null)
                .add("AuditDestinationARN", auditDestinationARN()).add("CaseSensitivity", caseSensitivityAsString())
                .add("FileShareName", fileShareName()).add("CacheAttributes", cacheAttributes())
                .add("NotificationPolicy", notificationPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FileShareARN":
            return Optional.ofNullable(clazz.cast(fileShareARN()));
        case "KMSEncrypted":
            return Optional.ofNullable(clazz.cast(kmsEncrypted()));
        case "KMSKey":
            return Optional.ofNullable(clazz.cast(kmsKey()));
        case "DefaultStorageClass":
            return Optional.ofNullable(clazz.cast(defaultStorageClass()));
        case "ObjectACL":
            return Optional.ofNullable(clazz.cast(objectACLAsString()));
        case "ReadOnly":
            return Optional.ofNullable(clazz.cast(readOnly()));
        case "GuessMIMETypeEnabled":
            return Optional.ofNullable(clazz.cast(guessMIMETypeEnabled()));
        case "RequesterPays":
            return Optional.ofNullable(clazz.cast(requesterPays()));
        case "SMBACLEnabled":
            return Optional.ofNullable(clazz.cast(smbaclEnabled()));
        case "AccessBasedEnumeration":
            return Optional.ofNullable(clazz.cast(accessBasedEnumeration()));
        case "AdminUserList":
            return Optional.ofNullable(clazz.cast(adminUserList()));
        case "ValidUserList":
            return Optional.ofNullable(clazz.cast(validUserList()));
        case "InvalidUserList":
            return Optional.ofNullable(clazz.cast(invalidUserList()));
        case "AuditDestinationARN":
            return Optional.ofNullable(clazz.cast(auditDestinationARN()));
        case "CaseSensitivity":
            return Optional.ofNullable(clazz.cast(caseSensitivityAsString()));
        case "FileShareName":
            return Optional.ofNullable(clazz.cast(fileShareName()));
        case "CacheAttributes":
            return Optional.ofNullable(clazz.cast(cacheAttributes()));
        case "NotificationPolicy":
            return Optional.ofNullable(clazz.cast(notificationPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSmbFileShareRequest, T> g) {
        return obj -> g.apply((UpdateSmbFileShareRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateSmbFileShareRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the SMB file share that you want to update.
         * </p>
         * 
         * @param fileShareARN
         *        The Amazon Resource Name (ARN) of the SMB file share that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileShareARN(String fileShareARN);

        /**
         * <p>
         * Set to <code>true</code> to use Amazon S3 server-side encryption with your own AWS KMS key, or
         * <code>false</code> to use a key managed by Amazon S3. Optional.
         * </p>
         * <p>
         * Valid Values: <code>true</code> | <code>false</code>
         * </p>
         * 
         * @param kmsEncrypted
         *        Set to <code>true</code> to use Amazon S3 server-side encryption with your own AWS KMS key, or
         *        <code>false</code> to use a key managed by Amazon S3. Optional.</p>
         *        <p>
         *        Valid Values: <code>true</code> | <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsEncrypted(Boolean kmsEncrypted);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side
         * encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when
         * <code>KMSEncrypted</code> is <code>true</code>. Optional.
         * </p>
         * 
         * @param kmsKey
         *        The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side
         *        encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when
         *        <code>KMSEncrypted</code> is <code>true</code>. Optional.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKey(String kmsKey);

        /**
         * <p>
         * The default storage class for objects put into an Amazon S3 bucket by the file gateway. The default value is
         * <code>S3_INTELLIGENT_TIERING</code>. Optional.
         * </p>
         * <p>
         * Valid Values: <code>S3_STANDARD</code> | <code>S3_INTELLIGENT_TIERING</code> | <code>S3_STANDARD_IA</code> |
         * <code>S3_ONEZONE_IA</code>
         * </p>
         * 
         * @param defaultStorageClass
         *        The default storage class for objects put into an Amazon S3 bucket by the file gateway. The default
         *        value is <code>S3_INTELLIGENT_TIERING</code>. Optional.</p>
         *        <p>
         *        Valid Values: <code>S3_STANDARD</code> | <code>S3_INTELLIGENT_TIERING</code> |
         *        <code>S3_STANDARD_IA</code> | <code>S3_ONEZONE_IA</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultStorageClass(String defaultStorageClass);

        /**
         * <p>
         * A value that sets the access control list (ACL) permission for objects in the S3 bucket that a file gateway
         * puts objects into. The default value is <code>private</code>.
         * </p>
         * 
         * @param objectACL
         *        A value that sets the access control list (ACL) permission for objects in the S3 bucket that a file
         *        gateway puts objects into. The default value is <code>private</code>.
         * @see ObjectACL
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ObjectACL
         */
        Builder objectACL(String objectACL);

        /**
         * <p>
         * A value that sets the access control list (ACL) permission for objects in the S3 bucket that a file gateway
         * puts objects into. The default value is <code>private</code>.
         * </p>
         * 
         * @param objectACL
         *        A value that sets the access control list (ACL) permission for objects in the S3 bucket that a file
         *        gateway puts objects into. The default value is <code>private</code>.
         * @see ObjectACL
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ObjectACL
         */
        Builder objectACL(ObjectACL objectACL);

        /**
         * <p>
         * A value that sets the write status of a file share. Set this value to <code>true</code> to set write status
         * to read-only, otherwise set to <code>false</code>.
         * </p>
         * <p>
         * Valid Values: <code>true</code> | <code>false</code>
         * </p>
         * 
         * @param readOnly
         *        A value that sets the write status of a file share. Set this value to <code>true</code> to set write
         *        status to read-only, otherwise set to <code>false</code>.</p>
         *        <p>
         *        Valid Values: <code>true</code> | <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readOnly(Boolean readOnly);

        /**
         * <p>
         * A value that enables guessing of the MIME type for uploaded objects based on file extensions. Set this value
         * to <code>true</code> to enable MIME type guessing, otherwise set to <code>false</code>. The default value is
         * <code>true</code>.
         * </p>
         * <p>
         * Valid Values: <code>true</code> | <code>false</code>
         * </p>
         * 
         * @param guessMIMETypeEnabled
         *        A value that enables guessing of the MIME type for uploaded objects based on file extensions. Set this
         *        value to <code>true</code> to enable MIME type guessing, otherwise set to <code>false</code>. The
         *        default value is <code>true</code>.</p>
         *        <p>
         *        Valid Values: <code>true</code> | <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder guessMIMETypeEnabled(Boolean guessMIMETypeEnabled);

        /**
         * <p>
         * A value that sets who pays the cost of the request and the cost associated with data download from the S3
         * bucket. If this value is set to <code>true</code>, the requester pays the costs; otherwise, the S3 bucket
         * owner pays. However, the S3 bucket owner always pays the cost of storing data.
         * </p>
         * <note>
         * <p>
         * <code>RequesterPays</code> is a configuration for the S3 bucket that backs the file share, so make sure that
         * the configuration on the file share is the same as the S3 bucket configuration.
         * </p>
         * </note>
         * <p>
         * Valid Values: <code>true</code> | <code>false</code>
         * </p>
         * 
         * @param requesterPays
         *        A value that sets who pays the cost of the request and the cost associated with data download from the
         *        S3 bucket. If this value is set to <code>true</code>, the requester pays the costs; otherwise, the S3
         *        bucket owner pays. However, the S3 bucket owner always pays the cost of storing data.</p> <note>
         *        <p>
         *        <code>RequesterPays</code> is a configuration for the S3 bucket that backs the file share, so make
         *        sure that the configuration on the file share is the same as the S3 bucket configuration.
         *        </p>
         *        </note>
         *        <p>
         *        Valid Values: <code>true</code> | <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requesterPays(Boolean requesterPays);

        /**
         * <p>
         * Set this value to <code>true</code> to enable access control list (ACL) on the SMB file share. Set it to
         * <code>false</code> to map file and directory permissions to the POSIX permissions.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/storagegateway/latest/userguide/smb-acl.html">Using Microsoft Windows ACLs
         * to control access to an SMB file share</a> in the <i>AWS Storage Gateway User Guide</i>.
         * </p>
         * <p>
         * Valid Values: <code>true</code> | <code>false</code>
         * </p>
         * 
         * @param smbaclEnabled
         *        Set this value to <code>true</code> to enable access control list (ACL) on the SMB file share. Set it
         *        to <code>false</code> to map file and directory permissions to the POSIX permissions.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/storagegateway/latest/userguide/smb-acl.html">Using Microsoft
         *        Windows ACLs to control access to an SMB file share</a> in the <i>AWS Storage Gateway User Guide</i>.
         *        </p>
         *        <p>
         *        Valid Values: <code>true</code> | <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smbaclEnabled(Boolean smbaclEnabled);

        /**
         * <p>
         * The files and folders on this share will only be visible to users with read access.
         * </p>
         * 
         * @param accessBasedEnumeration
         *        The files and folders on this share will only be visible to users with read access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessBasedEnumeration(Boolean accessBasedEnumeration);

        /**
         * <p>
         * A list of users or groups in the Active Directory that have administrator rights to the file share. A group
         * must be prefixed with the @ character. Acceptable formats include: <code>DOMAIN\User1</code>,
         * <code>user1</code>, <code>@group1</code>, and <code>@DOMAIN\group1</code>. Can only be set if Authentication
         * is set to <code>ActiveDirectory</code>.
         * </p>
         * 
         * @param adminUserList
         *        A list of users or groups in the Active Directory that have administrator rights to the file share. A
         *        group must be prefixed with the @ character. Acceptable formats include: <code>DOMAIN\User1</code>,
         *        <code>user1</code>, <code>@group1</code>, and <code>@DOMAIN\group1</code>. Can only be set if
         *        Authentication is set to <code>ActiveDirectory</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adminUserList(Collection<String> adminUserList);

        /**
         * <p>
         * A list of users or groups in the Active Directory that have administrator rights to the file share. A group
         * must be prefixed with the @ character. Acceptable formats include: <code>DOMAIN\User1</code>,
         * <code>user1</code>, <code>@group1</code>, and <code>@DOMAIN\group1</code>. Can only be set if Authentication
         * is set to <code>ActiveDirectory</code>.
         * </p>
         * 
         * @param adminUserList
         *        A list of users or groups in the Active Directory that have administrator rights to the file share. A
         *        group must be prefixed with the @ character. Acceptable formats include: <code>DOMAIN\User1</code>,
         *        <code>user1</code>, <code>@group1</code>, and <code>@DOMAIN\group1</code>. Can only be set if
         *        Authentication is set to <code>ActiveDirectory</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adminUserList(String... adminUserList);

        /**
         * <p>
         * A list of users or groups in the Active Directory that are allowed to access the file share. A group must be
         * prefixed with the @ character. Acceptable formats include: <code>DOMAIN\User1</code>, <code>user1</code>,
         * <code>@group1</code>, and <code>@DOMAIN\group1</code>. Can only be set if Authentication is set to
         * <code>ActiveDirectory</code>.
         * </p>
         * 
         * @param validUserList
         *        A list of users or groups in the Active Directory that are allowed to access the file share. A group
         *        must be prefixed with the @ character. Acceptable formats include: <code>DOMAIN\User1</code>,
         *        <code>user1</code>, <code>@group1</code>, and <code>@DOMAIN\group1</code>. Can only be set if
         *        Authentication is set to <code>ActiveDirectory</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validUserList(Collection<String> validUserList);

        /**
         * <p>
         * A list of users or groups in the Active Directory that are allowed to access the file share. A group must be
         * prefixed with the @ character. Acceptable formats include: <code>DOMAIN\User1</code>, <code>user1</code>,
         * <code>@group1</code>, and <code>@DOMAIN\group1</code>. Can only be set if Authentication is set to
         * <code>ActiveDirectory</code>.
         * </p>
         * 
         * @param validUserList
         *        A list of users or groups in the Active Directory that are allowed to access the file share. A group
         *        must be prefixed with the @ character. Acceptable formats include: <code>DOMAIN\User1</code>,
         *        <code>user1</code>, <code>@group1</code>, and <code>@DOMAIN\group1</code>. Can only be set if
         *        Authentication is set to <code>ActiveDirectory</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validUserList(String... validUserList);

        /**
         * <p>
         * A list of users or groups in the Active Directory that are not allowed to access the file share. A group must
         * be prefixed with the @ character. Acceptable formats include: <code>DOMAIN\User1</code>, <code>user1</code>,
         * <code>@group1</code>, and <code>@DOMAIN\group1</code>. Can only be set if Authentication is set to
         * <code>ActiveDirectory</code>.
         * </p>
         * 
         * @param invalidUserList
         *        A list of users or groups in the Active Directory that are not allowed to access the file share. A
         *        group must be prefixed with the @ character. Acceptable formats include: <code>DOMAIN\User1</code>,
         *        <code>user1</code>, <code>@group1</code>, and <code>@DOMAIN\group1</code>. Can only be set if
         *        Authentication is set to <code>ActiveDirectory</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invalidUserList(Collection<String> invalidUserList);

        /**
         * <p>
         * A list of users or groups in the Active Directory that are not allowed to access the file share. A group must
         * be prefixed with the @ character. Acceptable formats include: <code>DOMAIN\User1</code>, <code>user1</code>,
         * <code>@group1</code>, and <code>@DOMAIN\group1</code>. Can only be set if Authentication is set to
         * <code>ActiveDirectory</code>.
         * </p>
         * 
         * @param invalidUserList
         *        A list of users or groups in the Active Directory that are not allowed to access the file share. A
         *        group must be prefixed with the @ character. Acceptable formats include: <code>DOMAIN\User1</code>,
         *        <code>user1</code>, <code>@group1</code>, and <code>@DOMAIN\group1</code>. Can only be set if
         *        Authentication is set to <code>ActiveDirectory</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invalidUserList(String... invalidUserList);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the storage used for audit logs.
         * </p>
         * 
         * @param auditDestinationARN
         *        The Amazon Resource Name (ARN) of the storage used for audit logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auditDestinationARN(String auditDestinationARN);

        /**
         * <p>
         * The case of an object name in an Amazon S3 bucket. For <code>ClientSpecified</code>, the client determines
         * the case sensitivity. For <code>CaseSensitive</code>, the gateway determines the case sensitivity. The
         * default value is <code>ClientSpecified</code>.
         * </p>
         * 
         * @param caseSensitivity
         *        The case of an object name in an Amazon S3 bucket. For <code>ClientSpecified</code>, the client
         *        determines the case sensitivity. For <code>CaseSensitive</code>, the gateway determines the case
         *        sensitivity. The default value is <code>ClientSpecified</code>.
         * @see CaseSensitivity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CaseSensitivity
         */
        Builder caseSensitivity(String caseSensitivity);

        /**
         * <p>
         * The case of an object name in an Amazon S3 bucket. For <code>ClientSpecified</code>, the client determines
         * the case sensitivity. For <code>CaseSensitive</code>, the gateway determines the case sensitivity. The
         * default value is <code>ClientSpecified</code>.
         * </p>
         * 
         * @param caseSensitivity
         *        The case of an object name in an Amazon S3 bucket. For <code>ClientSpecified</code>, the client
         *        determines the case sensitivity. For <code>CaseSensitive</code>, the gateway determines the case
         *        sensitivity. The default value is <code>ClientSpecified</code>.
         * @see CaseSensitivity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CaseSensitivity
         */
        Builder caseSensitivity(CaseSensitivity caseSensitivity);

        /**
         * <p>
         * The name of the file share. Optional.
         * </p>
         * <note>
         * <p>
         * <code>FileShareName</code> must be set if an S3 prefix name is set in <code>LocationARN</code>.
         * </p>
         * </note>
         * 
         * @param fileShareName
         *        The name of the file share. Optional.</p> <note>
         *        <p>
         *        <code>FileShareName</code> must be set if an S3 prefix name is set in <code>LocationARN</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileShareName(String fileShareName);

        /**
         * <p>
         * Specifies refresh cache information for the file share.
         * </p>
         * 
         * @param cacheAttributes
         *        Specifies refresh cache information for the file share.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheAttributes(CacheAttributes cacheAttributes);

        /**
         * <p>
         * Specifies refresh cache information for the file share.
         * </p>
         * This is a convenience that creates an instance of the {@link CacheAttributes.Builder} avoiding the need to
         * create one manually via {@link CacheAttributes#builder()}.
         *
         * When the {@link Consumer} completes, {@link CacheAttributes.Builder#build()} is called immediately and its
         * result is passed to {@link #cacheAttributes(CacheAttributes)}.
         * 
         * @param cacheAttributes
         *        a consumer that will call methods on {@link CacheAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cacheAttributes(CacheAttributes)
         */
        default Builder cacheAttributes(Consumer<CacheAttributes.Builder> cacheAttributes) {
            return cacheAttributes(CacheAttributes.builder().applyMutation(cacheAttributes).build());
        }

        /**
         * <p>
         * The notification policy of the file share. <code>SettlingTimeInSeconds</code> controls the number of seconds
         * to wait after the last point in time a client wrote to a file before generating an
         * <code>ObjectUploaded</code> notification. Because clients can make many small writes to files, it's best to
         * set this parameter for as long as possible to avoid generating multiple notifications for the same file in a
         * small time period.
         * </p>
         * <note>
         * <p>
         * <code>SettlingTimeInSeconds</code> has no effect on the timing of the object uploading to Amazon S3, only the
         * timing of the notification.
         * </p>
         * </note>
         * <p>
         * The following example sets <code>NotificationPolicy</code> on with <code>SettlingTimeInSeconds</code> set to
         * 60.
         * </p>
         * <p>
         * <code>{\"Upload\": {\"SettlingTimeInSeconds\": 60}}</code>
         * </p>
         * <p>
         * The following example sets <code>NotificationPolicy</code> off.
         * </p>
         * <p>
         * <code>{}</code>
         * </p>
         * 
         * @param notificationPolicy
         *        The notification policy of the file share. <code>SettlingTimeInSeconds</code> controls the number of
         *        seconds to wait after the last point in time a client wrote to a file before generating an
         *        <code>ObjectUploaded</code> notification. Because clients can make many small writes to files, it's
         *        best to set this parameter for as long as possible to avoid generating multiple notifications for the
         *        same file in a small time period.</p> <note>
         *        <p>
         *        <code>SettlingTimeInSeconds</code> has no effect on the timing of the object uploading to Amazon S3,
         *        only the timing of the notification.
         *        </p>
         *        </note>
         *        <p>
         *        The following example sets <code>NotificationPolicy</code> on with <code>SettlingTimeInSeconds</code>
         *        set to 60.
         *        </p>
         *        <p>
         *        <code>{\"Upload\": {\"SettlingTimeInSeconds\": 60}}</code>
         *        </p>
         *        <p>
         *        The following example sets <code>NotificationPolicy</code> off.
         *        </p>
         *        <p>
         *        <code>{}</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationPolicy(String notificationPolicy);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends StorageGatewayRequest.BuilderImpl implements Builder {
        private String fileShareARN;

        private Boolean kmsEncrypted;

        private String kmsKey;

        private String defaultStorageClass;

        private String objectACL;

        private Boolean readOnly;

        private Boolean guessMIMETypeEnabled;

        private Boolean requesterPays;

        private Boolean smbaclEnabled;

        private Boolean accessBasedEnumeration;

        private List<String> adminUserList = DefaultSdkAutoConstructList.getInstance();

        private List<String> validUserList = DefaultSdkAutoConstructList.getInstance();

        private List<String> invalidUserList = DefaultSdkAutoConstructList.getInstance();

        private String auditDestinationARN;

        private String caseSensitivity;

        private String fileShareName;

        private CacheAttributes cacheAttributes;

        private String notificationPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSmbFileShareRequest model) {
            super(model);
            fileShareARN(model.fileShareARN);
            kmsEncrypted(model.kmsEncrypted);
            kmsKey(model.kmsKey);
            defaultStorageClass(model.defaultStorageClass);
            objectACL(model.objectACL);
            readOnly(model.readOnly);
            guessMIMETypeEnabled(model.guessMIMETypeEnabled);
            requesterPays(model.requesterPays);
            smbaclEnabled(model.smbaclEnabled);
            accessBasedEnumeration(model.accessBasedEnumeration);
            adminUserList(model.adminUserList);
            validUserList(model.validUserList);
            invalidUserList(model.invalidUserList);
            auditDestinationARN(model.auditDestinationARN);
            caseSensitivity(model.caseSensitivity);
            fileShareName(model.fileShareName);
            cacheAttributes(model.cacheAttributes);
            notificationPolicy(model.notificationPolicy);
        }

        public final String getFileShareARN() {
            return fileShareARN;
        }

        @Override
        public final Builder fileShareARN(String fileShareARN) {
            this.fileShareARN = fileShareARN;
            return this;
        }

        public final void setFileShareARN(String fileShareARN) {
            this.fileShareARN = fileShareARN;
        }

        public final Boolean getKmsEncrypted() {
            return kmsEncrypted;
        }

        @Override
        public final Builder kmsEncrypted(Boolean kmsEncrypted) {
            this.kmsEncrypted = kmsEncrypted;
            return this;
        }

        public final void setKmsEncrypted(Boolean kmsEncrypted) {
            this.kmsEncrypted = kmsEncrypted;
        }

        public final String getKmsKey() {
            return kmsKey;
        }

        @Override
        public final Builder kmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        public final void setKmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
        }

        public final String getDefaultStorageClass() {
            return defaultStorageClass;
        }

        @Override
        public final Builder defaultStorageClass(String defaultStorageClass) {
            this.defaultStorageClass = defaultStorageClass;
            return this;
        }

        public final void setDefaultStorageClass(String defaultStorageClass) {
            this.defaultStorageClass = defaultStorageClass;
        }

        public final String getObjectACL() {
            return objectACL;
        }

        @Override
        public final Builder objectACL(String objectACL) {
            this.objectACL = objectACL;
            return this;
        }

        @Override
        public final Builder objectACL(ObjectACL objectACL) {
            this.objectACL(objectACL == null ? null : objectACL.toString());
            return this;
        }

        public final void setObjectACL(String objectACL) {
            this.objectACL = objectACL;
        }

        public final Boolean getReadOnly() {
            return readOnly;
        }

        @Override
        public final Builder readOnly(Boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        public final void setReadOnly(Boolean readOnly) {
            this.readOnly = readOnly;
        }

        public final Boolean getGuessMIMETypeEnabled() {
            return guessMIMETypeEnabled;
        }

        @Override
        public final Builder guessMIMETypeEnabled(Boolean guessMIMETypeEnabled) {
            this.guessMIMETypeEnabled = guessMIMETypeEnabled;
            return this;
        }

        public final void setGuessMIMETypeEnabled(Boolean guessMIMETypeEnabled) {
            this.guessMIMETypeEnabled = guessMIMETypeEnabled;
        }

        public final Boolean getRequesterPays() {
            return requesterPays;
        }

        @Override
        public final Builder requesterPays(Boolean requesterPays) {
            this.requesterPays = requesterPays;
            return this;
        }

        public final void setRequesterPays(Boolean requesterPays) {
            this.requesterPays = requesterPays;
        }

        public final Boolean getSmbaclEnabled() {
            return smbaclEnabled;
        }

        @Override
        public final Builder smbaclEnabled(Boolean smbaclEnabled) {
            this.smbaclEnabled = smbaclEnabled;
            return this;
        }

        public final void setSmbaclEnabled(Boolean smbaclEnabled) {
            this.smbaclEnabled = smbaclEnabled;
        }

        public final Boolean getAccessBasedEnumeration() {
            return accessBasedEnumeration;
        }

        @Override
        public final Builder accessBasedEnumeration(Boolean accessBasedEnumeration) {
            this.accessBasedEnumeration = accessBasedEnumeration;
            return this;
        }

        public final void setAccessBasedEnumeration(Boolean accessBasedEnumeration) {
            this.accessBasedEnumeration = accessBasedEnumeration;
        }

        public final Collection<String> getAdminUserList() {
            if (adminUserList instanceof SdkAutoConstructList) {
                return null;
            }
            return adminUserList;
        }

        @Override
        public final Builder adminUserList(Collection<String> adminUserList) {
            this.adminUserList = UserListCopier.copy(adminUserList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adminUserList(String... adminUserList) {
            adminUserList(Arrays.asList(adminUserList));
            return this;
        }

        public final void setAdminUserList(Collection<String> adminUserList) {
            this.adminUserList = UserListCopier.copy(adminUserList);
        }

        public final Collection<String> getValidUserList() {
            if (validUserList instanceof SdkAutoConstructList) {
                return null;
            }
            return validUserList;
        }

        @Override
        public final Builder validUserList(Collection<String> validUserList) {
            this.validUserList = UserListCopier.copy(validUserList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validUserList(String... validUserList) {
            validUserList(Arrays.asList(validUserList));
            return this;
        }

        public final void setValidUserList(Collection<String> validUserList) {
            this.validUserList = UserListCopier.copy(validUserList);
        }

        public final Collection<String> getInvalidUserList() {
            if (invalidUserList instanceof SdkAutoConstructList) {
                return null;
            }
            return invalidUserList;
        }

        @Override
        public final Builder invalidUserList(Collection<String> invalidUserList) {
            this.invalidUserList = UserListCopier.copy(invalidUserList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invalidUserList(String... invalidUserList) {
            invalidUserList(Arrays.asList(invalidUserList));
            return this;
        }

        public final void setInvalidUserList(Collection<String> invalidUserList) {
            this.invalidUserList = UserListCopier.copy(invalidUserList);
        }

        public final String getAuditDestinationARN() {
            return auditDestinationARN;
        }

        @Override
        public final Builder auditDestinationARN(String auditDestinationARN) {
            this.auditDestinationARN = auditDestinationARN;
            return this;
        }

        public final void setAuditDestinationARN(String auditDestinationARN) {
            this.auditDestinationARN = auditDestinationARN;
        }

        public final String getCaseSensitivity() {
            return caseSensitivity;
        }

        @Override
        public final Builder caseSensitivity(String caseSensitivity) {
            this.caseSensitivity = caseSensitivity;
            return this;
        }

        @Override
        public final Builder caseSensitivity(CaseSensitivity caseSensitivity) {
            this.caseSensitivity(caseSensitivity == null ? null : caseSensitivity.toString());
            return this;
        }

        public final void setCaseSensitivity(String caseSensitivity) {
            this.caseSensitivity = caseSensitivity;
        }

        public final String getFileShareName() {
            return fileShareName;
        }

        @Override
        public final Builder fileShareName(String fileShareName) {
            this.fileShareName = fileShareName;
            return this;
        }

        public final void setFileShareName(String fileShareName) {
            this.fileShareName = fileShareName;
        }

        public final CacheAttributes.Builder getCacheAttributes() {
            return cacheAttributes != null ? cacheAttributes.toBuilder() : null;
        }

        @Override
        public final Builder cacheAttributes(CacheAttributes cacheAttributes) {
            this.cacheAttributes = cacheAttributes;
            return this;
        }

        public final void setCacheAttributes(CacheAttributes.BuilderImpl cacheAttributes) {
            this.cacheAttributes = cacheAttributes != null ? cacheAttributes.build() : null;
        }

        public final String getNotificationPolicy() {
            return notificationPolicy;
        }

        @Override
        public final Builder notificationPolicy(String notificationPolicy) {
            this.notificationPolicy = notificationPolicy;
            return this;
        }

        public final void setNotificationPolicy(String notificationPolicy) {
            this.notificationPolicy = notificationPolicy;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSmbFileShareRequest build() {
            return new UpdateSmbFileShareRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
