/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFileSystemAssociationsResponse extends StorageGatewayResponse implements
        ToCopyableBuilder<ListFileSystemAssociationsResponse.Builder, ListFileSystemAssociationsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(ListFileSystemAssociationsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextMarker").getter(getter(ListFileSystemAssociationsResponse::nextMarker))
            .setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()).build();

    private static final SdkField<List<FileSystemAssociationSummary>> FILE_SYSTEM_ASSOCIATION_SUMMARY_LIST_FIELD = SdkField
            .<List<FileSystemAssociationSummary>> builder(MarshallingType.LIST)
            .memberName("FileSystemAssociationSummaryList")
            .getter(getter(ListFileSystemAssociationsResponse::fileSystemAssociationSummaryList))
            .setter(setter(Builder::fileSystemAssociationSummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemAssociationSummaryList")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FileSystemAssociationSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(FileSystemAssociationSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD,
            NEXT_MARKER_FIELD, FILE_SYSTEM_ASSOCIATION_SUMMARY_LIST_FIELD));

    private final String marker;

    private final String nextMarker;

    private final List<FileSystemAssociationSummary> fileSystemAssociationSummaryList;

    private ListFileSystemAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.nextMarker = builder.nextMarker;
        this.fileSystemAssociationSummaryList = builder.fileSystemAssociationSummaryList;
    }

    /**
     * <p>
     * If the request includes <code>Marker</code>, the response returns that value in this field.
     * </p>
     * 
     * @return If the request includes <code>Marker</code>, the response returns that value in this field.
     */
    public final String marker() {
        return marker;
    }

    /**
     * <p>
     * If a value is present, there are more file system associations to return. In a subsequent request, use
     * <code>NextMarker</code> as the value for <code>Marker</code> to retrieve the next set of file system
     * associations.
     * </p>
     * 
     * @return If a value is present, there are more file system associations to return. In a subsequent request, use
     *         <code>NextMarker</code> as the value for <code>Marker</code> to retrieve the next set of file system
     *         associations.
     */
    public final String nextMarker() {
        return nextMarker;
    }

    /**
     * Returns true if the FileSystemAssociationSummaryList property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public final boolean hasFileSystemAssociationSummaryList() {
        return fileSystemAssociationSummaryList != null && !(fileSystemAssociationSummaryList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of information about the Amazon FSx gateway's file system associations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFileSystemAssociationSummaryList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of information about the Amazon FSx gateway's file system associations.
     */
    public final List<FileSystemAssociationSummary> fileSystemAssociationSummaryList() {
        return fileSystemAssociationSummaryList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasFileSystemAssociationSummaryList() ? fileSystemAssociationSummaryList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFileSystemAssociationsResponse)) {
            return false;
        }
        ListFileSystemAssociationsResponse other = (ListFileSystemAssociationsResponse) obj;
        return Objects.equals(marker(), other.marker()) && Objects.equals(nextMarker(), other.nextMarker())
                && hasFileSystemAssociationSummaryList() == other.hasFileSystemAssociationSummaryList()
                && Objects.equals(fileSystemAssociationSummaryList(), other.fileSystemAssociationSummaryList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListFileSystemAssociationsResponse")
                .add("Marker", marker())
                .add("NextMarker", nextMarker())
                .add("FileSystemAssociationSummaryList",
                        hasFileSystemAssociationSummaryList() ? fileSystemAssociationSummaryList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "NextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        case "FileSystemAssociationSummaryList":
            return Optional.ofNullable(clazz.cast(fileSystemAssociationSummaryList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFileSystemAssociationsResponse, T> g) {
        return obj -> g.apply((ListFileSystemAssociationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListFileSystemAssociationsResponse> {
        /**
         * <p>
         * If the request includes <code>Marker</code>, the response returns that value in this field.
         * </p>
         * 
         * @param marker
         *        If the request includes <code>Marker</code>, the response returns that value in this field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * If a value is present, there are more file system associations to return. In a subsequent request, use
         * <code>NextMarker</code> as the value for <code>Marker</code> to retrieve the next set of file system
         * associations.
         * </p>
         * 
         * @param nextMarker
         *        If a value is present, there are more file system associations to return. In a subsequent request, use
         *        <code>NextMarker</code> as the value for <code>Marker</code> to retrieve the next set of file system
         *        associations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);

        /**
         * <p>
         * An array of information about the Amazon FSx gateway's file system associations.
         * </p>
         * 
         * @param fileSystemAssociationSummaryList
         *        An array of information about the Amazon FSx gateway's file system associations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemAssociationSummaryList(Collection<FileSystemAssociationSummary> fileSystemAssociationSummaryList);

        /**
         * <p>
         * An array of information about the Amazon FSx gateway's file system associations.
         * </p>
         * 
         * @param fileSystemAssociationSummaryList
         *        An array of information about the Amazon FSx gateway's file system associations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemAssociationSummaryList(FileSystemAssociationSummary... fileSystemAssociationSummaryList);

        /**
         * <p>
         * An array of information about the Amazon FSx gateway's file system associations.
         * </p>
         * This is a convenience that creates an instance of the {@link List<FileSystemAssociationSummary>.Builder}
         * avoiding the need to create one manually via {@link List<FileSystemAssociationSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FileSystemAssociationSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #fileSystemAssociationSummaryList(List<FileSystemAssociationSummary>)}.
         * 
         * @param fileSystemAssociationSummaryList
         *        a consumer that will call methods on {@link List<FileSystemAssociationSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fileSystemAssociationSummaryList(List<FileSystemAssociationSummary>)
         */
        Builder fileSystemAssociationSummaryList(
                Consumer<FileSystemAssociationSummary.Builder>... fileSystemAssociationSummaryList);
    }

    static final class BuilderImpl extends StorageGatewayResponse.BuilderImpl implements Builder {
        private String marker;

        private String nextMarker;

        private List<FileSystemAssociationSummary> fileSystemAssociationSummaryList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListFileSystemAssociationsResponse model) {
            super(model);
            marker(model.marker);
            nextMarker(model.nextMarker);
            fileSystemAssociationSummaryList(model.fileSystemAssociationSummaryList);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final List<FileSystemAssociationSummary.Builder> getFileSystemAssociationSummaryList() {
            List<FileSystemAssociationSummary.Builder> result = FileSystemAssociationSummaryListCopier
                    .copyToBuilder(this.fileSystemAssociationSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder fileSystemAssociationSummaryList(
                Collection<FileSystemAssociationSummary> fileSystemAssociationSummaryList) {
            this.fileSystemAssociationSummaryList = FileSystemAssociationSummaryListCopier.copy(fileSystemAssociationSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileSystemAssociationSummaryList(FileSystemAssociationSummary... fileSystemAssociationSummaryList) {
            fileSystemAssociationSummaryList(Arrays.asList(fileSystemAssociationSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileSystemAssociationSummaryList(
                Consumer<FileSystemAssociationSummary.Builder>... fileSystemAssociationSummaryList) {
            fileSystemAssociationSummaryList(Stream.of(fileSystemAssociationSummaryList)
                    .map(c -> FileSystemAssociationSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFileSystemAssociationSummaryList(
                Collection<FileSystemAssociationSummary.BuilderImpl> fileSystemAssociationSummaryList) {
            this.fileSystemAssociationSummaryList = FileSystemAssociationSummaryListCopier
                    .copyFromBuilder(fileSystemAssociationSummaryList);
        }

        @Override
        public ListFileSystemAssociationsResponse build() {
            return new ListFileSystemAssociationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
