/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisassociateFileSystemRequest extends StorageGatewayRequest implements
        ToCopyableBuilder<DisassociateFileSystemRequest.Builder, DisassociateFileSystemRequest> {
    private static final SdkField<String> FILE_SYSTEM_ASSOCIATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileSystemAssociationARN").getter(getter(DisassociateFileSystemRequest::fileSystemAssociationARN))
            .setter(setter(Builder::fileSystemAssociationARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemAssociationARN").build())
            .build();

    private static final SdkField<Boolean> FORCE_DELETE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ForceDelete").getter(getter(DisassociateFileSystemRequest::forceDelete))
            .setter(setter(Builder::forceDelete))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForceDelete").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            FILE_SYSTEM_ASSOCIATION_ARN_FIELD, FORCE_DELETE_FIELD));

    private final String fileSystemAssociationARN;

    private final Boolean forceDelete;

    private DisassociateFileSystemRequest(BuilderImpl builder) {
        super(builder);
        this.fileSystemAssociationARN = builder.fileSystemAssociationARN;
        this.forceDelete = builder.forceDelete;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the file system association to be deleted.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the file system association to be deleted.
     */
    public final String fileSystemAssociationARN() {
        return fileSystemAssociationARN;
    }

    /**
     * <p>
     * If this value is set to true, the operation disassociates an Amazon FSx file system immediately. It ends all data
     * uploads to the file system, and the file system association enters the <code>FORCE_DELETING</code> status. If
     * this value is set to false, the Amazon FSx file system does not disassociate until all data is uploaded.
     * </p>
     * 
     * @return If this value is set to true, the operation disassociates an Amazon FSx file system immediately. It ends
     *         all data uploads to the file system, and the file system association enters the
     *         <code>FORCE_DELETING</code> status. If this value is set to false, the Amazon FSx file system does not
     *         disassociate until all data is uploaded.
     */
    public final Boolean forceDelete() {
        return forceDelete;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fileSystemAssociationARN());
        hashCode = 31 * hashCode + Objects.hashCode(forceDelete());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateFileSystemRequest)) {
            return false;
        }
        DisassociateFileSystemRequest other = (DisassociateFileSystemRequest) obj;
        return Objects.equals(fileSystemAssociationARN(), other.fileSystemAssociationARN())
                && Objects.equals(forceDelete(), other.forceDelete());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisassociateFileSystemRequest").add("FileSystemAssociationARN", fileSystemAssociationARN())
                .add("ForceDelete", forceDelete()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FileSystemAssociationARN":
            return Optional.ofNullable(clazz.cast(fileSystemAssociationARN()));
        case "ForceDelete":
            return Optional.ofNullable(clazz.cast(forceDelete()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisassociateFileSystemRequest, T> g) {
        return obj -> g.apply((DisassociateFileSystemRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DisassociateFileSystemRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the file system association to be deleted.
         * </p>
         * 
         * @param fileSystemAssociationARN
         *        The Amazon Resource Name (ARN) of the file system association to be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemAssociationARN(String fileSystemAssociationARN);

        /**
         * <p>
         * If this value is set to true, the operation disassociates an Amazon FSx file system immediately. It ends all
         * data uploads to the file system, and the file system association enters the <code>FORCE_DELETING</code>
         * status. If this value is set to false, the Amazon FSx file system does not disassociate until all data is
         * uploaded.
         * </p>
         * 
         * @param forceDelete
         *        If this value is set to true, the operation disassociates an Amazon FSx file system immediately. It
         *        ends all data uploads to the file system, and the file system association enters the
         *        <code>FORCE_DELETING</code> status. If this value is set to false, the Amazon FSx file system does not
         *        disassociate until all data is uploaded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forceDelete(Boolean forceDelete);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends StorageGatewayRequest.BuilderImpl implements Builder {
        private String fileSystemAssociationARN;

        private Boolean forceDelete;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateFileSystemRequest model) {
            super(model);
            fileSystemAssociationARN(model.fileSystemAssociationARN);
            forceDelete(model.forceDelete);
        }

        public final String getFileSystemAssociationARN() {
            return fileSystemAssociationARN;
        }

        @Override
        public final Builder fileSystemAssociationARN(String fileSystemAssociationARN) {
            this.fileSystemAssociationARN = fileSystemAssociationARN;
            return this;
        }

        public final void setFileSystemAssociationARN(String fileSystemAssociationARN) {
            this.fileSystemAssociationARN = fileSystemAssociationARN;
        }

        public final Boolean getForceDelete() {
            return forceDelete;
        }

        @Override
        public final Builder forceDelete(Boolean forceDelete) {
            this.forceDelete = forceDelete;
            return this;
        }

        public final void setForceDelete(Boolean forceDelete) {
            this.forceDelete = forceDelete;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisassociateFileSystemRequest build() {
            return new DisassociateFileSystemRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
