/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A JSON object containing the following fields:
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeWorkingStorageResponse extends StorageGatewayResponse implements
        ToCopyableBuilder<DescribeWorkingStorageResponse.Builder, DescribeWorkingStorageResponse> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayARN").getter(getter(DescribeWorkingStorageResponse::gatewayARN))
            .setter(setter(Builder::gatewayARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()).build();

    private static final SdkField<List<String>> DISK_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DiskIds")
            .getter(getter(DescribeWorkingStorageResponse::diskIds))
            .setter(setter(Builder::diskIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiskIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Long> WORKING_STORAGE_USED_IN_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("WorkingStorageUsedInBytes").getter(getter(DescribeWorkingStorageResponse::workingStorageUsedInBytes))
            .setter(setter(Builder::workingStorageUsedInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkingStorageUsedInBytes").build())
            .build();

    private static final SdkField<Long> WORKING_STORAGE_ALLOCATED_IN_BYTES_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("WorkingStorageAllocatedInBytes")
            .getter(getter(DescribeWorkingStorageResponse::workingStorageAllocatedInBytes))
            .setter(setter(Builder::workingStorageAllocatedInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkingStorageAllocatedInBytes")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD,
            DISK_IDS_FIELD, WORKING_STORAGE_USED_IN_BYTES_FIELD, WORKING_STORAGE_ALLOCATED_IN_BYTES_FIELD));

    private final String gatewayARN;

    private final List<String> diskIds;

    private final Long workingStorageUsedInBytes;

    private final Long workingStorageAllocatedInBytes;

    private DescribeWorkingStorageResponse(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.diskIds = builder.diskIds;
        this.workingStorageUsedInBytes = builder.workingStorageUsedInBytes;
        this.workingStorageAllocatedInBytes = builder.workingStorageAllocatedInBytes;
    }

    /**
     * Returns the value of the GatewayARN property for this object.
     * 
     * @return The value of the GatewayARN property for this object.
     */
    public final String gatewayARN() {
        return gatewayARN;
    }

    /**
     * Returns true if the DiskIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasDiskIds() {
        return diskIds != null && !(diskIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of the gateway's local disk IDs that are configured as working storage. Each local disk ID is specified
     * as a string (minimum length of 1 and maximum length of 300). If no local disks are configured as working storage,
     * then the DiskIds array is empty.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDiskIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of the gateway's local disk IDs that are configured as working storage. Each local disk ID is
     *         specified as a string (minimum length of 1 and maximum length of 300). If no local disks are configured
     *         as working storage, then the DiskIds array is empty.
     */
    public final List<String> diskIds() {
        return diskIds;
    }

    /**
     * <p>
     * The total working storage in bytes in use by the gateway. If no working storage is configured for the gateway,
     * this field returns 0.
     * </p>
     * 
     * @return The total working storage in bytes in use by the gateway. If no working storage is configured for the
     *         gateway, this field returns 0.
     */
    public final Long workingStorageUsedInBytes() {
        return workingStorageUsedInBytes;
    }

    /**
     * <p>
     * The total working storage in bytes allocated for the gateway. If no working storage is configured for the
     * gateway, this field returns 0.
     * </p>
     * 
     * @return The total working storage in bytes allocated for the gateway. If no working storage is configured for the
     *         gateway, this field returns 0.
     */
    public final Long workingStorageAllocatedInBytes() {
        return workingStorageAllocatedInBytes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(hasDiskIds() ? diskIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(workingStorageUsedInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(workingStorageAllocatedInBytes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorkingStorageResponse)) {
            return false;
        }
        DescribeWorkingStorageResponse other = (DescribeWorkingStorageResponse) obj;
        return Objects.equals(gatewayARN(), other.gatewayARN()) && hasDiskIds() == other.hasDiskIds()
                && Objects.equals(diskIds(), other.diskIds())
                && Objects.equals(workingStorageUsedInBytes(), other.workingStorageUsedInBytes())
                && Objects.equals(workingStorageAllocatedInBytes(), other.workingStorageAllocatedInBytes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeWorkingStorageResponse").add("GatewayARN", gatewayARN())
                .add("DiskIds", hasDiskIds() ? diskIds() : null).add("WorkingStorageUsedInBytes", workingStorageUsedInBytes())
                .add("WorkingStorageAllocatedInBytes", workingStorageAllocatedInBytes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GatewayARN":
            return Optional.ofNullable(clazz.cast(gatewayARN()));
        case "DiskIds":
            return Optional.ofNullable(clazz.cast(diskIds()));
        case "WorkingStorageUsedInBytes":
            return Optional.ofNullable(clazz.cast(workingStorageUsedInBytes()));
        case "WorkingStorageAllocatedInBytes":
            return Optional.ofNullable(clazz.cast(workingStorageAllocatedInBytes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeWorkingStorageResponse, T> g) {
        return obj -> g.apply((DescribeWorkingStorageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeWorkingStorageResponse> {
        /**
         * Sets the value of the GatewayARN property for this object.
         *
         * @param gatewayARN
         *        The new value for the GatewayARN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayARN(String gatewayARN);

        /**
         * <p>
         * An array of the gateway's local disk IDs that are configured as working storage. Each local disk ID is
         * specified as a string (minimum length of 1 and maximum length of 300). If no local disks are configured as
         * working storage, then the DiskIds array is empty.
         * </p>
         * 
         * @param diskIds
         *        An array of the gateway's local disk IDs that are configured as working storage. Each local disk ID is
         *        specified as a string (minimum length of 1 and maximum length of 300). If no local disks are
         *        configured as working storage, then the DiskIds array is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskIds(Collection<String> diskIds);

        /**
         * <p>
         * An array of the gateway's local disk IDs that are configured as working storage. Each local disk ID is
         * specified as a string (minimum length of 1 and maximum length of 300). If no local disks are configured as
         * working storage, then the DiskIds array is empty.
         * </p>
         * 
         * @param diskIds
         *        An array of the gateway's local disk IDs that are configured as working storage. Each local disk ID is
         *        specified as a string (minimum length of 1 and maximum length of 300). If no local disks are
         *        configured as working storage, then the DiskIds array is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskIds(String... diskIds);

        /**
         * <p>
         * The total working storage in bytes in use by the gateway. If no working storage is configured for the
         * gateway, this field returns 0.
         * </p>
         * 
         * @param workingStorageUsedInBytes
         *        The total working storage in bytes in use by the gateway. If no working storage is configured for the
         *        gateway, this field returns 0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workingStorageUsedInBytes(Long workingStorageUsedInBytes);

        /**
         * <p>
         * The total working storage in bytes allocated for the gateway. If no working storage is configured for the
         * gateway, this field returns 0.
         * </p>
         * 
         * @param workingStorageAllocatedInBytes
         *        The total working storage in bytes allocated for the gateway. If no working storage is configured for
         *        the gateway, this field returns 0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workingStorageAllocatedInBytes(Long workingStorageAllocatedInBytes);
    }

    static final class BuilderImpl extends StorageGatewayResponse.BuilderImpl implements Builder {
        private String gatewayARN;

        private List<String> diskIds = DefaultSdkAutoConstructList.getInstance();

        private Long workingStorageUsedInBytes;

        private Long workingStorageAllocatedInBytes;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWorkingStorageResponse model) {
            super(model);
            gatewayARN(model.gatewayARN);
            diskIds(model.diskIds);
            workingStorageUsedInBytes(model.workingStorageUsedInBytes);
            workingStorageAllocatedInBytes(model.workingStorageAllocatedInBytes);
        }

        public final String getGatewayARN() {
            return gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        public final Collection<String> getDiskIds() {
            if (diskIds instanceof SdkAutoConstructList) {
                return null;
            }
            return diskIds;
        }

        @Override
        public final Builder diskIds(Collection<String> diskIds) {
            this.diskIds = DiskIdsCopier.copy(diskIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder diskIds(String... diskIds) {
            diskIds(Arrays.asList(diskIds));
            return this;
        }

        public final void setDiskIds(Collection<String> diskIds) {
            this.diskIds = DiskIdsCopier.copy(diskIds);
        }

        public final Long getWorkingStorageUsedInBytes() {
            return workingStorageUsedInBytes;
        }

        @Override
        public final Builder workingStorageUsedInBytes(Long workingStorageUsedInBytes) {
            this.workingStorageUsedInBytes = workingStorageUsedInBytes;
            return this;
        }

        public final void setWorkingStorageUsedInBytes(Long workingStorageUsedInBytes) {
            this.workingStorageUsedInBytes = workingStorageUsedInBytes;
        }

        public final Long getWorkingStorageAllocatedInBytes() {
            return workingStorageAllocatedInBytes;
        }

        @Override
        public final Builder workingStorageAllocatedInBytes(Long workingStorageAllocatedInBytes) {
            this.workingStorageAllocatedInBytes = workingStorageAllocatedInBytes;
            return this;
        }

        public final void setWorkingStorageAllocatedInBytes(Long workingStorageAllocatedInBytes) {
            this.workingStorageAllocatedInBytes = workingStorageAllocatedInBytes;
        }

        @Override
        public DescribeWorkingStorageResponse build() {
            return new DescribeWorkingStorageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
