/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * CreateTapeOutput
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTapesResponse extends StorageGatewayResponse implements
        ToCopyableBuilder<CreateTapesResponse.Builder, CreateTapesResponse> {
    private static final SdkField<List<String>> TAPE_AR_NS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TapeARNs")
            .getter(getter(CreateTapesResponse::tapeARNs))
            .setter(setter(Builder::tapeARNs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeARNs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAPE_AR_NS_FIELD));

    private final List<String> tapeARNs;

    private CreateTapesResponse(BuilderImpl builder) {
        super(builder);
        this.tapeARNs = builder.tapeARNs;
    }

    /**
     * Returns true if the TapeARNs property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTapeARNs() {
        return tapeARNs != null && !(tapeARNs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of unique Amazon Resource Names (ARNs) that represents the virtual tapes that were created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTapeARNs()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of unique Amazon Resource Names (ARNs) that represents the virtual tapes that were created.
     */
    public final List<String> tapeARNs() {
        return tapeARNs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTapeARNs() ? tapeARNs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTapesResponse)) {
            return false;
        }
        CreateTapesResponse other = (CreateTapesResponse) obj;
        return hasTapeARNs() == other.hasTapeARNs() && Objects.equals(tapeARNs(), other.tapeARNs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTapesResponse").add("TapeARNs", hasTapeARNs() ? tapeARNs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TapeARNs":
            return Optional.ofNullable(clazz.cast(tapeARNs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTapesResponse, T> g) {
        return obj -> g.apply((CreateTapesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateTapesResponse> {
        /**
         * <p>
         * A list of unique Amazon Resource Names (ARNs) that represents the virtual tapes that were created.
         * </p>
         * 
         * @param tapeARNs
         *        A list of unique Amazon Resource Names (ARNs) that represents the virtual tapes that were created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tapeARNs(Collection<String> tapeARNs);

        /**
         * <p>
         * A list of unique Amazon Resource Names (ARNs) that represents the virtual tapes that were created.
         * </p>
         * 
         * @param tapeARNs
         *        A list of unique Amazon Resource Names (ARNs) that represents the virtual tapes that were created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tapeARNs(String... tapeARNs);
    }

    static final class BuilderImpl extends StorageGatewayResponse.BuilderImpl implements Builder {
        private List<String> tapeARNs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTapesResponse model) {
            super(model);
            tapeARNs(model.tapeARNs);
        }

        public final Collection<String> getTapeARNs() {
            if (tapeARNs instanceof SdkAutoConstructList) {
                return null;
            }
            return tapeARNs;
        }

        @Override
        public final Builder tapeARNs(Collection<String> tapeARNs) {
            this.tapeARNs = TapeARNsCopier.copy(tapeARNs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tapeARNs(String... tapeARNs) {
            tapeARNs(Arrays.asList(tapeARNs));
            return this;
        }

        public final void setTapeARNs(Collection<String> tapeARNs) {
            this.tapeARNs = TapeARNsCopier.copy(tapeARNs);
        }

        @Override
        public CreateTapesResponse build() {
            return new CreateTapesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
