/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.AccountIdListCopier;
import software.amazon.awssdk.services.ssm.model.AccountSharingInfo;
import software.amazon.awssdk.services.ssm.model.AccountSharingInfoListCopier;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDocumentPermissionResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, DescribeDocumentPermissionResponse> {
    private static final SdkField<List<String>> ACCOUNT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AccountIds").getter(DescribeDocumentPermissionResponse.getter(DescribeDocumentPermissionResponse::accountIds)).setter(DescribeDocumentPermissionResponse.setter(Builder::accountIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AccountSharingInfo>> ACCOUNT_SHARING_INFO_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AccountSharingInfoList").getter(DescribeDocumentPermissionResponse.getter(DescribeDocumentPermissionResponse::accountSharingInfoList)).setter(DescribeDocumentPermissionResponse.setter(Builder::accountSharingInfoList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountSharingInfoList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AccountSharingInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeDocumentPermissionResponse.getter(DescribeDocumentPermissionResponse::nextToken)).setter(DescribeDocumentPermissionResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_IDS_FIELD, ACCOUNT_SHARING_INFO_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> accountIds;
    private final List<AccountSharingInfo> accountSharingInfoList;
    private final String nextToken;

    private DescribeDocumentPermissionResponse(BuilderImpl builder) {
        super(builder);
        this.accountIds = builder.accountIds;
        this.accountSharingInfoList = builder.accountSharingInfoList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAccountIds() {
        return this.accountIds != null && !(this.accountIds instanceof SdkAutoConstructList);
    }

    public final List<String> accountIds() {
        return this.accountIds;
    }

    public final boolean hasAccountSharingInfoList() {
        return this.accountSharingInfoList != null && !(this.accountSharingInfoList instanceof SdkAutoConstructList);
    }

    public final List<AccountSharingInfo> accountSharingInfoList() {
        return this.accountSharingInfoList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccountIds() ? this.accountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccountSharingInfoList() ? this.accountSharingInfoList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDocumentPermissionResponse)) {
            return false;
        }
        DescribeDocumentPermissionResponse other = (DescribeDocumentPermissionResponse)((Object)obj);
        return this.hasAccountIds() == other.hasAccountIds() && Objects.equals(this.accountIds(), other.accountIds()) && this.hasAccountSharingInfoList() == other.hasAccountSharingInfoList() && Objects.equals(this.accountSharingInfoList(), other.accountSharingInfoList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDocumentPermissionResponse").add("AccountIds", this.hasAccountIds() ? this.accountIds() : null).add("AccountSharingInfoList", this.hasAccountSharingInfoList() ? this.accountSharingInfoList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountIds": {
                return Optional.ofNullable(clazz.cast(this.accountIds()));
            }
            case "AccountSharingInfoList": {
                return Optional.ofNullable(clazz.cast(this.accountSharingInfoList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDocumentPermissionResponse, T> g) {
        return obj -> g.apply((DescribeDocumentPermissionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private List<String> accountIds = DefaultSdkAutoConstructList.getInstance();
        private List<AccountSharingInfo> accountSharingInfoList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDocumentPermissionResponse model) {
            super(model);
            this.accountIds(model.accountIds);
            this.accountSharingInfoList(model.accountSharingInfoList);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getAccountIds() {
            if (this.accountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.accountIds;
        }

        public final void setAccountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdListCopier.copy(accountIds);
        }

        @Override
        public final Builder accountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdListCopier.copy(accountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(String ... accountIds) {
            this.accountIds(Arrays.asList(accountIds));
            return this;
        }

        public final List<AccountSharingInfo.Builder> getAccountSharingInfoList() {
            List<AccountSharingInfo.Builder> result = AccountSharingInfoListCopier.copyToBuilder(this.accountSharingInfoList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccountSharingInfoList(Collection<AccountSharingInfo.BuilderImpl> accountSharingInfoList) {
            this.accountSharingInfoList = AccountSharingInfoListCopier.copyFromBuilder(accountSharingInfoList);
        }

        @Override
        public final Builder accountSharingInfoList(Collection<AccountSharingInfo> accountSharingInfoList) {
            this.accountSharingInfoList = AccountSharingInfoListCopier.copy(accountSharingInfoList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountSharingInfoList(AccountSharingInfo ... accountSharingInfoList) {
            this.accountSharingInfoList(Arrays.asList(accountSharingInfoList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountSharingInfoList(Consumer<AccountSharingInfo.Builder> ... accountSharingInfoList) {
            this.accountSharingInfoList(Stream.of(accountSharingInfoList).map(c -> (AccountSharingInfo)((AccountSharingInfo.Builder)AccountSharingInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeDocumentPermissionResponse build() {
            return new DescribeDocumentPermissionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDocumentPermissionResponse> {
        public Builder accountIds(Collection<String> var1);

        public Builder accountIds(String ... var1);

        public Builder accountSharingInfoList(Collection<AccountSharingInfo> var1);

        public Builder accountSharingInfoList(AccountSharingInfo ... var1);

        public Builder accountSharingInfoList(Consumer<AccountSharingInfo.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

