/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.model.DocumentVersionInfo;
import software.amazon.awssdk.services.ssm.model.ListDocumentVersionsRequest;
import software.amazon.awssdk.services.ssm.model.ListDocumentVersionsResponse;

public class ListDocumentVersionsIterable
implements SdkIterable<ListDocumentVersionsResponse> {
    private final SsmClient client;
    private final ListDocumentVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDocumentVersionsIterable(SsmClient client, ListDocumentVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListDocumentVersionsResponseFetcher();
    }

    public Iterator<ListDocumentVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DocumentVersionInfo> documentVersions() {
        Function<ListDocumentVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.documentVersions() != null) {
                return response.documentVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDocumentVersionsResponseFetcher
    implements SyncPageFetcher<ListDocumentVersionsResponse> {
        private ListDocumentVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListDocumentVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDocumentVersionsResponse nextPage(ListDocumentVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListDocumentVersionsIterable.this.client.listDocumentVersions(ListDocumentVersionsIterable.this.firstRequest);
            }
            return ListDocumentVersionsIterable.this.client.listDocumentVersions((ListDocumentVersionsRequest)((Object)ListDocumentVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

