/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmAsyncClient;
import software.amazon.awssdk.services.ssm.model.DescribePatchBaselinesRequest;
import software.amazon.awssdk.services.ssm.model.DescribePatchBaselinesResponse;
import software.amazon.awssdk.services.ssm.model.PatchBaselineIdentity;

public class DescribePatchBaselinesPublisher
implements SdkPublisher<DescribePatchBaselinesResponse> {
    private final SsmAsyncClient client;
    private final DescribePatchBaselinesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribePatchBaselinesPublisher(SsmAsyncClient client, DescribePatchBaselinesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribePatchBaselinesPublisher(SsmAsyncClient client, DescribePatchBaselinesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribePatchBaselinesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribePatchBaselinesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PatchBaselineIdentity> baselineIdentities() {
        Function<DescribePatchBaselinesResponse, Iterator> getIterator = response -> {
            if (response != null && response.baselineIdentities() != null) {
                return response.baselineIdentities().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribePatchBaselinesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribePatchBaselinesResponseFetcher
    implements AsyncPageFetcher<DescribePatchBaselinesResponse> {
        private DescribePatchBaselinesResponseFetcher() {
        }

        public boolean hasNextPage(DescribePatchBaselinesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribePatchBaselinesResponse> nextPage(DescribePatchBaselinesResponse previousPage) {
            if (previousPage == null) {
                return DescribePatchBaselinesPublisher.this.client.describePatchBaselines(DescribePatchBaselinesPublisher.this.firstRequest);
            }
            return DescribePatchBaselinesPublisher.this.client.describePatchBaselines((DescribePatchBaselinesRequest)((Object)DescribePatchBaselinesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

