/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesRequest;
import software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesResponse;
import software.amazon.awssdk.services.ssm.model.InstancePatchState;

public class DescribeInstancePatchStatesIterable
implements SdkIterable<DescribeInstancePatchStatesResponse> {
    private final SsmClient client;
    private final DescribeInstancePatchStatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeInstancePatchStatesIterable(SsmClient client, DescribeInstancePatchStatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeInstancePatchStatesResponseFetcher();
    }

    public Iterator<DescribeInstancePatchStatesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<InstancePatchState> instancePatchStates() {
        Function<DescribeInstancePatchStatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.instancePatchStates() != null) {
                return response.instancePatchStates().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeInstancePatchStatesResponseFetcher
    implements SyncPageFetcher<DescribeInstancePatchStatesResponse> {
        private DescribeInstancePatchStatesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeInstancePatchStatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeInstancePatchStatesResponse nextPage(DescribeInstancePatchStatesResponse previousPage) {
            if (previousPage == null) {
                return DescribeInstancePatchStatesIterable.this.client.describeInstancePatchStates(DescribeInstancePatchStatesIterable.this.firstRequest);
            }
            return DescribeInstancePatchStatesIterable.this.client.describeInstancePatchStates((DescribeInstancePatchStatesRequest)((Object)DescribeInstancePatchStatesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

