/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmAsyncClient;
import software.amazon.awssdk.services.ssm.model.AutomationExecutionMetadata;
import software.amazon.awssdk.services.ssm.model.DescribeAutomationExecutionsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeAutomationExecutionsResponse;

public class DescribeAutomationExecutionsPublisher
implements SdkPublisher<DescribeAutomationExecutionsResponse> {
    private final SsmAsyncClient client;
    private final DescribeAutomationExecutionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeAutomationExecutionsPublisher(SsmAsyncClient client, DescribeAutomationExecutionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeAutomationExecutionsPublisher(SsmAsyncClient client, DescribeAutomationExecutionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeAutomationExecutionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeAutomationExecutionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AutomationExecutionMetadata> automationExecutionMetadataList() {
        Function<DescribeAutomationExecutionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.automationExecutionMetadataList() != null) {
                return response.automationExecutionMetadataList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeAutomationExecutionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeAutomationExecutionsResponseFetcher
    implements AsyncPageFetcher<DescribeAutomationExecutionsResponse> {
        private DescribeAutomationExecutionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeAutomationExecutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeAutomationExecutionsResponse> nextPage(DescribeAutomationExecutionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeAutomationExecutionsPublisher.this.client.describeAutomationExecutions(DescribeAutomationExecutionsPublisher.this.firstRequest);
            }
            return DescribeAutomationExecutionsPublisher.this.client.describeAutomationExecutions((DescribeAutomationExecutionsRequest)((Object)DescribeAutomationExecutionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

