/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssm.model.ConnectionStatus;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetConnectionStatusResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, GetConnectionStatusResponse> {
    private static final SdkField<String> TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Target").getter(GetConnectionStatusResponse.getter(GetConnectionStatusResponse::target)).setter(GetConnectionStatusResponse.setter(Builder::target)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GetConnectionStatusResponse.getter(GetConnectionStatusResponse::statusAsString)).setter(GetConnectionStatusResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_FIELD, STATUS_FIELD));
    private final String target;
    private final String status;

    private GetConnectionStatusResponse(BuilderImpl builder) {
        super(builder);
        this.target = builder.target;
        this.status = builder.status;
    }

    public final String target() {
        return this.target;
    }

    public final ConnectionStatus status() {
        return ConnectionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.target());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConnectionStatusResponse)) {
            return false;
        }
        GetConnectionStatusResponse other = (GetConnectionStatusResponse)((Object)obj);
        return Objects.equals(this.target(), other.target()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetConnectionStatusResponse").add("Target", (Object)this.target()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Target": {
                return Optional.ofNullable(clazz.cast(this.target()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetConnectionStatusResponse, T> g) {
        return obj -> g.apply((GetConnectionStatusResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private String target;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConnectionStatusResponse model) {
            super(model);
            this.target(model.target);
            this.status(model.status);
        }

        public final String getTarget() {
            return this.target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ConnectionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public GetConnectionStatusResponse build() {
            return new GetConnectionStatusResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetConnectionStatusResponse> {
        public Builder target(String var1);

        public Builder status(String var1);

        public Builder status(ConnectionStatus var1);
    }
}

