/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCalendarStateResponse extends SsmResponse implements
        ToCopyableBuilder<GetCalendarStateResponse.Builder, GetCalendarStateResponse> {
    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(GetCalendarStateResponse::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> AT_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("AtTime")
            .getter(getter(GetCalendarStateResponse::atTime)).setter(setter(Builder::atTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AtTime").build()).build();

    private static final SdkField<String> NEXT_TRANSITION_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextTransitionTime").getter(getter(GetCalendarStateResponse::nextTransitionTime))
            .setter(setter(Builder::nextTransitionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextTransitionTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD, AT_TIME_FIELD,
            NEXT_TRANSITION_TIME_FIELD));

    private final String state;

    private final String atTime;

    private final String nextTransitionTime;

    private GetCalendarStateResponse(BuilderImpl builder) {
        super(builder);
        this.state = builder.state;
        this.atTime = builder.atTime;
        this.nextTransitionTime = builder.nextTransitionTime;
    }

    /**
     * <p>
     * The state of the calendar. An <code>OPEN</code> calendar indicates that actions are allowed to proceed, and a
     * <code>CLOSED</code> calendar indicates that actions are not allowed to proceed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CalendarState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the calendar. An <code>OPEN</code> calendar indicates that actions are allowed to proceed,
     *         and a <code>CLOSED</code> calendar indicates that actions are not allowed to proceed.
     * @see CalendarState
     */
    public final CalendarState state() {
        return CalendarState.fromValue(state);
    }

    /**
     * <p>
     * The state of the calendar. An <code>OPEN</code> calendar indicates that actions are allowed to proceed, and a
     * <code>CLOSED</code> calendar indicates that actions are not allowed to proceed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CalendarState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the calendar. An <code>OPEN</code> calendar indicates that actions are allowed to proceed,
     *         and a <code>CLOSED</code> calendar indicates that actions are not allowed to proceed.
     * @see CalendarState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The time, as an <a href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601</a> string, that you specified in your
     * command. If you did not specify a time, <code>GetCalendarState</code> uses the current time.
     * </p>
     * 
     * @return The time, as an <a href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601</a> string, that you specified
     *         in your command. If you did not specify a time, <code>GetCalendarState</code> uses the current time.
     */
    public final String atTime() {
        return atTime;
    }

    /**
     * <p>
     * The time, as an <a href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601</a> string, that the calendar state
     * will change. If the current calendar state is <code>OPEN</code>, <code>NextTransitionTime</code> indicates when
     * the calendar state changes to <code>CLOSED</code>, and vice-versa.
     * </p>
     * 
     * @return The time, as an <a href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601</a> string, that the calendar
     *         state will change. If the current calendar state is <code>OPEN</code>, <code>NextTransitionTime</code>
     *         indicates when the calendar state changes to <code>CLOSED</code>, and vice-versa.
     */
    public final String nextTransitionTime() {
        return nextTransitionTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(atTime());
        hashCode = 31 * hashCode + Objects.hashCode(nextTransitionTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCalendarStateResponse)) {
            return false;
        }
        GetCalendarStateResponse other = (GetCalendarStateResponse) obj;
        return Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(atTime(), other.atTime())
                && Objects.equals(nextTransitionTime(), other.nextTransitionTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCalendarStateResponse").add("State", stateAsString()).add("AtTime", atTime())
                .add("NextTransitionTime", nextTransitionTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "AtTime":
            return Optional.ofNullable(clazz.cast(atTime()));
        case "NextTransitionTime":
            return Optional.ofNullable(clazz.cast(nextTransitionTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCalendarStateResponse, T> g) {
        return obj -> g.apply((GetCalendarStateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetCalendarStateResponse> {
        /**
         * <p>
         * The state of the calendar. An <code>OPEN</code> calendar indicates that actions are allowed to proceed, and a
         * <code>CLOSED</code> calendar indicates that actions are not allowed to proceed.
         * </p>
         * 
         * @param state
         *        The state of the calendar. An <code>OPEN</code> calendar indicates that actions are allowed to
         *        proceed, and a <code>CLOSED</code> calendar indicates that actions are not allowed to proceed.
         * @see CalendarState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CalendarState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the calendar. An <code>OPEN</code> calendar indicates that actions are allowed to proceed, and a
         * <code>CLOSED</code> calendar indicates that actions are not allowed to proceed.
         * </p>
         * 
         * @param state
         *        The state of the calendar. An <code>OPEN</code> calendar indicates that actions are allowed to
         *        proceed, and a <code>CLOSED</code> calendar indicates that actions are not allowed to proceed.
         * @see CalendarState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CalendarState
         */
        Builder state(CalendarState state);

        /**
         * <p>
         * The time, as an <a href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601</a> string, that you specified in
         * your command. If you did not specify a time, <code>GetCalendarState</code> uses the current time.
         * </p>
         * 
         * @param atTime
         *        The time, as an <a href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601</a> string, that you
         *        specified in your command. If you did not specify a time, <code>GetCalendarState</code> uses the
         *        current time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder atTime(String atTime);

        /**
         * <p>
         * The time, as an <a href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601</a> string, that the calendar state
         * will change. If the current calendar state is <code>OPEN</code>, <code>NextTransitionTime</code> indicates
         * when the calendar state changes to <code>CLOSED</code>, and vice-versa.
         * </p>
         * 
         * @param nextTransitionTime
         *        The time, as an <a href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601</a> string, that the
         *        calendar state will change. If the current calendar state is <code>OPEN</code>,
         *        <code>NextTransitionTime</code> indicates when the calendar state changes to <code>CLOSED</code>, and
         *        vice-versa.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextTransitionTime(String nextTransitionTime);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private String state;

        private String atTime;

        private String nextTransitionTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCalendarStateResponse model) {
            super(model);
            state(model.state);
            atTime(model.atTime);
            nextTransitionTime(model.nextTransitionTime);
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CalendarState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getAtTime() {
            return atTime;
        }

        @Override
        public final Builder atTime(String atTime) {
            this.atTime = atTime;
            return this;
        }

        public final void setAtTime(String atTime) {
            this.atTime = atTime;
        }

        public final String getNextTransitionTime() {
            return nextTransitionTime;
        }

        @Override
        public final Builder nextTransitionTime(String nextTransitionTime) {
            this.nextTransitionTime = nextTransitionTime;
            return this;
        }

        public final void setNextTransitionTime(String nextTransitionTime) {
            this.nextTransitionTime = nextTransitionTime;
        }

        @Override
        public GetCalendarStateResponse build() {
            return new GetCalendarStateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
