/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a document approval review.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DocumentReviews implements SdkPojo, Serializable, ToCopyableBuilder<DocumentReviews.Builder, DocumentReviews> {
    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Action")
            .getter(getter(DocumentReviews::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<List<DocumentReviewCommentSource>> COMMENT_FIELD = SdkField
            .<List<DocumentReviewCommentSource>> builder(MarshallingType.LIST)
            .memberName("Comment")
            .getter(getter(DocumentReviews::comment))
            .setter(setter(Builder::comment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comment").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DocumentReviewCommentSource> builder(MarshallingType.SDK_POJO)
                                            .constructor(DocumentReviewCommentSource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, COMMENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String action;

    private final List<DocumentReviewCommentSource> comment;

    private DocumentReviews(BuilderImpl builder) {
        this.action = builder.action;
        this.comment = builder.comment;
    }

    /**
     * <p>
     * The action to take on a document approval review request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link DocumentReviewAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #actionAsString}.
     * </p>
     * 
     * @return The action to take on a document approval review request.
     * @see DocumentReviewAction
     */
    public final DocumentReviewAction action() {
        return DocumentReviewAction.fromValue(action);
    }

    /**
     * <p>
     * The action to take on a document approval review request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link DocumentReviewAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #actionAsString}.
     * </p>
     * 
     * @return The action to take on a document approval review request.
     * @see DocumentReviewAction
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * Returns true if the Comment property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasComment() {
        return comment != null && !(comment instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A comment entered by a user in your organization about the document review request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasComment()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A comment entered by a user in your organization about the document review request.
     */
    public final List<DocumentReviewCommentSource> comment() {
        return comment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasComment() ? comment() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentReviews)) {
            return false;
        }
        DocumentReviews other = (DocumentReviews) obj;
        return Objects.equals(actionAsString(), other.actionAsString()) && hasComment() == other.hasComment()
                && Objects.equals(comment(), other.comment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DocumentReviews").add("Action", actionAsString())
                .add("Comment", hasComment() ? comment() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "Comment":
            return Optional.ofNullable(clazz.cast(comment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DocumentReviews, T> g) {
        return obj -> g.apply((DocumentReviews) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DocumentReviews> {
        /**
         * <p>
         * The action to take on a document approval review request.
         * </p>
         * 
         * @param action
         *        The action to take on a document approval review request.
         * @see DocumentReviewAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentReviewAction
         */
        Builder action(String action);

        /**
         * <p>
         * The action to take on a document approval review request.
         * </p>
         * 
         * @param action
         *        The action to take on a document approval review request.
         * @see DocumentReviewAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentReviewAction
         */
        Builder action(DocumentReviewAction action);

        /**
         * <p>
         * A comment entered by a user in your organization about the document review request.
         * </p>
         * 
         * @param comment
         *        A comment entered by a user in your organization about the document review request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(Collection<DocumentReviewCommentSource> comment);

        /**
         * <p>
         * A comment entered by a user in your organization about the document review request.
         * </p>
         * 
         * @param comment
         *        A comment entered by a user in your organization about the document review request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(DocumentReviewCommentSource... comment);

        /**
         * <p>
         * A comment entered by a user in your organization about the document review request.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DocumentReviewCommentSource>.Builder}
         * avoiding the need to create one manually via {@link List<DocumentReviewCommentSource>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DocumentReviewCommentSource>.Builder#build()} is called
         * immediately and its result is passed to {@link #comment(List<DocumentReviewCommentSource>)}.
         * 
         * @param comment
         *        a consumer that will call methods on {@link List<DocumentReviewCommentSource>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #comment(List<DocumentReviewCommentSource>)
         */
        Builder comment(Consumer<DocumentReviewCommentSource.Builder>... comment);
    }

    static final class BuilderImpl implements Builder {
        private String action;

        private List<DocumentReviewCommentSource> comment = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentReviews model) {
            action(model.action);
            comment(model.comment);
        }

        public final String getAction() {
            return action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(DocumentReviewAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final List<DocumentReviewCommentSource.Builder> getComment() {
            List<DocumentReviewCommentSource.Builder> result = DocumentReviewCommentListCopier.copyToBuilder(this.comment);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder comment(Collection<DocumentReviewCommentSource> comment) {
            this.comment = DocumentReviewCommentListCopier.copy(comment);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder comment(DocumentReviewCommentSource... comment) {
            comment(Arrays.asList(comment));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder comment(Consumer<DocumentReviewCommentSource.Builder>... comment) {
            comment(Stream.of(comment).map(c -> DocumentReviewCommentSource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setComment(Collection<DocumentReviewCommentSource.BuilderImpl> comment) {
            this.comment = DocumentReviewCommentListCopier.copyFromBuilder(comment);
        }

        @Override
        public DocumentReviews build() {
            return new DocumentReviews(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
