/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.services.ssm.model.StepExecution;
import software.amazon.awssdk.services.ssm.model.StepExecutionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAutomationStepExecutionsResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, DescribeAutomationStepExecutionsResponse> {
    private static final SdkField<List<StepExecution>> STEP_EXECUTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeAutomationStepExecutionsResponse.getter(DescribeAutomationStepExecutionsResponse::stepExecutions)).setter(DescribeAutomationStepExecutionsResponse.setter(Builder::stepExecutions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepExecutions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StepExecution::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeAutomationStepExecutionsResponse.getter(DescribeAutomationStepExecutionsResponse::nextToken)).setter(DescribeAutomationStepExecutionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEP_EXECUTIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<StepExecution> stepExecutions;
    private final String nextToken;

    private DescribeAutomationStepExecutionsResponse(BuilderImpl builder) {
        super(builder);
        this.stepExecutions = builder.stepExecutions;
        this.nextToken = builder.nextToken;
    }

    public boolean hasStepExecutions() {
        return this.stepExecutions != null && !(this.stepExecutions instanceof SdkAutoConstructList);
    }

    public List<StepExecution> stepExecutions() {
        return this.stepExecutions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.stepExecutions());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAutomationStepExecutionsResponse)) {
            return false;
        }
        DescribeAutomationStepExecutionsResponse other = (DescribeAutomationStepExecutionsResponse)((Object)obj);
        return Objects.equals(this.stepExecutions(), other.stepExecutions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeAutomationStepExecutionsResponse").add("StepExecutions", this.stepExecutions()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StepExecutions": {
                return Optional.ofNullable(clazz.cast(this.stepExecutions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAutomationStepExecutionsResponse, T> g) {
        return obj -> g.apply((DescribeAutomationStepExecutionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private List<StepExecution> stepExecutions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAutomationStepExecutionsResponse model) {
            super(model);
            this.stepExecutions(model.stepExecutions);
            this.nextToken(model.nextToken);
        }

        public final Collection<StepExecution.Builder> getStepExecutions() {
            return this.stepExecutions != null ? (Collection)this.stepExecutions.stream().map(StepExecution::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder stepExecutions(Collection<StepExecution> stepExecutions) {
            this.stepExecutions = StepExecutionListCopier.copy(stepExecutions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepExecutions(StepExecution ... stepExecutions) {
            this.stepExecutions(Arrays.asList(stepExecutions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepExecutions(Consumer<StepExecution.Builder> ... stepExecutions) {
            this.stepExecutions(Stream.of(stepExecutions).map(c -> (StepExecution)((StepExecution.Builder)StepExecution.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStepExecutions(Collection<StepExecution.BuilderImpl> stepExecutions) {
            this.stepExecutions = StepExecutionListCopier.copyFromBuilder(stepExecutions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeAutomationStepExecutionsResponse build() {
            return new DescribeAutomationStepExecutionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAutomationStepExecutionsResponse> {
        public Builder stepExecutions(Collection<StepExecution> var1);

        public Builder stepExecutions(StepExecution ... var1);

        public Builder stepExecutions(Consumer<StepExecution.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

