/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.shield.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A single attack statistics data record. This is returned by <a>DescribeAttackStatistics</a> along with a time range
 * indicating the time period that the attack statistics apply to.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AttackStatisticsDataItem implements SdkPojo, Serializable,
        ToCopyableBuilder<AttackStatisticsDataItem.Builder, AttackStatisticsDataItem> {
    private static final SdkField<AttackVolume> ATTACK_VOLUME_FIELD = SdkField.<AttackVolume> builder(MarshallingType.SDK_POJO)
            .memberName("AttackVolume").getter(getter(AttackStatisticsDataItem::attackVolume))
            .setter(setter(Builder::attackVolume)).constructor(AttackVolume::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttackVolume").build()).build();

    private static final SdkField<Long> ATTACK_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("AttackCount").getter(getter(AttackStatisticsDataItem::attackCount)).setter(setter(Builder::attackCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttackCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACK_VOLUME_FIELD,
            ATTACK_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final AttackVolume attackVolume;

    private final Long attackCount;

    private AttackStatisticsDataItem(BuilderImpl builder) {
        this.attackVolume = builder.attackVolume;
        this.attackCount = builder.attackCount;
    }

    /**
     * <p>
     * Information about the volume of attacks during the time period. If the accompanying <code>AttackCount</code> is
     * zero, this setting might be empty.
     * </p>
     * 
     * @return Information about the volume of attacks during the time period. If the accompanying
     *         <code>AttackCount</code> is zero, this setting might be empty.
     */
    public final AttackVolume attackVolume() {
        return attackVolume;
    }

    /**
     * <p>
     * The number of attacks detected during the time period. This is always present, but might be zero.
     * </p>
     * 
     * @return The number of attacks detected during the time period. This is always present, but might be zero.
     */
    public final Long attackCount() {
        return attackCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attackVolume());
        hashCode = 31 * hashCode + Objects.hashCode(attackCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttackStatisticsDataItem)) {
            return false;
        }
        AttackStatisticsDataItem other = (AttackStatisticsDataItem) obj;
        return Objects.equals(attackVolume(), other.attackVolume()) && Objects.equals(attackCount(), other.attackCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AttackStatisticsDataItem").add("AttackVolume", attackVolume()).add("AttackCount", attackCount())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttackVolume":
            return Optional.ofNullable(clazz.cast(attackVolume()));
        case "AttackCount":
            return Optional.ofNullable(clazz.cast(attackCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AttackStatisticsDataItem, T> g) {
        return obj -> g.apply((AttackStatisticsDataItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AttackStatisticsDataItem> {
        /**
         * <p>
         * Information about the volume of attacks during the time period. If the accompanying <code>AttackCount</code>
         * is zero, this setting might be empty.
         * </p>
         * 
         * @param attackVolume
         *        Information about the volume of attacks during the time period. If the accompanying
         *        <code>AttackCount</code> is zero, this setting might be empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attackVolume(AttackVolume attackVolume);

        /**
         * <p>
         * Information about the volume of attacks during the time period. If the accompanying <code>AttackCount</code>
         * is zero, this setting might be empty.
         * </p>
         * This is a convenience that creates an instance of the {@link AttackVolume.Builder} avoiding the need to
         * create one manually via {@link AttackVolume#builder()}.
         *
         * When the {@link Consumer} completes, {@link AttackVolume.Builder#build()} is called immediately and its
         * result is passed to {@link #attackVolume(AttackVolume)}.
         * 
         * @param attackVolume
         *        a consumer that will call methods on {@link AttackVolume.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attackVolume(AttackVolume)
         */
        default Builder attackVolume(Consumer<AttackVolume.Builder> attackVolume) {
            return attackVolume(AttackVolume.builder().applyMutation(attackVolume).build());
        }

        /**
         * <p>
         * The number of attacks detected during the time period. This is always present, but might be zero.
         * </p>
         * 
         * @param attackCount
         *        The number of attacks detected during the time period. This is always present, but might be zero.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attackCount(Long attackCount);
    }

    static final class BuilderImpl implements Builder {
        private AttackVolume attackVolume;

        private Long attackCount;

        private BuilderImpl() {
        }

        private BuilderImpl(AttackStatisticsDataItem model) {
            attackVolume(model.attackVolume);
            attackCount(model.attackCount);
        }

        public final AttackVolume.Builder getAttackVolume() {
            return attackVolume != null ? attackVolume.toBuilder() : null;
        }

        @Override
        public final Builder attackVolume(AttackVolume attackVolume) {
            this.attackVolume = attackVolume;
            return this;
        }

        public final void setAttackVolume(AttackVolume.BuilderImpl attackVolume) {
            this.attackVolume = attackVolume != null ? attackVolume.build() : null;
        }

        public final Long getAttackCount() {
            return attackCount;
        }

        @Override
        public final Builder attackCount(Long attackCount) {
            this.attackCount = attackCount;
            return this;
        }

        public final void setAttackCount(Long attackCount) {
            this.attackCount = attackCount;
        }

        @Override
        public AttackStatisticsDataItem build() {
            return new AttackStatisticsDataItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
