/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sesv2.model.ContactList;
import software.amazon.awssdk.services.sesv2.model.ListOfContactListsCopier;
import software.amazon.awssdk.services.sesv2.model.SesV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListContactListsResponse
extends SesV2Response
implements ToCopyableBuilder<Builder, ListContactListsResponse> {
    private static final SdkField<List<ContactList>> CONTACT_LISTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ContactLists").getter(ListContactListsResponse.getter(ListContactListsResponse::contactLists)).setter(ListContactListsResponse.setter(Builder::contactLists)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactLists").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContactList::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListContactListsResponse.getter(ListContactListsResponse::nextToken)).setter(ListContactListsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_LISTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ContactList> contactLists;
    private final String nextToken;

    private ListContactListsResponse(BuilderImpl builder) {
        super(builder);
        this.contactLists = builder.contactLists;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasContactLists() {
        return this.contactLists != null && !(this.contactLists instanceof SdkAutoConstructList);
    }

    public final List<ContactList> contactLists() {
        return this.contactLists;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContactLists() ? this.contactLists() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListContactListsResponse)) {
            return false;
        }
        ListContactListsResponse other = (ListContactListsResponse)((Object)obj);
        return this.hasContactLists() == other.hasContactLists() && Objects.equals(this.contactLists(), other.contactLists()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListContactListsResponse").add("ContactLists", this.hasContactLists() ? this.contactLists() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContactLists": {
                return Optional.ofNullable(clazz.cast(this.contactLists()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListContactListsResponse, T> g) {
        return obj -> g.apply((ListContactListsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesV2Response.BuilderImpl
    implements Builder {
        private List<ContactList> contactLists = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListContactListsResponse model) {
            super(model);
            this.contactLists(model.contactLists);
            this.nextToken(model.nextToken);
        }

        public final List<ContactList.Builder> getContactLists() {
            List<ContactList.Builder> result = ListOfContactListsCopier.copyToBuilder(this.contactLists);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder contactLists(Collection<ContactList> contactLists) {
            this.contactLists = ListOfContactListsCopier.copy(contactLists);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contactLists(ContactList ... contactLists) {
            this.contactLists(Arrays.asList(contactLists));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contactLists(Consumer<ContactList.Builder> ... contactLists) {
            this.contactLists(Stream.of(contactLists).map(c -> (ContactList)((ContactList.Builder)ContactList.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setContactLists(Collection<ContactList.BuilderImpl> contactLists) {
            this.contactLists = ListOfContactListsCopier.copyFromBuilder(contactLists);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListContactListsResponse build() {
            return new ListContactListsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SesV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListContactListsResponse> {
        public Builder contactLists(Collection<ContactList> var1);

        public Builder contactLists(ContactList ... var1);

        public Builder contactLists(Consumer<ContactList.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

