/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A request to associate a configuration set with a dedicated IP pool.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutConfigurationSetDeliveryOptionsRequest extends SesV2Request implements
        ToCopyableBuilder<PutConfigurationSetDeliveryOptionsRequest.Builder, PutConfigurationSetDeliveryOptionsRequest> {
    private static final SdkField<String> CONFIGURATION_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationSetName").getter(getter(PutConfigurationSetDeliveryOptionsRequest::configurationSetName))
            .setter(setter(Builder::configurationSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ConfigurationSetName").build()).build();

    private static final SdkField<String> TLS_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TlsPolicy").getter(getter(PutConfigurationSetDeliveryOptionsRequest::tlsPolicyAsString))
            .setter(setter(Builder::tlsPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TlsPolicy").build()).build();

    private static final SdkField<String> SENDING_POOL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SendingPoolName").getter(getter(PutConfigurationSetDeliveryOptionsRequest::sendingPoolName))
            .setter(setter(Builder::sendingPoolName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SendingPoolName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_SET_NAME_FIELD,
            TLS_POLICY_FIELD, SENDING_POOL_NAME_FIELD));

    private final String configurationSetName;

    private final String tlsPolicy;

    private final String sendingPoolName;

    private PutConfigurationSetDeliveryOptionsRequest(BuilderImpl builder) {
        super(builder);
        this.configurationSetName = builder.configurationSetName;
        this.tlsPolicy = builder.tlsPolicy;
        this.sendingPoolName = builder.sendingPoolName;
    }

    /**
     * <p>
     * The name of the configuration set that you want to associate with a dedicated IP pool.
     * </p>
     * 
     * @return The name of the configuration set that you want to associate with a dedicated IP pool.
     */
    public final String configurationSetName() {
        return configurationSetName;
    }

    /**
     * <p>
     * Specifies whether messages that use the configuration set are required to use Transport Layer Security (TLS). If
     * the value is <code>Require</code>, messages are only delivered if a TLS connection can be established. If the
     * value is <code>Optional</code>, messages can be delivered in plain text if a TLS connection can't be established.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tlsPolicy} will
     * return {@link TlsPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tlsPolicyAsString}.
     * </p>
     * 
     * @return Specifies whether messages that use the configuration set are required to use Transport Layer Security
     *         (TLS). If the value is <code>Require</code>, messages are only delivered if a TLS connection can be
     *         established. If the value is <code>Optional</code>, messages can be delivered in plain text if a TLS
     *         connection can't be established.
     * @see TlsPolicy
     */
    public final TlsPolicy tlsPolicy() {
        return TlsPolicy.fromValue(tlsPolicy);
    }

    /**
     * <p>
     * Specifies whether messages that use the configuration set are required to use Transport Layer Security (TLS). If
     * the value is <code>Require</code>, messages are only delivered if a TLS connection can be established. If the
     * value is <code>Optional</code>, messages can be delivered in plain text if a TLS connection can't be established.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tlsPolicy} will
     * return {@link TlsPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tlsPolicyAsString}.
     * </p>
     * 
     * @return Specifies whether messages that use the configuration set are required to use Transport Layer Security
     *         (TLS). If the value is <code>Require</code>, messages are only delivered if a TLS connection can be
     *         established. If the value is <code>Optional</code>, messages can be delivered in plain text if a TLS
     *         connection can't be established.
     * @see TlsPolicy
     */
    public final String tlsPolicyAsString() {
        return tlsPolicy;
    }

    /**
     * <p>
     * The name of the dedicated IP pool that you want to associate with the configuration set.
     * </p>
     * 
     * @return The name of the dedicated IP pool that you want to associate with the configuration set.
     */
    public final String sendingPoolName() {
        return sendingPoolName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configurationSetName());
        hashCode = 31 * hashCode + Objects.hashCode(tlsPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sendingPoolName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutConfigurationSetDeliveryOptionsRequest)) {
            return false;
        }
        PutConfigurationSetDeliveryOptionsRequest other = (PutConfigurationSetDeliveryOptionsRequest) obj;
        return Objects.equals(configurationSetName(), other.configurationSetName())
                && Objects.equals(tlsPolicyAsString(), other.tlsPolicyAsString())
                && Objects.equals(sendingPoolName(), other.sendingPoolName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutConfigurationSetDeliveryOptionsRequest").add("ConfigurationSetName", configurationSetName())
                .add("TlsPolicy", tlsPolicyAsString()).add("SendingPoolName", sendingPoolName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationSetName":
            return Optional.ofNullable(clazz.cast(configurationSetName()));
        case "TlsPolicy":
            return Optional.ofNullable(clazz.cast(tlsPolicyAsString()));
        case "SendingPoolName":
            return Optional.ofNullable(clazz.cast(sendingPoolName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutConfigurationSetDeliveryOptionsRequest, T> g) {
        return obj -> g.apply((PutConfigurationSetDeliveryOptionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, PutConfigurationSetDeliveryOptionsRequest> {
        /**
         * <p>
         * The name of the configuration set that you want to associate with a dedicated IP pool.
         * </p>
         * 
         * @param configurationSetName
         *        The name of the configuration set that you want to associate with a dedicated IP pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSetName(String configurationSetName);

        /**
         * <p>
         * Specifies whether messages that use the configuration set are required to use Transport Layer Security (TLS).
         * If the value is <code>Require</code>, messages are only delivered if a TLS connection can be established. If
         * the value is <code>Optional</code>, messages can be delivered in plain text if a TLS connection can't be
         * established.
         * </p>
         * 
         * @param tlsPolicy
         *        Specifies whether messages that use the configuration set are required to use Transport Layer Security
         *        (TLS). If the value is <code>Require</code>, messages are only delivered if a TLS connection can be
         *        established. If the value is <code>Optional</code>, messages can be delivered in plain text if a TLS
         *        connection can't be established.
         * @see TlsPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TlsPolicy
         */
        Builder tlsPolicy(String tlsPolicy);

        /**
         * <p>
         * Specifies whether messages that use the configuration set are required to use Transport Layer Security (TLS).
         * If the value is <code>Require</code>, messages are only delivered if a TLS connection can be established. If
         * the value is <code>Optional</code>, messages can be delivered in plain text if a TLS connection can't be
         * established.
         * </p>
         * 
         * @param tlsPolicy
         *        Specifies whether messages that use the configuration set are required to use Transport Layer Security
         *        (TLS). If the value is <code>Require</code>, messages are only delivered if a TLS connection can be
         *        established. If the value is <code>Optional</code>, messages can be delivered in plain text if a TLS
         *        connection can't be established.
         * @see TlsPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TlsPolicy
         */
        Builder tlsPolicy(TlsPolicy tlsPolicy);

        /**
         * <p>
         * The name of the dedicated IP pool that you want to associate with the configuration set.
         * </p>
         * 
         * @param sendingPoolName
         *        The name of the dedicated IP pool that you want to associate with the configuration set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sendingPoolName(String sendingPoolName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SesV2Request.BuilderImpl implements Builder {
        private String configurationSetName;

        private String tlsPolicy;

        private String sendingPoolName;

        private BuilderImpl() {
        }

        private BuilderImpl(PutConfigurationSetDeliveryOptionsRequest model) {
            super(model);
            configurationSetName(model.configurationSetName);
            tlsPolicy(model.tlsPolicy);
            sendingPoolName(model.sendingPoolName);
        }

        public final String getConfigurationSetName() {
            return configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        public final String getTlsPolicy() {
            return tlsPolicy;
        }

        @Override
        public final Builder tlsPolicy(String tlsPolicy) {
            this.tlsPolicy = tlsPolicy;
            return this;
        }

        @Override
        public final Builder tlsPolicy(TlsPolicy tlsPolicy) {
            this.tlsPolicy(tlsPolicy == null ? null : tlsPolicy.toString());
            return this;
        }

        public final void setTlsPolicy(String tlsPolicy) {
            this.tlsPolicy = tlsPolicy;
        }

        public final String getSendingPoolName() {
            return sendingPoolName;
        }

        @Override
        public final Builder sendingPoolName(String sendingPoolName) {
            this.sendingPoolName = sendingPoolName;
            return this;
        }

        public final void setSendingPoolName(String sendingPoolName) {
            this.sendingPoolName = sendingPoolName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutConfigurationSetDeliveryOptionsRequest build() {
            return new PutConfigurationSetDeliveryOptionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
