/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListContactListsRequest extends SesV2Request implements
        ToCopyableBuilder<ListContactListsRequest.Builder, ListContactListsRequest> {
    private static final SdkField<Integer> PAGE_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PageSize").getter(getter(ListContactListsRequest::pageSize)).setter(setter(Builder::pageSize))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("PageSize").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListContactListsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PAGE_SIZE_FIELD,
            NEXT_TOKEN_FIELD));

    private final Integer pageSize;

    private final String nextToken;

    private ListContactListsRequest(BuilderImpl builder) {
        super(builder);
        this.pageSize = builder.pageSize;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Maximum number of contact lists to return at once. Use this parameter to paginate results. If additional contact
     * lists exist beyond the specified limit, the <code>NextToken</code> element is sent in the response. Use the
     * <code>NextToken</code> value in subsequent requests to retrieve additional lists.
     * </p>
     * 
     * @return Maximum number of contact lists to return at once. Use this parameter to paginate results. If additional
     *         contact lists exist beyond the specified limit, the <code>NextToken</code> element is sent in the
     *         response. Use the <code>NextToken</code> value in subsequent requests to retrieve additional lists.
     */
    public final Integer pageSize() {
        return pageSize;
    }

    /**
     * <p>
     * A string token indicating that there might be additional contact lists available to be listed. Use the token
     * provided in the Response to use in the subsequent call to ListContactLists with the same parameters to retrieve
     * the next page of contact lists.
     * </p>
     * 
     * @return A string token indicating that there might be additional contact lists available to be listed. Use the
     *         token provided in the Response to use in the subsequent call to ListContactLists with the same parameters
     *         to retrieve the next page of contact lists.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pageSize());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListContactListsRequest)) {
            return false;
        }
        ListContactListsRequest other = (ListContactListsRequest) obj;
        return Objects.equals(pageSize(), other.pageSize()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListContactListsRequest").add("PageSize", pageSize()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PageSize":
            return Optional.ofNullable(clazz.cast(pageSize()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListContactListsRequest, T> g) {
        return obj -> g.apply((ListContactListsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesV2Request.Builder, SdkPojo, CopyableBuilder<Builder, ListContactListsRequest> {
        /**
         * <p>
         * Maximum number of contact lists to return at once. Use this parameter to paginate results. If additional
         * contact lists exist beyond the specified limit, the <code>NextToken</code> element is sent in the response.
         * Use the <code>NextToken</code> value in subsequent requests to retrieve additional lists.
         * </p>
         * 
         * @param pageSize
         *        Maximum number of contact lists to return at once. Use this parameter to paginate results. If
         *        additional contact lists exist beyond the specified limit, the <code>NextToken</code> element is sent
         *        in the response. Use the <code>NextToken</code> value in subsequent requests to retrieve additional
         *        lists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageSize(Integer pageSize);

        /**
         * <p>
         * A string token indicating that there might be additional contact lists available to be listed. Use the token
         * provided in the Response to use in the subsequent call to ListContactLists with the same parameters to
         * retrieve the next page of contact lists.
         * </p>
         * 
         * @param nextToken
         *        A string token indicating that there might be additional contact lists available to be listed. Use the
         *        token provided in the Response to use in the subsequent call to ListContactLists with the same
         *        parameters to retrieve the next page of contact lists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SesV2Request.BuilderImpl implements Builder {
        private Integer pageSize;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListContactListsRequest model) {
            super(model);
            pageSize(model.pageSize);
            nextToken(model.nextToken);
        }

        public final Integer getPageSize() {
            return pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListContactListsRequest build() {
            return new ListContactListsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
