/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that defines an Amazon CloudWatch destination for email events. You can use Amazon CloudWatch to monitor
 * and gain insights on your email sending metrics.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CloudWatchDestination implements SdkPojo, Serializable,
        ToCopyableBuilder<CloudWatchDestination.Builder, CloudWatchDestination> {
    private static final SdkField<List<CloudWatchDimensionConfiguration>> DIMENSION_CONFIGURATIONS_FIELD = SdkField
            .<List<CloudWatchDimensionConfiguration>> builder(MarshallingType.LIST)
            .memberName("DimensionConfigurations")
            .getter(getter(CloudWatchDestination::dimensionConfigurations))
            .setter(setter(Builder::dimensionConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DimensionConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CloudWatchDimensionConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(CloudWatchDimensionConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DIMENSION_CONFIGURATIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<CloudWatchDimensionConfiguration> dimensionConfigurations;

    private CloudWatchDestination(BuilderImpl builder) {
        this.dimensionConfigurations = builder.dimensionConfigurations;
    }

    /**
     * Returns true if the DimensionConfigurations property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasDimensionConfigurations() {
        return dimensionConfigurations != null && !(dimensionConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that define the dimensions to use when you send email events to Amazon CloudWatch.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDimensionConfigurations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of objects that define the dimensions to use when you send email events to Amazon CloudWatch.
     */
    public final List<CloudWatchDimensionConfiguration> dimensionConfigurations() {
        return dimensionConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDimensionConfigurations() ? dimensionConfigurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchDestination)) {
            return false;
        }
        CloudWatchDestination other = (CloudWatchDestination) obj;
        return hasDimensionConfigurations() == other.hasDimensionConfigurations()
                && Objects.equals(dimensionConfigurations(), other.dimensionConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CloudWatchDestination")
                .add("DimensionConfigurations", hasDimensionConfigurations() ? dimensionConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DimensionConfigurations":
            return Optional.ofNullable(clazz.cast(dimensionConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CloudWatchDestination, T> g) {
        return obj -> g.apply((CloudWatchDestination) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CloudWatchDestination> {
        /**
         * <p>
         * An array of objects that define the dimensions to use when you send email events to Amazon CloudWatch.
         * </p>
         * 
         * @param dimensionConfigurations
         *        An array of objects that define the dimensions to use when you send email events to Amazon CloudWatch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensionConfigurations(Collection<CloudWatchDimensionConfiguration> dimensionConfigurations);

        /**
         * <p>
         * An array of objects that define the dimensions to use when you send email events to Amazon CloudWatch.
         * </p>
         * 
         * @param dimensionConfigurations
         *        An array of objects that define the dimensions to use when you send email events to Amazon CloudWatch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensionConfigurations(CloudWatchDimensionConfiguration... dimensionConfigurations);

        /**
         * <p>
         * An array of objects that define the dimensions to use when you send email events to Amazon CloudWatch.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CloudWatchDimensionConfiguration>.Builder}
         * avoiding the need to create one manually via {@link List<CloudWatchDimensionConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CloudWatchDimensionConfiguration>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #dimensionConfigurations(List<CloudWatchDimensionConfiguration>)}.
         * 
         * @param dimensionConfigurations
         *        a consumer that will call methods on {@link List<CloudWatchDimensionConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dimensionConfigurations(List<CloudWatchDimensionConfiguration>)
         */
        Builder dimensionConfigurations(Consumer<CloudWatchDimensionConfiguration.Builder>... dimensionConfigurations);
    }

    static final class BuilderImpl implements Builder {
        private List<CloudWatchDimensionConfiguration> dimensionConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchDestination model) {
            dimensionConfigurations(model.dimensionConfigurations);
        }

        public final List<CloudWatchDimensionConfiguration.Builder> getDimensionConfigurations() {
            List<CloudWatchDimensionConfiguration.Builder> result = CloudWatchDimensionConfigurationsCopier
                    .copyToBuilder(this.dimensionConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder dimensionConfigurations(Collection<CloudWatchDimensionConfiguration> dimensionConfigurations) {
            this.dimensionConfigurations = CloudWatchDimensionConfigurationsCopier.copy(dimensionConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensionConfigurations(CloudWatchDimensionConfiguration... dimensionConfigurations) {
            dimensionConfigurations(Arrays.asList(dimensionConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensionConfigurations(
                Consumer<CloudWatchDimensionConfiguration.Builder>... dimensionConfigurations) {
            dimensionConfigurations(Stream.of(dimensionConfigurations)
                    .map(c -> CloudWatchDimensionConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDimensionConfigurations(
                Collection<CloudWatchDimensionConfiguration.BuilderImpl> dimensionConfigurations) {
            this.dimensionConfigurations = CloudWatchDimensionConfigurationsCopier.copyFromBuilder(dimensionConfigurations);
        }

        @Override
        public CloudWatchDestination build() {
            return new CloudWatchDestination(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
