/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sesv2.SesV2Client;
import software.amazon.awssdk.services.sesv2.model.ListEmailTemplatesRequest;
import software.amazon.awssdk.services.sesv2.model.ListEmailTemplatesResponse;

public class ListEmailTemplatesIterable
implements SdkIterable<ListEmailTemplatesResponse> {
    private final SesV2Client client;
    private final ListEmailTemplatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEmailTemplatesIterable(SesV2Client client, ListEmailTemplatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListEmailTemplatesResponseFetcher();
    }

    public Iterator<ListEmailTemplatesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListEmailTemplatesResponseFetcher
    implements SyncPageFetcher<ListEmailTemplatesResponse> {
        private ListEmailTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(ListEmailTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEmailTemplatesResponse nextPage(ListEmailTemplatesResponse previousPage) {
            if (previousPage == null) {
                return ListEmailTemplatesIterable.this.client.listEmailTemplates(ListEmailTemplatesIterable.this.firstRequest);
            }
            return ListEmailTemplatesIterable.this.client.listEmailTemplates((ListEmailTemplatesRequest)((Object)ListEmailTemplatesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

