/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sesv2.model.FailureInfo;
import software.amazon.awssdk.services.sesv2.model.ImportDataSource;
import software.amazon.awssdk.services.sesv2.model.ImportDestination;
import software.amazon.awssdk.services.sesv2.model.JobStatus;
import software.amazon.awssdk.services.sesv2.model.SesV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetImportJobResponse
extends SesV2Response
implements ToCopyableBuilder<Builder, GetImportJobResponse> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetImportJobResponse.getter(GetImportJobResponse::jobId)).setter(GetImportJobResponse.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()}).build();
    private static final SdkField<ImportDestination> IMPORT_DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GetImportJobResponse.getter(GetImportJobResponse::importDestination)).setter(GetImportJobResponse.setter(Builder::importDestination)).constructor(ImportDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportDestination").build()}).build();
    private static final SdkField<ImportDataSource> IMPORT_DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GetImportJobResponse.getter(GetImportJobResponse::importDataSource)).setter(GetImportJobResponse.setter(Builder::importDataSource)).constructor(ImportDataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportDataSource").build()}).build();
    private static final SdkField<FailureInfo> FAILURE_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GetImportJobResponse.getter(GetImportJobResponse::failureInfo)).setter(GetImportJobResponse.setter(Builder::failureInfo)).constructor(FailureInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureInfo").build()}).build();
    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetImportJobResponse.getter(GetImportJobResponse::jobStatusAsString)).setter(GetImportJobResponse.setter(Builder::jobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(GetImportJobResponse.getter(GetImportJobResponse::createdTimestamp)).setter(GetImportJobResponse.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()}).build();
    private static final SdkField<Instant> COMPLETED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(GetImportJobResponse.getter(GetImportJobResponse::completedTimestamp)).setter(GetImportJobResponse.setter(Builder::completedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletedTimestamp").build()}).build();
    private static final SdkField<Integer> PROCESSED_RECORDS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(GetImportJobResponse.getter(GetImportJobResponse::processedRecordsCount)).setter(GetImportJobResponse.setter(Builder::processedRecordsCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessedRecordsCount").build()}).build();
    private static final SdkField<Integer> FAILED_RECORDS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(GetImportJobResponse.getter(GetImportJobResponse::failedRecordsCount)).setter(GetImportJobResponse.setter(Builder::failedRecordsCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedRecordsCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, IMPORT_DESTINATION_FIELD, IMPORT_DATA_SOURCE_FIELD, FAILURE_INFO_FIELD, JOB_STATUS_FIELD, CREATED_TIMESTAMP_FIELD, COMPLETED_TIMESTAMP_FIELD, PROCESSED_RECORDS_COUNT_FIELD, FAILED_RECORDS_COUNT_FIELD));
    private final String jobId;
    private final ImportDestination importDestination;
    private final ImportDataSource importDataSource;
    private final FailureInfo failureInfo;
    private final String jobStatus;
    private final Instant createdTimestamp;
    private final Instant completedTimestamp;
    private final Integer processedRecordsCount;
    private final Integer failedRecordsCount;

    private GetImportJobResponse(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.importDestination = builder.importDestination;
        this.importDataSource = builder.importDataSource;
        this.failureInfo = builder.failureInfo;
        this.jobStatus = builder.jobStatus;
        this.createdTimestamp = builder.createdTimestamp;
        this.completedTimestamp = builder.completedTimestamp;
        this.processedRecordsCount = builder.processedRecordsCount;
        this.failedRecordsCount = builder.failedRecordsCount;
    }

    public String jobId() {
        return this.jobId;
    }

    public ImportDestination importDestination() {
        return this.importDestination;
    }

    public ImportDataSource importDataSource() {
        return this.importDataSource;
    }

    public FailureInfo failureInfo() {
        return this.failureInfo;
    }

    public JobStatus jobStatus() {
        return JobStatus.fromValue(this.jobStatus);
    }

    public String jobStatusAsString() {
        return this.jobStatus;
    }

    public Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public Instant completedTimestamp() {
        return this.completedTimestamp;
    }

    public Integer processedRecordsCount() {
        return this.processedRecordsCount;
    }

    public Integer failedRecordsCount() {
        return this.failedRecordsCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.importDestination());
        hashCode = 31 * hashCode + Objects.hashCode(this.importDataSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.completedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.processedRecordsCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.failedRecordsCount());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetImportJobResponse)) {
            return false;
        }
        GetImportJobResponse other = (GetImportJobResponse)((Object)obj);
        return Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.importDestination(), other.importDestination()) && Objects.equals(this.importDataSource(), other.importDataSource()) && Objects.equals(this.failureInfo(), other.failureInfo()) && Objects.equals(this.jobStatusAsString(), other.jobStatusAsString()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp()) && Objects.equals(this.completedTimestamp(), other.completedTimestamp()) && Objects.equals(this.processedRecordsCount(), other.processedRecordsCount()) && Objects.equals(this.failedRecordsCount(), other.failedRecordsCount());
    }

    public String toString() {
        return ToString.builder((String)"GetImportJobResponse").add("JobId", (Object)this.jobId()).add("ImportDestination", (Object)this.importDestination()).add("ImportDataSource", (Object)this.importDataSource()).add("FailureInfo", (Object)this.failureInfo()).add("JobStatus", (Object)this.jobStatusAsString()).add("CreatedTimestamp", (Object)this.createdTimestamp()).add("CompletedTimestamp", (Object)this.completedTimestamp()).add("ProcessedRecordsCount", (Object)this.processedRecordsCount()).add("FailedRecordsCount", (Object)this.failedRecordsCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "ImportDestination": {
                return Optional.ofNullable(clazz.cast(this.importDestination()));
            }
            case "ImportDataSource": {
                return Optional.ofNullable(clazz.cast(this.importDataSource()));
            }
            case "FailureInfo": {
                return Optional.ofNullable(clazz.cast(this.failureInfo()));
            }
            case "JobStatus": {
                return Optional.ofNullable(clazz.cast(this.jobStatusAsString()));
            }
            case "CreatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
            case "CompletedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.completedTimestamp()));
            }
            case "ProcessedRecordsCount": {
                return Optional.ofNullable(clazz.cast(this.processedRecordsCount()));
            }
            case "FailedRecordsCount": {
                return Optional.ofNullable(clazz.cast(this.failedRecordsCount()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetImportJobResponse, T> g) {
        return obj -> g.apply((GetImportJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesV2Response.BuilderImpl
    implements Builder {
        private String jobId;
        private ImportDestination importDestination;
        private ImportDataSource importDataSource;
        private FailureInfo failureInfo;
        private String jobStatus;
        private Instant createdTimestamp;
        private Instant completedTimestamp;
        private Integer processedRecordsCount;
        private Integer failedRecordsCount;

        private BuilderImpl() {
        }

        private BuilderImpl(GetImportJobResponse model) {
            super(model);
            this.jobId(model.jobId);
            this.importDestination(model.importDestination);
            this.importDataSource(model.importDataSource);
            this.failureInfo(model.failureInfo);
            this.jobStatus(model.jobStatus);
            this.createdTimestamp(model.createdTimestamp);
            this.completedTimestamp(model.completedTimestamp);
            this.processedRecordsCount(model.processedRecordsCount);
            this.failedRecordsCount(model.failedRecordsCount);
        }

        public final String getJobId() {
            return this.jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final ImportDestination.Builder getImportDestination() {
            return this.importDestination != null ? this.importDestination.toBuilder() : null;
        }

        @Override
        public final Builder importDestination(ImportDestination importDestination) {
            this.importDestination = importDestination;
            return this;
        }

        public final void setImportDestination(ImportDestination.BuilderImpl importDestination) {
            this.importDestination = importDestination != null ? importDestination.build() : null;
        }

        public final ImportDataSource.Builder getImportDataSource() {
            return this.importDataSource != null ? this.importDataSource.toBuilder() : null;
        }

        @Override
        public final Builder importDataSource(ImportDataSource importDataSource) {
            this.importDataSource = importDataSource;
            return this;
        }

        public final void setImportDataSource(ImportDataSource.BuilderImpl importDataSource) {
            this.importDataSource = importDataSource != null ? importDataSource.build() : null;
        }

        public final FailureInfo.Builder getFailureInfo() {
            return this.failureInfo != null ? this.failureInfo.toBuilder() : null;
        }

        @Override
        public final Builder failureInfo(FailureInfo failureInfo) {
            this.failureInfo = failureInfo;
            return this;
        }

        public final void setFailureInfo(FailureInfo.BuilderImpl failureInfo) {
            this.failureInfo = failureInfo != null ? failureInfo.build() : null;
        }

        public final String getJobStatus() {
            return this.jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(JobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        public final Instant getCompletedTimestamp() {
            return this.completedTimestamp;
        }

        @Override
        public final Builder completedTimestamp(Instant completedTimestamp) {
            this.completedTimestamp = completedTimestamp;
            return this;
        }

        public final void setCompletedTimestamp(Instant completedTimestamp) {
            this.completedTimestamp = completedTimestamp;
        }

        public final Integer getProcessedRecordsCount() {
            return this.processedRecordsCount;
        }

        @Override
        public final Builder processedRecordsCount(Integer processedRecordsCount) {
            this.processedRecordsCount = processedRecordsCount;
            return this;
        }

        public final void setProcessedRecordsCount(Integer processedRecordsCount) {
            this.processedRecordsCount = processedRecordsCount;
        }

        public final Integer getFailedRecordsCount() {
            return this.failedRecordsCount;
        }

        @Override
        public final Builder failedRecordsCount(Integer failedRecordsCount) {
            this.failedRecordsCount = failedRecordsCount;
            return this;
        }

        public final void setFailedRecordsCount(Integer failedRecordsCount) {
            this.failedRecordsCount = failedRecordsCount;
        }

        @Override
        public GetImportJobResponse build() {
            return new GetImportJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SesV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetImportJobResponse> {
        public Builder jobId(String var1);

        public Builder importDestination(ImportDestination var1);

        default public Builder importDestination(Consumer<ImportDestination.Builder> importDestination) {
            return this.importDestination((ImportDestination)((ImportDestination.Builder)ImportDestination.builder().applyMutation(importDestination)).build());
        }

        public Builder importDataSource(ImportDataSource var1);

        default public Builder importDataSource(Consumer<ImportDataSource.Builder> importDataSource) {
            return this.importDataSource((ImportDataSource)((ImportDataSource.Builder)ImportDataSource.builder().applyMutation(importDataSource)).build());
        }

        public Builder failureInfo(FailureInfo var1);

        default public Builder failureInfo(Consumer<FailureInfo.Builder> failureInfo) {
            return this.failureInfo((FailureInfo)((FailureInfo.Builder)FailureInfo.builder().applyMutation(failureInfo)).build());
        }

        public Builder jobStatus(String var1);

        public Builder jobStatus(JobStatus var1);

        public Builder createdTimestamp(Instant var1);

        public Builder completedTimestamp(Instant var1);

        public Builder processedRecordsCount(Integer var1);

        public Builder failedRecordsCount(Integer var1);
    }
}

