/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DkimStatus {
    PENDING("PENDING"),
    SUCCESS("SUCCESS"),
    FAILED("FAILED"),
    TEMPORARY_FAILURE("TEMPORARY_FAILURE"),
    NOT_STARTED("NOT_STARTED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DkimStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DkimStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DkimStatus.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DkimStatus> knownValues() {
        return Stream.of(DkimStatus.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

