/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.servicecatalog.ServiceCatalogAsyncClient;
import software.amazon.awssdk.services.servicecatalog.model.SearchProductsAsAdminRequest;
import software.amazon.awssdk.services.servicecatalog.model.SearchProductsAsAdminResponse;

public class SearchProductsAsAdminPublisher
implements SdkPublisher<SearchProductsAsAdminResponse> {
    private final ServiceCatalogAsyncClient client;
    private final SearchProductsAsAdminRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchProductsAsAdminPublisher(ServiceCatalogAsyncClient client, SearchProductsAsAdminRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchProductsAsAdminPublisher(ServiceCatalogAsyncClient client, SearchProductsAsAdminRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchProductsAsAdminResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchProductsAsAdminResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class SearchProductsAsAdminResponseFetcher
    implements AsyncPageFetcher<SearchProductsAsAdminResponse> {
        private SearchProductsAsAdminResponseFetcher() {
        }

        public boolean hasNextPage(SearchProductsAsAdminResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public CompletableFuture<SearchProductsAsAdminResponse> nextPage(SearchProductsAsAdminResponse previousPage) {
            if (previousPage == null) {
                return SearchProductsAsAdminPublisher.this.client.searchProductsAsAdmin(SearchProductsAsAdminPublisher.this.firstRequest);
            }
            return SearchProductsAsAdminPublisher.this.client.searchProductsAsAdmin((SearchProductsAsAdminRequest)((Object)SearchProductsAsAdminPublisher.this.firstRequest.toBuilder().pageToken(previousPage.nextPageToken()).build()));
        }
    }
}

