/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.serverlessapplicationrepository.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.RollbackTrigger;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.___listOfRollbackTriggerCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RollbackConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RollbackConfiguration> {
    private static final SdkField<Integer> MONITORING_TIME_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MonitoringTimeInMinutes").getter(RollbackConfiguration.getter(RollbackConfiguration::monitoringTimeInMinutes)).setter(RollbackConfiguration.setter(Builder::monitoringTimeInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("monitoringTimeInMinutes").build()}).build();
    private static final SdkField<List<RollbackTrigger>> ROLLBACK_TRIGGERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RollbackTriggers").getter(RollbackConfiguration.getter(RollbackConfiguration::rollbackTriggers)).setter(RollbackConfiguration.setter(Builder::rollbackTriggers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rollbackTriggers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RollbackTrigger::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITORING_TIME_IN_MINUTES_FIELD, ROLLBACK_TRIGGERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer monitoringTimeInMinutes;
    private final List<RollbackTrigger> rollbackTriggers;

    private RollbackConfiguration(BuilderImpl builder) {
        this.monitoringTimeInMinutes = builder.monitoringTimeInMinutes;
        this.rollbackTriggers = builder.rollbackTriggers;
    }

    public final Integer monitoringTimeInMinutes() {
        return this.monitoringTimeInMinutes;
    }

    public final boolean hasRollbackTriggers() {
        return this.rollbackTriggers != null && !(this.rollbackTriggers instanceof SdkAutoConstructList);
    }

    public final List<RollbackTrigger> rollbackTriggers() {
        return this.rollbackTriggers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoringTimeInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRollbackTriggers() ? this.rollbackTriggers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RollbackConfiguration)) {
            return false;
        }
        RollbackConfiguration other = (RollbackConfiguration)obj;
        return Objects.equals(this.monitoringTimeInMinutes(), other.monitoringTimeInMinutes()) && this.hasRollbackTriggers() == other.hasRollbackTriggers() && Objects.equals(this.rollbackTriggers(), other.rollbackTriggers());
    }

    public final String toString() {
        return ToString.builder((String)"RollbackConfiguration").add("MonitoringTimeInMinutes", (Object)this.monitoringTimeInMinutes()).add("RollbackTriggers", this.hasRollbackTriggers() ? this.rollbackTriggers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MonitoringTimeInMinutes": {
                return Optional.ofNullable(clazz.cast(this.monitoringTimeInMinutes()));
            }
            case "RollbackTriggers": {
                return Optional.ofNullable(clazz.cast(this.rollbackTriggers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RollbackConfiguration, T> g) {
        return obj -> g.apply((RollbackConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer monitoringTimeInMinutes;
        private List<RollbackTrigger> rollbackTriggers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RollbackConfiguration model) {
            this.monitoringTimeInMinutes(model.monitoringTimeInMinutes);
            this.rollbackTriggers(model.rollbackTriggers);
        }

        public final Integer getMonitoringTimeInMinutes() {
            return this.monitoringTimeInMinutes;
        }

        @Override
        public final Builder monitoringTimeInMinutes(Integer monitoringTimeInMinutes) {
            this.monitoringTimeInMinutes = monitoringTimeInMinutes;
            return this;
        }

        public final void setMonitoringTimeInMinutes(Integer monitoringTimeInMinutes) {
            this.monitoringTimeInMinutes = monitoringTimeInMinutes;
        }

        public final List<RollbackTrigger.Builder> getRollbackTriggers() {
            List<RollbackTrigger.Builder> result = ___listOfRollbackTriggerCopier.copyToBuilder(this.rollbackTriggers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder rollbackTriggers(Collection<RollbackTrigger> rollbackTriggers) {
            this.rollbackTriggers = ___listOfRollbackTriggerCopier.copy(rollbackTriggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rollbackTriggers(RollbackTrigger ... rollbackTriggers) {
            this.rollbackTriggers(Arrays.asList(rollbackTriggers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rollbackTriggers(Consumer<RollbackTrigger.Builder> ... rollbackTriggers) {
            this.rollbackTriggers(Stream.of(rollbackTriggers).map(c -> (RollbackTrigger)((RollbackTrigger.Builder)RollbackTrigger.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRollbackTriggers(Collection<RollbackTrigger.BuilderImpl> rollbackTriggers) {
            this.rollbackTriggers = ___listOfRollbackTriggerCopier.copyFromBuilder(rollbackTriggers);
        }

        public RollbackConfiguration build() {
            return new RollbackConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RollbackConfiguration> {
        public Builder monitoringTimeInMinutes(Integer var1);

        public Builder rollbackTriggers(Collection<RollbackTrigger> var1);

        public Builder rollbackTriggers(RollbackTrigger ... var1);

        public Builder rollbackTriggers(Consumer<RollbackTrigger.Builder> ... var1);
    }
}

