/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.securityhub.model.FieldMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails> {
    private static final SdkField<Boolean> AUTOPROVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Autoprovision").getter(AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails.getter(AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails::autoprovision)).setter(AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails.setter(Builder::autoprovision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Autoprovision").build()}).build();
    private static final SdkField<String> DRIVER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Driver").getter(AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails.getter(AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails::driver)).setter(AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails.setter(Builder::driver)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Driver").build()}).build();
    private static final SdkField<Map<String, String>> DRIVER_OPTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("DriverOpts").getter(AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails.getter(AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails::driverOpts)).setter(AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails.setter(Builder::driverOpts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DriverOpts").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Labels").getter(AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails.getter(AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails::labels)).setter(AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails.setter(Builder::labels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Labels").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Scope").getter(AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails.getter(AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails::scope)).setter(AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails.setter(Builder::scope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTOPROVISION_FIELD, DRIVER_FIELD, DRIVER_OPTS_FIELD, LABELS_FIELD, SCOPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean autoprovision;
    private final String driver;
    private final Map<String, String> driverOpts;
    private final Map<String, String> labels;
    private final String scope;

    private AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails(BuilderImpl builder) {
        this.autoprovision = builder.autoprovision;
        this.driver = builder.driver;
        this.driverOpts = builder.driverOpts;
        this.labels = builder.labels;
        this.scope = builder.scope;
    }

    public final Boolean autoprovision() {
        return this.autoprovision;
    }

    public final String driver() {
        return this.driver;
    }

    public final boolean hasDriverOpts() {
        return this.driverOpts != null && !(this.driverOpts instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> driverOpts() {
        return this.driverOpts;
    }

    public final boolean hasLabels() {
        return this.labels != null && !(this.labels instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> labels() {
        return this.labels;
    }

    public final String scope() {
        return this.scope;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.autoprovision());
        hashCode = 31 * hashCode + Objects.hashCode(this.driver());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDriverOpts() ? this.driverOpts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLabels() ? this.labels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.scope());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails)) {
            return false;
        }
        AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails other = (AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails)obj;
        return Objects.equals(this.autoprovision(), other.autoprovision()) && Objects.equals(this.driver(), other.driver()) && this.hasDriverOpts() == other.hasDriverOpts() && Objects.equals(this.driverOpts(), other.driverOpts()) && this.hasLabels() == other.hasLabels() && Objects.equals(this.labels(), other.labels()) && Objects.equals(this.scope(), other.scope());
    }

    public final String toString() {
        return ToString.builder((String)"AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails").add("Autoprovision", (Object)this.autoprovision()).add("Driver", (Object)this.driver()).add("DriverOpts", this.hasDriverOpts() ? this.driverOpts() : null).add("Labels", this.hasLabels() ? this.labels() : null).add("Scope", (Object)this.scope()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Autoprovision": {
                return Optional.ofNullable(clazz.cast(this.autoprovision()));
            }
            case "Driver": {
                return Optional.ofNullable(clazz.cast(this.driver()));
            }
            case "DriverOpts": {
                return Optional.ofNullable(clazz.cast(this.driverOpts()));
            }
            case "Labels": {
                return Optional.ofNullable(clazz.cast(this.labels()));
            }
            case "Scope": {
                return Optional.ofNullable(clazz.cast(this.scope()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails, T> g) {
        return obj -> g.apply((AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean autoprovision;
        private String driver;
        private Map<String, String> driverOpts = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> labels = DefaultSdkAutoConstructMap.getInstance();
        private String scope;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails model) {
            this.autoprovision(model.autoprovision);
            this.driver(model.driver);
            this.driverOpts(model.driverOpts);
            this.labels(model.labels);
            this.scope(model.scope);
        }

        public final Boolean getAutoprovision() {
            return this.autoprovision;
        }

        @Override
        public final Builder autoprovision(Boolean autoprovision) {
            this.autoprovision = autoprovision;
            return this;
        }

        public final void setAutoprovision(Boolean autoprovision) {
            this.autoprovision = autoprovision;
        }

        public final String getDriver() {
            return this.driver;
        }

        @Override
        public final Builder driver(String driver) {
            this.driver = driver;
            return this;
        }

        public final void setDriver(String driver) {
            this.driver = driver;
        }

        public final Map<String, String> getDriverOpts() {
            if (this.driverOpts instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.driverOpts;
        }

        @Override
        public final Builder driverOpts(Map<String, String> driverOpts) {
            this.driverOpts = FieldMapCopier.copy(driverOpts);
            return this;
        }

        public final void setDriverOpts(Map<String, String> driverOpts) {
            this.driverOpts = FieldMapCopier.copy(driverOpts);
        }

        public final Map<String, String> getLabels() {
            if (this.labels instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.labels;
        }

        @Override
        public final Builder labels(Map<String, String> labels) {
            this.labels = FieldMapCopier.copy(labels);
            return this;
        }

        public final void setLabels(Map<String, String> labels) {
            this.labels = FieldMapCopier.copy(labels);
        }

        public final String getScope() {
            return this.scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        public AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails build() {
            return new AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails> {
        public Builder autoprovision(Boolean var1);

        public Builder driver(String var1);

        public Builder driverOpts(Map<String, String> var1);

        public Builder labels(Map<String, String> var1);

        public Builder scope(String var1);
    }
}

