/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshift.RedshiftAsyncClient;
import software.amazon.awssdk.services.redshift.model.GetReservedNodeExchangeOfferingsRequest;
import software.amazon.awssdk.services.redshift.model.GetReservedNodeExchangeOfferingsResponse;
import software.amazon.awssdk.services.redshift.model.ReservedNodeOffering;

public class GetReservedNodeExchangeOfferingsPublisher
implements SdkPublisher<GetReservedNodeExchangeOfferingsResponse> {
    private final RedshiftAsyncClient client;
    private final GetReservedNodeExchangeOfferingsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetReservedNodeExchangeOfferingsPublisher(RedshiftAsyncClient client, GetReservedNodeExchangeOfferingsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetReservedNodeExchangeOfferingsPublisher(RedshiftAsyncClient client, GetReservedNodeExchangeOfferingsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetReservedNodeExchangeOfferingsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetReservedNodeExchangeOfferingsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ReservedNodeOffering> reservedNodeOfferings() {
        Function<GetReservedNodeExchangeOfferingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.reservedNodeOfferings() != null) {
                return response.reservedNodeOfferings().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetReservedNodeExchangeOfferingsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetReservedNodeExchangeOfferingsResponseFetcher
    implements AsyncPageFetcher<GetReservedNodeExchangeOfferingsResponse> {
        private GetReservedNodeExchangeOfferingsResponseFetcher() {
        }

        public boolean hasNextPage(GetReservedNodeExchangeOfferingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<GetReservedNodeExchangeOfferingsResponse> nextPage(GetReservedNodeExchangeOfferingsResponse previousPage) {
            if (previousPage == null) {
                return GetReservedNodeExchangeOfferingsPublisher.this.client.getReservedNodeExchangeOfferings(GetReservedNodeExchangeOfferingsPublisher.this.firstRequest);
            }
            return GetReservedNodeExchangeOfferingsPublisher.this.client.getReservedNodeExchangeOfferings((GetReservedNodeExchangeOfferingsRequest)((Object)GetReservedNodeExchangeOfferingsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

